/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.converter.IndexableObjectConverter;
import org.dspace.app.rest.converter.SubmissionSectionConverter;
import org.dspace.app.rest.model.AInprogressSubmissionRest;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.model.EPersonRest;
import org.dspace.app.rest.model.ErrorRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.model.SubmissionDefinitionRest;
import org.dspace.app.rest.model.SubmissionSectionRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.submit.DataProcessingStep;
import org.dspace.app.rest.submit.RestProcessingStep;
import org.dspace.app.rest.submit.SubmissionService;
import org.dspace.app.util.SubmissionConfigReader;
import org.dspace.app.util.SubmissionConfigReaderException;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.content.Collection;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.eperson.EPerson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public abstract class AInprogressItemConverter<T extends InProgressSubmission, R extends AInprogressSubmissionRest>
implements IndexableObjectConverter<T, R> {
    private static final Logger log = LogManager.getLogger(AInprogressItemConverter.class);
    @Lazy
    @Autowired
    private ConverterService converter;
    @Autowired
    private SubmissionSectionConverter submissionSectionConverter;
    protected SubmissionConfigReader submissionConfigReader = new SubmissionConfigReader();
    @Autowired
    SubmissionService submissionService;

    protected void fillFromModel(T obj, R witem, Projection projection) {
        Collection collection = obj.getCollection();
        Item item = obj.getItem();
        EPerson submitter = null;
        submitter = obj.getSubmitter();
        ((BaseObjectRest)witem).setId((Integer)obj.getID());
        ((AInprogressSubmissionRest)witem).setCollection(collection != null ? (CollectionRest)this.converter.toRest(collection, projection) : null);
        ((AInprogressSubmissionRest)witem).setItem((ItemRest)this.converter.toRest(item, projection));
        if (submitter != null) {
            ((AInprogressSubmissionRest)witem).setSubmitter((EPersonRest)this.converter.toRest(submitter, projection));
        }
        if (collection != null) {
            SubmissionDefinitionRest def = (SubmissionDefinitionRest)this.converter.toRest(this.submissionConfigReader.getSubmissionConfigByCollection(collection.getHandle()), projection);
            ((AInprogressSubmissionRest)witem).setSubmissionDefinition(def);
            for (SubmissionSectionRest sections : def.getPanels()) {
                SubmissionStepConfig stepConfig = this.submissionSectionConverter.toModel(sections);
                ClassLoader loader = this.getClass().getClassLoader();
                try {
                    Class<?> stepClass = loader.loadClass(stepConfig.getProcessingClassName());
                    Object stepInstance = stepClass.newInstance();
                    if (stepInstance instanceof DataProcessingStep) {
                        DataProcessingStep stepProcessing = (DataProcessingStep)stepClass.newInstance();
                        for (ErrorRest error : stepProcessing.validate(this.submissionService, (InProgressSubmission)obj, stepConfig)) {
                            this.addError(((BaseObjectRest)witem).getErrors(), error);
                        }
                        ((AInprogressSubmissionRest)witem).getSections().put((String)sections.getId(), (Serializable)stepProcessing.getData(this.submissionService, (InProgressSubmission)obj, stepConfig));
                        continue;
                    }
                    if (stepInstance instanceof RestProcessingStep) continue;
                    log.warn("The submission step class specified by '" + stepConfig.getProcessingClassName() + "' does not implement the interface org.dspace.app.rest.submit.RestProcessingStep! Therefore it cannot be used by the Configurable Submission as the <processing-class>!");
                }
                catch (Exception e) {
                    log.error("An error occurred during the unmarshal of the data for the section " + (String)sections.getId() + " - reported error: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void addError(List<ErrorRest> errors, ErrorRest toAdd) {
        boolean found = false;
        String i18nKey = toAdd.getMessage();
        if (StringUtils.isNotBlank((CharSequence)i18nKey)) {
            for (ErrorRest error : errors) {
                if (!i18nKey.equals(error.getMessage())) continue;
                error.getPaths().addAll(toAdd.getPaths());
                found = true;
                break;
            }
        }
        if (!found) {
            errors.add(toAdd);
        }
    }
}

