/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.util.ArrayList;
import org.dspace.app.rest.converter.DSpaceConverter;
import org.dspace.app.rest.model.BrowseIndexRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.browse.BrowseIndex;
import org.dspace.sort.SortException;
import org.dspace.sort.SortOption;
import org.springframework.stereotype.Component;

@Component
public class BrowseIndexConverter
implements DSpaceConverter<BrowseIndex, BrowseIndexRest> {
    @Override
    public BrowseIndexRest convert(BrowseIndex obj, Projection projection) {
        BrowseIndexRest bir = new BrowseIndexRest();
        bir.setProjection(projection);
        bir.setId(obj.getName());
        bir.setDataType(obj.getDataType());
        bir.setOrder(obj.getDefaultOrder());
        bir.setMetadataBrowse(obj.isMetadataIndex());
        ArrayList<String> metadataList = new ArrayList<String>();
        if (obj.isMetadataIndex()) {
            for (String s : obj.getMetadata().split(",")) {
                metadataList.add(s.trim());
            }
        } else {
            metadataList.add(obj.getSortOption().getMetadata());
        }
        bir.setMetadataList(metadataList);
        ArrayList<BrowseIndexRest.SortOption> sortOptionsList = new ArrayList<BrowseIndexRest.SortOption>();
        try {
            for (SortOption so : SortOption.getSortOptions()) {
                sortOptionsList.add(new BrowseIndexRest.SortOption(so.getName(), so.getMetadata()));
            }
        }
        catch (SortException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        bir.setSortOptions(sortOptionsList);
        return bir;
    }

    @Override
    public Class<BrowseIndex> getModelClass() {
        return BrowseIndex.class;
    }
}

