/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.model.WorkflowStepRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.core.Context;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.dspace.xmlworkflow.storedcomponents.ClaimedTask;
import org.dspace.xmlworkflow.storedcomponents.service.ClaimedTaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.stereotype.Component;

@Component(value="workflow.claimedtask.step")
public class ClaimedTaskStepLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    private ClaimedTaskService claimedTaskService;
    @Autowired
    private XmlWorkflowFactory xmlWorkflowFactory;

    public WorkflowStepRest getStep(@Nullable HttpServletRequest request, Integer claimedTaskId, @Nullable Pageable optionalPageable, Projection projection) {
        Context context = this.obtainContext();
        try {
            ClaimedTask claimedTask = (ClaimedTask)this.claimedTaskService.find(context, claimedTaskId.intValue());
            if (claimedTask == null) {
                throw new ResourceNotFoundException("ClaimedTask with id: " + claimedTaskId + " wasn't found");
            }
            return (WorkflowStepRest)this.converter.toRest(this.xmlWorkflowFactory.getStepByName(claimedTask.getStepID()), projection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

