/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.DiscoverableEndpointsService;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.EPersonNameNotProvidedException;
import org.dspace.app.rest.exception.PasswordNotValidException;
import org.dspace.app.rest.exception.RESTEmptyWorkflowGroupException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.EPersonRest;
import org.dspace.app.rest.model.MetadataRest;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.repository.DSpaceObjectRestRepository;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ValidatePasswordService;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.EmptyWorkflowGroupException;
import org.dspace.eperson.RegistrationData;
import org.dspace.eperson.service.AccountService;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.RegistrationDataService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.Link;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="eperson.eperson")
public class EPersonRestRepository
extends DSpaceObjectRestRepository<EPerson, EPersonRest>
implements InitializingBean {
    private static final Logger log = LogManager.getLogger();
    @Autowired
    AuthorizeService authorizeService;
    @Autowired
    DiscoverableEndpointsService discoverableEndpointsService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private ValidatePasswordService validatePasswordService;
    @Autowired
    private RegistrationDataService registrationDataService;
    private final EPersonService es;

    public EPersonRestRepository(EPersonService dsoService) {
        super(dsoService);
        this.es = dsoService;
    }

    @Override
    protected EPersonRest createAndReturn(Context context) throws AuthorizeException {
        HttpServletRequest req = this.getRequestService().getCurrentRequest().getHttpServletRequest();
        ObjectMapper mapper = new ObjectMapper();
        EPersonRest epersonRest = null;
        try {
            epersonRest = (EPersonRest)mapper.readValue((InputStream)req.getInputStream(), EPersonRest.class);
        }
        catch (IOException e1) {
            throw new UnprocessableEntityException("error parsing the body... maybe this is not the right error code");
        }
        String token = req.getParameter("token");
        if (StringUtils.isNotBlank((CharSequence)token)) {
            try {
                return this.createAndReturn(context, epersonRest, token);
            }
            catch (SQLException e) {
                log.error("Something went wrong in the creation of an EPerson with token: " + token, (Throwable)e);
                throw new RuntimeException("Something went wrong in the creation of an EPerson with token: " + token);
            }
        }
        EPerson eperson = this.createEPersonFromRestObject(context, epersonRest);
        return (EPersonRest)this.converter.toRest(eperson, this.utils.obtainProjection());
    }

    private EPerson createEPersonFromRestObject(Context context, EPersonRest epersonRest) throws AuthorizeException {
        EPerson eperson = null;
        try {
            eperson = this.es.create(context);
            eperson.setCanLogIn(epersonRest.isCanLogIn());
            eperson.setRequireCertificate(epersonRest.isRequireCertificate());
            eperson.setEmail(epersonRest.getEmail());
            eperson.setNetid(epersonRest.getNetid());
            if (epersonRest.getPassword() != null) {
                if (!this.validatePasswordService.isPasswordValid(epersonRest.getPassword())) {
                    throw new PasswordNotValidException();
                }
                this.es.setPassword(eperson, epersonRest.getPassword());
            }
            this.es.update(context, (DSpaceObject)eperson);
            this.metadataConverter.setMetadata(context, eperson, epersonRest.getMetadata());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return eperson;
    }

    private EPersonRest createAndReturn(Context context, EPersonRest epersonRest, String token) throws AuthorizeException, SQLException {
        if (!AuthorizeUtil.authorizeNewAccountRegistration((Context)context, (HttpServletRequest)this.requestService.getCurrentRequest().getHttpServletRequest())) {
            throw new DSpaceBadRequestException("Registration is disabled, you are not authorized to create a new Authorization");
        }
        RegistrationData registrationData = this.registrationDataService.findByToken(context, token);
        if (registrationData == null) {
            throw new DSpaceBadRequestException("The token given as parameter: " + token + " does not exist in the database");
        }
        if (this.es.findByEmail(context, registrationData.getEmail()) != null) {
            throw new DSpaceBadRequestException("The token given already contains an email address that resolves to an eperson");
        }
        String emailFromJson = epersonRest.getEmail();
        if (StringUtils.isNotBlank((CharSequence)emailFromJson) && !StringUtils.equalsIgnoreCase((CharSequence)registrationData.getEmail(), (CharSequence)emailFromJson)) {
            throw new DSpaceBadRequestException("The email resulting from the token does not match the email given in the json body. Email from token: " + registrationData.getEmail() + " email from the json body: " + emailFromJson);
        }
        if (epersonRest.isSelfRegistered() != null && !epersonRest.isSelfRegistered().booleanValue()) {
            throw new DSpaceBadRequestException("The self registered property cannot be set to false using this method with a token");
        }
        this.checkRequiredProperties(epersonRest);
        context.turnOffAuthorisationSystem();
        EPerson ePerson = this.createEPersonFromRestObject(context, epersonRest);
        context.restoreAuthSystemState();
        this.accountService.deleteToken(context, token);
        if (context.getCurrentUser() == null) {
            context.setCurrentUser(ePerson);
        }
        return (EPersonRest)this.converter.toRest(ePerson, this.utils.obtainProjection());
    }

    private void checkRequiredProperties(EPersonRest epersonRest) {
        String password;
        MetadataRest metadataRest = epersonRest.getMetadata();
        if (metadataRest != null) {
            List epersonFirstName = (List)metadataRest.getMap().get("eperson.firstname");
            List epersonLastName = (List)metadataRest.getMap().get("eperson.lastname");
            if (epersonFirstName == null || epersonLastName == null || epersonFirstName.isEmpty() || epersonLastName.isEmpty()) {
                throw new EPersonNameNotProvidedException();
            }
        }
        if (StringUtils.isBlank((CharSequence)(password = epersonRest.getPassword()))) {
            throw new DSpaceBadRequestException("A password is required");
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#id, 'EPERSON', 'READ')")
    public EPersonRest findOne(Context context, UUID id) {
        EPerson eperson = null;
        try {
            eperson = (EPerson)this.es.find(context, id);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (eperson == null) {
            return null;
        }
        return (EPersonRest)this.converter.toRest(eperson, this.utils.obtainProjection());
    }

    @Override
    @PreAuthorize(value="hasAuthority('ADMIN')")
    public Page<EPersonRest> findAll(Context context, Pageable pageable) {
        try {
            long total = this.es.countTotal(context);
            List epersons = this.es.findAll(context, 1, pageable.getPageSize(), Math.toIntExact(pageable.getOffset()));
            return this.converter.toRestPage(epersons, pageable, total, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @SearchRestMethod(name="byEmail")
    public EPersonRest findByEmail(@Parameter(value="email", required=true) String email) {
        EPerson eperson = null;
        try {
            Context context = this.obtainContext();
            eperson = this.es.findByEmail(context, email);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (eperson == null) {
            return null;
        }
        return (EPersonRest)this.converter.toRest(eperson, this.utils.obtainProjection());
    }

    @PreAuthorize(value="hasAuthority('ADMIN') || hasAuthority('MANAGE_ACCESS_GROUP')")
    @SearchRestMethod(name="byMetadata")
    public Page<EPersonRest> findByMetadata(@Parameter(value="query", required=true) String query, Pageable pageable) {
        try {
            Context context = this.obtainContext();
            long total = this.es.searchResultCount(context, query);
            List epersons = this.es.search(context, query, Math.toIntExact(pageable.getOffset()), Math.toIntExact(pageable.getPageSize()));
            return this.converter.toRestPage(epersons, pageable, total, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#uuid, 'EPERSON', #patch)")
    protected void patch(Context context, HttpServletRequest request, String apiCategory, String model, UUID uuid, Patch patch) throws AuthorizeException, SQLException {
        boolean passwordChangeFound = false;
        for (Operation operation : patch.getOperations()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)operation.getPath(), (CharSequence)"/password")) continue;
            passwordChangeFound = true;
        }
        if (StringUtils.isNotBlank((CharSequence)request.getParameter("token"))) {
            if (!passwordChangeFound) {
                throw new AccessDeniedException("Refused to perform the EPerson patch based on a token without changing the password");
            }
        } else if (passwordChangeFound && !StringUtils.equals((CharSequence)context.getAuthenticationMethod(), (CharSequence)"password")) {
            throw new AccessDeniedException("Refused to perform the EPerson patch based to change the password for non \"password\" authentication");
        }
        this.patchDSpaceObject(apiCategory, model, uuid, patch);
    }

    @Override
    protected void delete(Context context, UUID id) throws AuthorizeException {
        EPerson eperson = null;
        try {
            eperson = (EPerson)this.es.find(context, id);
            this.es.delete(context, (DSpaceObject)eperson);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (EmptyWorkflowGroupException e) {
            throw new RESTEmptyWorkflowGroupException(e);
        }
        catch (IllegalStateException e) {
            throw new UnprocessableEntityException(e.getMessage(), e);
        }
    }

    @Override
    public Class<EPersonRest> getDomainClass() {
        return EPersonRest.class;
    }

    public void afterPropertiesSet() throws Exception {
        this.discoverableEndpointsService.register(this, Arrays.asList(Link.of((String)"/api/eperson/registrations", (String)"eperson-registration")));
    }
}

