/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.model.DSpaceObjectRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="eperson.group.object")
public class GroupParentObjectLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    GroupService groupService;
    @Autowired
    private AuthorizeService authorizeService;

    @PreAuthorize(value="hasPermission(#groupId, 'GROUP', 'READ') or hasAuthority('ADMIN')")
    public DSpaceObjectRest getParentObject(@Nullable HttpServletRequest request, UUID groupId, @Nullable Pageable optionalPageable, Projection projection) {
        Context context = this.obtainContext();
        try {
            Group group = (Group)this.groupService.find(context, groupId);
            if (group == null) {
                throw new ResourceNotFoundException("eperson.group with id: " + groupId + " not found");
            }
            DSpaceObject parent = this.groupService.getParentObject(context, (DSpaceObject)group);
            if (parent != null) {
                return (DSpaceObjectRest)this.converter.toRest(parent, this.utils.obtainProjection());
            }
            return null;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

