/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.io.Serializable;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.security.DSpaceRestPermission;
import org.dspace.app.rest.security.RestObjectPermissionEvaluatorPlugin;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.orcid.OrcidHistory;
import org.dspace.orcid.OrcidQueue;
import org.dspace.orcid.service.OrcidHistoryService;
import org.dspace.orcid.service.OrcidQueueService;
import org.dspace.services.RequestService;
import org.dspace.services.model.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class OrcidQueueAndHistoryRestPermissionEvaluatorPlugin
extends RestObjectPermissionEvaluatorPlugin {
    private static final Logger log = LoggerFactory.getLogger(OrcidQueueAndHistoryRestPermissionEvaluatorPlugin.class);
    public static final String ORCID_QUEUE = "ORCID_QUEUE";
    public static final String ORCID_HISTORY = "ORCID_HISTORY";
    @Autowired
    private RequestService requestService;
    @Autowired
    private OrcidQueueService orcidQueueService;
    @Autowired
    private OrcidHistoryService orcidHistoryService;
    @Autowired
    private ItemService itemService;

    @Override
    public boolean hasDSpacePermission(Authentication authentication, Serializable targetId, String targetType, DSpaceRestPermission permission) {
        DSpaceRestPermission restPermission = DSpaceRestPermission.convert((Object)permission);
        if (!DSpaceRestPermission.READ.equals((Object)restPermission) && !DSpaceRestPermission.DELETE.equals((Object)restPermission)) {
            return false;
        }
        if (!ORCID_QUEUE.equals(targetType) && !ORCID_HISTORY.equals(targetType)) {
            return false;
        }
        Request request = this.requestService.getCurrentRequest();
        Context context = ContextUtil.obtainContext(request.getHttpServletRequest());
        EPerson currentUser = context.getCurrentUser();
        Integer orcidObjectId = Integer.parseInt(targetId.toString());
        if (currentUser == null || currentUser.getID() == null) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)targetId.toString())) {
            return true;
        }
        return this.hasAccess(context, currentUser, orcidObjectId, targetType.equals(ORCID_QUEUE));
    }

    private boolean hasAccess(Context context, EPerson currentUser, Integer orcidObjectId, boolean isOrcidQueueRecord) {
        try {
            Item profileItem = this.findProfileItem(context, orcidObjectId, isOrcidQueueRecord);
            if (profileItem == null) {
                return true;
            }
            return this.itemService.getMetadata((DSpaceObject)profileItem, "dspace", "object", "owner", "*").stream().map(metadataValue -> metadataValue.getAuthority()).anyMatch(authority -> currentUser.getID().toString().equals(authority));
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private Item findProfileItem(Context context, Integer orcidObjectId, boolean isOrcidQueueRecord) throws SQLException {
        if (isOrcidQueueRecord) {
            OrcidQueue orcidQueue = this.orcidQueueService.find(context, orcidObjectId.intValue());
            return orcidQueue != null ? orcidQueue.getProfileItem() : null;
        }
        OrcidHistory orcidHistory = this.orcidHistoryService.find(context, orcidObjectId.intValue());
        return orcidHistory != null ? orcidHistory.getProfileItem() : null;
    }
}

