/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.util.stream.Collectors;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.converter.DSpaceConverter;
import org.dspace.app.rest.model.WorkflowDefinitionRest;
import org.dspace.app.rest.model.WorkflowStepRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.dspace.xmlworkflow.state.Workflow;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class WorkflowDefinitionConverter
implements DSpaceConverter<Workflow, WorkflowDefinitionRest> {
    @Autowired
    protected XmlWorkflowFactory xmlWorkflowFactory;
    @Lazy
    @Autowired
    ConverterService converter;

    public WorkflowDefinitionRest convert(Workflow modelObject, Projection projection) {
        WorkflowDefinitionRest restModel = new WorkflowDefinitionRest();
        restModel.setName(modelObject.getID());
        restModel.setIsDefault(this.xmlWorkflowFactory.isDefaultWorkflow(modelObject.getID()));
        restModel.setProjection(projection);
        restModel.setSteps(modelObject.getSteps().stream().map(x -> (WorkflowStepRest)this.converter.toRest(x, projection)).collect(Collectors.toList()));
        return restModel;
    }

    public Class<Workflow> getModelClass() {
        return Workflow.class;
    }
}

