/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.link;

import java.util.LinkedList;
import java.util.List;
import org.dspace.app.rest.model.hateoas.HALResource;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public abstract class HalLinkFactory<RESOURCE, CONTROLLER> {
    public boolean supports(Class clazz) {
        return this.getResourceClass().isAssignableFrom(clazz);
    }

    public List<Link> getLinksFor(HALResource halResource, Pageable pageable) throws Exception {
        LinkedList<Link> list = new LinkedList<Link>();
        if (halResource != null && this.supports(halResource.getClass())) {
            this.addLinks((Object)halResource, pageable, list);
        }
        return list;
    }

    protected <T> Link buildLink(String rel, T data) {
        UriComponentsBuilder uriComponentsBuilder = this.uriBuilder(data);
        return this.buildLink(rel, uriComponentsBuilder.build().toUriString());
    }

    protected <T> UriComponentsBuilder uriBuilder(T data) {
        return WebMvcLinkBuilder.linkTo(data).toUriComponentsBuilder();
    }

    protected Link buildLink(String rel, String href) {
        return Link.of((String)href, (String)rel);
    }

    protected CONTROLLER getMethodOn(Object ... parameters) {
        return (CONTROLLER)WebMvcLinkBuilder.methodOn((Class)this.getControllerClass(), (Object[])parameters);
    }

    protected <C> C getMethodOn(Class<C> clazz) {
        return (C)WebMvcLinkBuilder.methodOn(clazz, (Object[])new Object[0]);
    }

    protected abstract void addLinks(RESOURCE var1, Pageable var2, LinkedList<Link> var3) throws Exception;

    protected abstract Class<CONTROLLER> getControllerClass();

    protected abstract Class<RESOURCE> getResourceClass();
}

