/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.dspace.app.rest.model.EntityTypeRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.content.service.EntityTypeService;
import org.dspace.core.Context;
import org.dspace.external.provider.AbstractExternalDataProvider;
import org.dspace.external.service.ExternalDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.stereotype.Component;

@Component(value="integration.externalsource.entityTypes")
public class ExternalSourceEntityTypeLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    private EntityTypeService entityTypeService;
    @Autowired
    private ExternalDataService externalDataService;

    public Page<EntityTypeRest> getSupportedEntityTypes(@Nullable HttpServletRequest request, String externalSourceName, @Nullable Pageable pageable, Projection projection) {
        Context context = ContextUtil.obtainContext((HttpServletRequest)request);
        List entityTypes = Collections.emptyList();
        AbstractExternalDataProvider externalDataProvider = (AbstractExternalDataProvider)this.externalDataService.getExternalDataProvider(externalSourceName);
        if (Objects.isNull(externalDataProvider)) {
            throw new ResourceNotFoundException("No such ExternalDataProvider: " + externalSourceName);
        }
        int total = 0;
        List supportedEntityTypes = externalDataProvider.getSupportedEntityTypes();
        try {
            if (CollectionUtils.isNotEmpty((Collection)supportedEntityTypes)) {
                entityTypes = this.entityTypeService.getEntityTypesByNames(context, supportedEntityTypes, Integer.valueOf(Math.toIntExact(pageable.getPageSize())), Integer.valueOf(Math.toIntExact(pageable.getOffset())));
                total = this.entityTypeService.countEntityTypesByNames(context, supportedEntityTypes);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return this.converter.toRestPage(entityTypes, pageable, (long)total, this.utils.obtainProjection());
    }
}

