/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.model.ProcessFileTypesRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.scripts.Process;
import org.dspace.scripts.service.ProcessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="system.process.filetypes")
public class ProcessFileTypesLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    private ProcessService processService;

    @PreAuthorize(value="hasAuthority('ADMIN')")
    public ProcessFileTypesRest getFileTypesFromProcess(@Nullable HttpServletRequest request, Integer processId, @Nullable Pageable optionalPageable, Projection projection) throws SQLException, AuthorizeException {
        Context context = this.obtainContext();
        Process process = this.processService.find(context, processId.intValue());
        if (process == null) {
            throw new ResourceNotFoundException("Process with id " + processId + " was not found");
        }
        List fileTypes = this.processService.getFileTypesForProcessBitstreams(context, process);
        ProcessFileTypesRest processFileTypesRest = new ProcessFileTypesRest();
        processFileTypesRest.setId((Serializable)((Object)("filetypes-" + processId)));
        processFileTypesRest.setValues(fileTypes);
        return processFileTypesRest;
    }
}

