/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.model.VersionHistoryRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.core.Context;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.service.VersionHistoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="versioning.versionhistory")
public class VersionHistoryRestRepository
extends DSpaceRestRepository<VersionHistoryRest, Integer> {
    private static final Logger log = LogManager.getLogger(VersionHistoryRestRepository.class);
    @Autowired
    private VersionHistoryService versionHistoryService;
    @Autowired
    private ConverterService converterService;

    @PreAuthorize(value="@versioningSecurity.isEnableVersioning() && hasPermission(#id, 'VERSIONHISTORY', 'READ')")
    public VersionHistoryRest findOne(Context context, Integer id) {
        try {
            VersionHistory versionHistory = (VersionHistory)this.versionHistoryService.find(context, id.intValue());
            if (versionHistory == null) {
                throw new ResourceNotFoundException("Couldn't find version for id: " + id);
            }
            return (VersionHistoryRest)this.converterService.toRest((Object)versionHistory, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            log.error("Something with wrong getting version with id:" + id, (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Page<VersionHistoryRest> findAll(Context context, Pageable pageable) {
        throw new RepositoryMethodNotImplementedException("No implementation found; Method not allowed!", "");
    }

    public Class<VersionHistoryRest> getDomainClass() {
        return VersionHistoryRest.class;
    }
}

