/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.utils;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import javax.mail.internet.MimeUtility;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpHeadersInitializer {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String METHOD_HEAD = "HEAD";
    private static final String MULTIPART_BOUNDARY = "MULTIPART_BYTERANGES";
    private static final String CONTENT_TYPE_MULTITYPE_WITH_BOUNDARY = "multipart/byteranges; boundary=MULTIPART_BYTERANGES";
    public static final String CONTENT_DISPOSITION_INLINE = "inline";
    public static final String CONTENT_DISPOSITION_ATTACHMENT = "attachment";
    private static final String IF_NONE_MATCH = "If-None-Match";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String ETAG = "ETag";
    private static final String IF_MATCH = "If-Match";
    private static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String ACCEPT_RANGES = "Accept-Ranges";
    private static final String BYTES = "bytes";
    private static final String LAST_MODIFIED = "Last-Modified";
    private static final String EXPIRES = "Expires";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String IMAGE = "image";
    private static final String ACCEPT = "Accept";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String CONTENT_DISPOSITION_FORMAT = "%s;filename=\"%s\"";
    private static final String CACHE_CONTROL = "Cache-Control";
    private int bufferSize = 1000000;
    private static final long DEFAULT_EXPIRE_TIME = 3600000L;
    private static final String CACHE_CONTROL_SETTING = "private,no-cache";
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String contentType;
    private String disposition;
    private long lastModified;
    private long length;
    private String fileName;
    private String checksum;

    public HttpHeadersInitializer with(HttpServletRequest httpRequest) {
        this.request = httpRequest;
        return this;
    }

    public HttpHeadersInitializer with(HttpServletResponse httpResponse) {
        this.response = httpResponse;
        return this;
    }

    public HttpHeadersInitializer withLength(long length) {
        this.length = length;
        return this;
    }

    public HttpHeadersInitializer withFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public HttpHeadersInitializer withChecksum(String checksum) {
        this.checksum = checksum;
        return this;
    }

    public HttpHeadersInitializer withMimetype(String mimetype) {
        this.contentType = mimetype;
        return this;
    }

    public HttpHeadersInitializer withLastModified(long lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    public HttpHeadersInitializer withBufferSize(int bufferSize) {
        if (bufferSize > 0) {
            this.bufferSize = bufferSize;
        }
        return this;
    }

    public HttpHeadersInitializer withDisposition(String contentDisposition) {
        this.disposition = contentDisposition;
        return this;
    }

    public HttpHeaders initialiseHeaders() throws IOException {
        HttpHeaders httpHeaders = new HttpHeaders();
        this.log.debug("Content-Type : {}", (Object)this.contentType);
        this.response.setBufferSize(this.bufferSize);
        if (this.contentType != null) {
            httpHeaders.put("Content-Type", Collections.singletonList(this.contentType));
        }
        httpHeaders.put("Accept-Ranges", Collections.singletonList("bytes"));
        if (this.checksum != null) {
            httpHeaders.put("ETag", Collections.singletonList(this.checksum));
        }
        httpHeaders.put("Last-Modified", Collections.singletonList(FastHttpDateFormat.formatDate((long)this.lastModified)));
        httpHeaders.put("Expires", Collections.singletonList(FastHttpDateFormat.formatDate((long)(System.currentTimeMillis() + 3600000L))));
        httpHeaders.put("Cache-Control", Collections.singletonList("private,no-cache"));
        if (HttpHeadersInitializer.isNullOrEmpty((String)this.disposition)) {
            if (this.contentType == null) {
                this.contentType = "application/octet-stream";
            } else if (!this.contentType.startsWith("image")) {
                String accept = this.request.getHeader("Accept");
                this.disposition = accept != null && HttpHeadersInitializer.accepts((String)accept, (String)this.contentType) ? "inline" : "attachment";
            }
        }
        httpHeaders.put("Content-Disposition", Collections.singletonList(String.format("%s;filename=\"%s\"", this.disposition, MimeUtility.encodeText((String)this.fileName))));
        this.log.debug("Content-Disposition : {}", (Object)this.disposition);
        if ("HEAD".equals(this.request.getMethod())) {
            this.log.debug("HEAD request - skipping content");
            return null;
        }
        return httpHeaders;
    }

    public boolean isValid() throws IOException {
        if (this.response == null || this.request == null) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.fileName)) {
            this.response.sendError(500);
            return false;
        }
        String ifNoneMatch = this.request.getHeader("If-None-Match");
        if (Objects.nonNull(ifNoneMatch) && HttpHeadersInitializer.matches((String)ifNoneMatch, (String)this.checksum)) {
            this.log.debug("If-None-Match header should contain \"*\" or ETag. If so, then return 304.");
            this.response.setHeader("ETag", this.checksum);
            this.response.sendError(304);
            return false;
        }
        long ifModifiedSince = this.request.getDateHeader("If-Modified-Since");
        if (Objects.isNull(ifNoneMatch) && ifModifiedSince != -1L && ifModifiedSince + 1000L > this.lastModified) {
            this.log.debug("If-Modified-Since header should be greater than LastModified. If so, then return 304.");
            this.response.setHeader("ETag", this.checksum);
            this.response.sendError(304);
            return false;
        }
        String ifMatch = this.request.getHeader("If-Match");
        if (Objects.nonNull(ifMatch) && !HttpHeadersInitializer.matches((String)ifMatch, (String)this.checksum)) {
            this.log.error("If-Match header should contain \"*\" or ETag. If not, then return 412.");
            this.response.sendError(416);
            return false;
        }
        long ifUnmodifiedSince = this.request.getDateHeader("If-Unmodified-Since");
        if (ifUnmodifiedSince != -1L && ifUnmodifiedSince + 1000L <= this.lastModified) {
            this.log.error("If-Unmodified-Since header should be greater than LastModified. If not, then return 412.");
            this.response.sendError(412);
            return false;
        }
        return true;
    }

    private static boolean isNullOrEmpty(String disposition) {
        return StringUtils.isBlank((CharSequence)disposition);
    }

    private static boolean accepts(String acceptHeader, String toAccept) {
        Object[] acceptValues = acceptHeader.split("\\s*(,|;)\\s*");
        Arrays.sort(acceptValues);
        return Arrays.binarySearch(acceptValues, toAccept) > -1 || Arrays.binarySearch(acceptValues, toAccept.replaceAll("/.*$", "/*")) > -1 || Arrays.binarySearch(acceptValues, "*/*") > -1;
    }

    private static boolean matches(String matchHeader, String toMatch) {
        Object[] matchValues = matchHeader.split("\\s*,\\s*");
        Arrays.sort(matchValues);
        return Arrays.binarySearch(matchValues, toMatch) > -1 || Arrays.binarySearch(matchValues, "*") > -1;
    }
}

