/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemexport;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.converter.DSpaceRunnableParameterConverter;
import org.dspace.app.rest.matcher.ProcessMatcher;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.ProcessBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.ProcessStatus;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.scripts.DSpaceCommandLineParameter;
import org.dspace.scripts.Process;
import org.dspace.scripts.service.ProcessService;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class ItemExportIT
extends AbstractControllerIntegrationTest {
    private static final String title = "A Tale of Two Cities";
    private static final String dateIssued = "1990";
    private static final String titleAlternative = "J'aime les Printemps";
    @Autowired
    private ItemService itemService;
    @Autowired
    private CollectionService collectionService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private DSpaceRunnableParameterConverter dSpaceRunnableParameterConverter;
    private Collection collection;
    private Path workDir;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        this.collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection").withEntityType("Publication").build();
        this.context.restoreAuthSystemState();
        File file = new File(this.configurationService.getProperty("org.dspace.app.itemexport.work.dir"));
        if (!file.exists()) {
            Files.createDirectory(Path.of(file.getAbsolutePath(), new String[0]), new FileAttribute[0]);
        }
        this.workDir = Path.of(file.getAbsolutePath(), new String[0]);
    }

    @After
    public void destroy() throws Exception {
        for (Path path : Files.list(this.workDir).collect(Collectors.toList())) {
            PathUtils.delete((Path)path);
        }
        super.destroy();
    }

    @Test
    public void exportCollection() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item1 = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle(title).withMetadata("dc", "date", "issued", dateIssued).withMetadata("dc", "title", "alternative", titleAlternative).build();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("A Tale of Two Cities 2").withMetadata("dc", "date", "issued", dateIssued).withMetadata("dc", "title", "alternative", titleAlternative).build();
        this.context.restoreAuthSystemState();
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-t", "COLLECTION"));
        parameters.add(new DSpaceCommandLineParameter("-i", this.collection.getHandle()));
        this.perfomExportScript(parameters);
        this.checkCollection();
    }

    @Test
    public void exportItemWithMetadataOnly() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle(title).withMetadata("dc", "date", "issued", dateIssued).withMetadata("dc", "title", "alternative", titleAlternative).build();
        this.context.restoreAuthSystemState();
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-t", "ITEM"));
        parameters.add(new DSpaceCommandLineParameter("-i", item.getHandle()));
        this.perfomExportScript(parameters);
        this.checkItem(item);
    }

    @Test
    public void exportItemWithBitstreams() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle(title).withMetadata("dc", "date", "issued", dateIssued).withMetadata("dc", "title", "alternative", titleAlternative).build();
        String bitstreamContent = "TEST TEST TEST";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            Bitstream bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withName("Bitstream").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-t", "ITEM"));
        parameters.add(new DSpaceCommandLineParameter("-i", item.getHandle()));
        this.perfomExportScript(parameters);
        this.checkItem(item);
    }

    @Test
    public void exportItemWithAnotherMetadataSchema() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle(title).withMetadata("dc", "date", "issued", dateIssued).withMetadata("dc", "title", "alternative", titleAlternative).withMetadata("dcterms", "title", "", title).build();
        this.context.restoreAuthSystemState();
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-t", "ITEM"));
        parameters.add(new DSpaceCommandLineParameter("-i", item.getHandle()));
        this.perfomExportScript(parameters);
        this.checkItem(item);
    }

    @Test
    public void migrateCollection() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item1 = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle(title).withMetadata("dc", "date", "issued", dateIssued).withMetadata("dc", "title", "alternative", titleAlternative).build();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("A Tale of Two Cities 2").withMetadata("dc", "date", "issued", dateIssued).withMetadata("dc", "title", "alternative", titleAlternative).build();
        this.context.restoreAuthSystemState();
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-t", "COLLECTION"));
        parameters.add(new DSpaceCommandLineParameter("-i", this.collection.getHandle()));
        parameters.add(new DSpaceCommandLineParameter("-m", ""));
        this.perfomExportScript(parameters);
        this.checkCollection();
        this.checkItem(item1);
        this.checkItem(item2);
    }

    @Test
    public void migrateItemWithMetadataOnly() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle(title).withMetadata("dc", "date", "issued", dateIssued).withMetadata("dc", "title", "alternative", titleAlternative).build();
        this.context.restoreAuthSystemState();
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-t", "ITEM"));
        parameters.add(new DSpaceCommandLineParameter("-i", item.getHandle()));
        parameters.add(new DSpaceCommandLineParameter("-m", ""));
        this.perfomExportScript(parameters);
        this.checkItem(item);
    }

    @Test
    public void migrateItemWithBitstreams() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle(title).withMetadata("dc", "date", "issued", dateIssued).withMetadata("dc", "title", "alternative", titleAlternative).build();
        String bitstreamContent = "TEST TEST TEST";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            Bitstream bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withName("Bitstream").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-t", "ITEM"));
        parameters.add(new DSpaceCommandLineParameter("-i", item.getHandle()));
        parameters.add(new DSpaceCommandLineParameter("-m", ""));
        this.perfomExportScript(parameters);
        this.checkItem(item);
    }

    @Test
    public void migrateItemWithAnotherMetadataSchema() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle(title).withMetadata("dc", "date", "issued", dateIssued).withMetadata("dc", "title", "alternative", titleAlternative).withMetadata("dcterms", "title", "", title).build();
        this.context.restoreAuthSystemState();
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-t", "ITEM"));
        parameters.add(new DSpaceCommandLineParameter("-i", item.getHandle()));
        parameters.add(new DSpaceCommandLineParameter("-m", ""));
        this.perfomExportScript(parameters);
        this.checkItem(item);
    }

    private void checkCollection() throws Exception {
        Assert.assertNotNull((Object)this.collectionService.find(this.context, this.collection.getID()));
    }

    private void checkItem(Item item) throws Exception {
        Assert.assertNotNull((Object)this.itemService.find(this.context, item.getID()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void perfomExportScript(LinkedList<DSpaceCommandLineParameter> parameters) throws Exception {
        Process process = null;
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        try {
            AtomicReference idRef = new AtomicReference();
            String token = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)"/api/system/scripts/export/processes", (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(list)})).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ProcessMatcher.matchProcess("export", String.valueOf(this.admin.getID()), parameters, ProcessStatus.COMPLETED)))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
            process = this.processService.find(this.context, ((Integer)idRef.get()).intValue());
            this.checkProcess(process);
        }
        finally {
            ProcessBuilder.deleteProcess((Integer)process.getID());
        }
    }

    private void checkProcess(Process process) {
        Assert.assertNotNull((Object)process.getBitstreams());
        Assert.assertEquals((long)2L, (long)process.getBitstreams().size());
        Assert.assertEquals((long)1L, (long)process.getBitstreams().stream().filter(b -> StringUtils.contains((CharSequence)b.getName(), (CharSequence)".log")).count());
        Assert.assertEquals((long)1L, (long)process.getBitstreams().stream().filter(b -> StringUtils.contains((CharSequence)b.getName(), (CharSequence)".zip")).count());
    }
}

