/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.opensearch;

import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class OpenSearchControllerIT
extends AbstractControllerIntegrationTest {
    private ConfigurationService configurationService;

    @Before
    public void init() throws Exception {
        this.configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        this.configurationService.setProperty("websvc.opensearch.enable", (Object)true);
    }

    @Test
    public void searchAtomTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/opensearch/search", (Object[])new Object[0]).param("query", new String[]{"cats"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("application/atom+xml;charset=UTF-8"));
    }

    @Test
    public void searchRssTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/opensearch/search", (Object[])new Object[0]).param("query", new String[]{"cats"}).param("format", new String[]{"rss"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("application/rss+xml;charset=UTF-8"));
    }

    @Test
    public void noResultsTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/opensearch/search", (Object[])new Object[0]).param("query", new String[]{"this query is not supposed to have a result"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("application/atom+xml;charset=UTF-8")).andExpect(MockMvcResultMatchers.xpath((String)"feed/totalResults", (Object[])new Object[0]).string("0")).andExpect(MockMvcResultMatchers.xpath((String)"feed/Query/@searchTerms", (Object[])new Object[0]).string("this+query+is+not+supposed+to+have+a+result"));
    }

    @Test
    public void findResultSimpleTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Boars at Yellowstone").withIssueDate("2017-10-17").withAuthor("Ballini, Andreas").withAuthor("Moriarti, Susan").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Yellowstone and bisons").withIssueDate("2017-10-18").withAuthor("Ballini, Andreas").withAuthor("Moriarti, Susan").build();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/opensearch/search", (Object[])new Object[0]).param("query", new String[]{"Yellowstone"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("application/atom+xml;charset=UTF-8")).andExpect(MockMvcResultMatchers.xpath((String)"feed/Query/@searchTerms", (Object[])new Object[0]).string("Yellowstone")).andExpect(MockMvcResultMatchers.xpath((String)"feed/totalResults", (Object[])new Object[0]).string("2"));
    }

    @Ignore
    @Test
    public void findResultWithSpecialCharsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("B\u00e4ren im Yellowstonepark").withIssueDate("2017-10-17").withAuthor("B\u00e4cker, Nick").build();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/opensearch/search", (Object[])new Object[0]).param("query", new String[]{"B\u00e4r"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("application/atom+xml;charset=UTF-8")).andExpect(MockMvcResultMatchers.xpath((String)"feed/Query/@searchTerms", (Object[])new Object[0]).string("B%C3%A4r")).andExpect(MockMvcResultMatchers.xpath((String)"feed/totalResults", (Object[])new Object[0]).string("1"));
    }

    @Ignore
    @Test
    public void invalidQueryTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/opensearch/search", (Object[])new Object[0]).param("query", new String[]{"urn:nbn:de:fake-123"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("application/atom+xml;charset=UTF-8")).andExpect(MockMvcResultMatchers.xpath((String)"feed/Query/@searchTerms", (Object[])new Object[0]).string("urn:nbn:de:fake-123")).andExpect(MockMvcResultMatchers.xpath((String)"feed/totalResults", (Object[])new Object[0]).string("0"));
    }

    @Test
    public void emptyQueryTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/opensearch/search", (Object[])new Object[0]).param("query", new String[]{""})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("application/atom+xml;charset=UTF-8")).andExpect(MockMvcResultMatchers.xpath((String)"feed/totalResults", (Object[])new Object[0]).string("0"));
    }

    @Test
    public void validSortTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/opensearch/search", (Object[])new Object[0]).param("query", new String[]{""}).param("sort", new String[]{"dc.date.issued"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("application/atom+xml;charset=UTF-8")).andExpect(MockMvcResultMatchers.xpath((String)"feed/totalResults", (Object[])new Object[0]).string("0"));
    }

    @Test
    public void invalidSortTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/opensearch/search", (Object[])new Object[0]).param("query", new String[]{""}).param("sort", new String[]{"dc.invalid.field"})).andExpect(MockMvcResultMatchers.status().is(400));
    }

    @Test
    public void serviceDocumentTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/opensearch/service", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("application/opensearchdescription+xml;charset=UTF-8")).andExpect(MockMvcResultMatchers.xpath((String)"OpenSearchDescription/ShortName", (Object[])new Object[0]).string("DSpace")).andExpect(MockMvcResultMatchers.xpath((String)"OpenSearchDescription/LongName", (Object[])new Object[0]).string("DSpace at My University")).andExpect(MockMvcResultMatchers.xpath((String)"OpenSearchDescription/Description", (Object[])new Object[0]).string("DSpace at My University DSpace repository")).andExpect(MockMvcResultMatchers.xpath((String)"OpenSearchDescription/Url[@type='text/html']/@template", (Object[])new Object[0]).string("http://localhost:4000/search?query={searchTerms}")).andExpect(MockMvcResultMatchers.xpath((String)"OpenSearchDescription/Url[@type='application/atom+xml; charset=UTF-8']/@template", (Object[])new Object[0]).string("http://localhost/opensearch/search?query={searchTerms}&start={startIndex?}&rpp={count?}&format=atom")).andExpect(MockMvcResultMatchers.xpath((String)"OpenSearchDescription/Url[@type='application/rss+xml; charset=UTF-8']/@template", (Object[])new Object[0]).string("http://localhost/opensearch/search?query={searchTerms}&start={startIndex?}&rpp={count?}&format=rss"));
    }
}

