/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.dspace.app.rest.converter.CollectionConverter;
import org.dspace.app.rest.matcher.CollectionMatcher;
import org.dspace.app.rest.matcher.CommunityMatcher;
import org.dspace.app.rest.matcher.HalMatcher;
import org.dspace.app.rest.matcher.ItemMatcher;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.app.rest.matcher.PageMatcher;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.model.GroupRest;
import org.dspace.app.rest.model.MetadataRest;
import org.dspace.app.rest.model.MetadataValueRest;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.patch.ReplaceOperation;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.rest.test.MetadataPatchSuite;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.EntityTypeBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.ResourcePolicyBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CollectionRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    CollectionConverter collectionConverter;
    @Autowired
    AuthorizeService authorizeService;
    @Autowired
    ResourcePolicyService resoucePolicyService;
    @Autowired
    GroupService groupService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    CollectionService collectionService;
    private Community topLevelCommunityA;
    private Community subCommunityA;
    private Community communityB;
    private Community communityC;
    private Collection collectionA;
    private Collection collectionB;
    private Collection collectionC;
    private EPerson topLevelCommunityAAdmin;
    private EPerson subCommunityAAdmin;
    private EPerson collectionAAdmin;
    private EPerson submitter;

    @Test
    public void findAllTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Collection 2").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections", (Object[])new Object[0]).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col1.getName(), col1.getID(), col1.getHandle()), CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col2.getName(), col2.getID(), col2.getHandle())})));
    }

    @Test
    public void findAllUnAuthenticatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 2").build();
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)col2, 0);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchCollection(col1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findAllForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 2").build();
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)col2, 0);
        this.context.restoreAuthSystemState();
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchCollection(col1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findAllGrantAccessAdminsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson parentAdmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withAdminGroup(new EPerson[]{parentAdmin}).build();
        EPerson col1Admin = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson2@mail.com").withPassword("qwerty02").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withAdminGroup(new EPerson[]{col1Admin}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 2").build();
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)this.parentCommunity, 0);
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)col1, 0);
        this.context.restoreAuthSystemState();
        String tokenParentAdmin = this.getAuthToken(parentAdmin.getEmail(), "qwerty01");
        this.getClient(tokenParentAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchCollection(col1), CollectionMatcher.matchCollection(col2)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        String tokenCol1Admin = this.getAuthToken(col1Admin.getEmail(), "qwerty02");
        this.getClient(tokenCol1Admin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchCollection(col1), CollectionMatcher.matchCollection(col2)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void findAllPaginationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Collection 2").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections", (Object[])new Object[0]).param("size", new String[]{"1"}).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col1.getName(), col1.getID(), col1.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.not((Matcher)Matchers.contains(CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col2.getName(), col2.getID(), col2.getHandle()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections?"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections", (Object[])new Object[0]).param("size", new String[]{"1"}).param("page", new String[]{"1"}).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col2.getName(), col2.getID(), col2.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.not((Matcher)Matchers.contains(CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col1.getName(), col1.getID(), col1.getHandle()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findOneCollectionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Collection 2").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0]).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CollectionMatcher.matchSpecificEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CollectionMatcher.matchCollectionEntry(col1.getName(), col1.getID(), col1.getHandle())));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchNoEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle())));
    }

    @Test
    public void findOneCollectionFullProjectionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CollectionMatcher.matchCollectionEntryFullProjection(col1.getName(), col1.getID(), col1.getHandle())));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.not(CollectionMatcher.matchCollectionEntryFullProjection(col1.getName(), col1.getID(), col1.getHandle()))));
    }

    @Test
    public void findOneCollectionUnAuthenticatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)col1, 0);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneCollectionForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)col1, 0);
        this.context.restoreAuthSystemState();
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findOneCollectionGrantAccessAdminsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson parentAdmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withAdminGroup(new EPerson[]{parentAdmin}).build();
        EPerson col1Admin = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson2@mail.com").withPassword("qwerty02").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withAdminGroup(new EPerson[]{col1Admin}).build();
        EPerson col2Admin = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson3@mail.com").withPassword("qwerty03").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 2").withAdminGroup(new EPerson[]{col2Admin}).build();
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)this.parentCommunity, 0);
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)col1, 0);
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)col2, 0);
        this.context.restoreAuthSystemState();
        String tokenParentAdmin = this.getAuthToken(parentAdmin.getEmail(), "qwerty01");
        this.getClient(tokenParentAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CollectionMatcher.matchCollection(col1))));
        String tokenCol1Admin = this.getAuthToken(col1Admin.getEmail(), "qwerty02");
        this.getClient(tokenCol1Admin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CollectionMatcher.matchCollection(col1))));
        String tokenCol2Admin = this.getAuthToken(col2Admin.getEmail(), "qwerty03");
        this.getClient(tokenCol2Admin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findOneCollectionRelsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withLogo("TestingContentForLogo").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Collection 2").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0]).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col1.getName(), col1.getID(), col1.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.not((Matcher)Matchers.is(CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col2.getName(), col2.getID(), col2.getHandle())))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID() + "/logo"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.format.href", (Matcher)Matchers.containsString((String)"/api/core/bitstreams"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.format.href", (Matcher)Matchers.containsString((String)"/format"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/bitstreams"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.content.href", (Matcher)Matchers.containsString((String)"/api/core/bitstreams"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.content.href", (Matcher)Matchers.containsString((String)"/content")));
    }

    @Test
    public void findAuthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Collection 2").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void findAuthorizedCollectionsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Collection 2").build();
        Collection col3 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 3").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Group ChildGroupOfSubmitterGroup = GroupBuilder.createGroup((Context)this.context).withName("Child group of submitters").withParent(col1.getSubmitters()).addMember(eperson2).build();
        this.context.restoreAuthSystemState();
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        String tokenEPerson2 = this.getAuthToken(eperson2.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle()), CollectionMatcher.matchProperties(col3.getName(), col3.getID(), col3.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(tokenEPerson2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle()), CollectionMatcher.matchProperties(col2.getName(), col2.getID(), col2.getHandle()), CollectionMatcher.matchProperties(col3.getName(), col3.getID(), col3.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
    }

    @Test
    public void findAuthorizedCollectionsWithQueryTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson2@mail.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Sample collection").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Test collection").build();
        Collection col3 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Collection of sample items").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection col4 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Testing autocomplete in submission").withSubmitterGroup(new EPerson[]{eperson2}).build();
        this.context.restoreAuthSystemState();
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0]).param("query", new String[]{"collection"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle()), CollectionMatcher.matchProperties(col3.getName(), col3.getID(), col3.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0]).param("query", new String[]{"COLLECTION"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle()), CollectionMatcher.matchProperties(col3.getName(), col3.getID(), col3.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0]).param("query", new String[]{"test"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0]).param("query", new String[]{"auto"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        String tokenEPerson2 = this.getAuthToken(eperson2.getEmail(), this.password);
        this.getClient(tokenEPerson2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0]).param("query", new String[]{"auto"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchProperties(col4.getName(), col4.getID(), col4.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient(tokenEPerson2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0]).param("query", new String[]{"testing auto"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0]).param("query", new String[]{"sample"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle()), CollectionMatcher.matchProperties(col3.getName(), col3.getID(), col3.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0]).param("query", new String[]{"items sample"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchProperties(col3.getName(), col3.getID(), col3.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0]).param("query", new String[]{"test"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(col2.getName(), col2.getID(), col2.getHandle()), CollectionMatcher.matchProperties(col4.getName(), col4.getID(), col4.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void findAuthorizedByCommunityWithQueryTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withAdminGroup(new EPerson[]{this.eperson}).build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Sample collection").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Test collection").build();
        Collection col3 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Collection of sample items").build();
        Collection col4 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Testing autocomplete in submission").build();
        this.context.restoreAuthSystemState();
        String tokenAdminParentCom = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenAdminParentCom).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByCommunity", (Object[])new Object[0]).param("uuid", new String[]{this.parentCommunity.getID().toString()}).param("query", new String[]{"sample"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle()), CollectionMatcher.matchProperties(col3.getName(), col3.getID(), col3.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(tokenAdminParentCom).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByCommunity", (Object[])new Object[0]).param("uuid", new String[]{child2.getID().toString()}).param("query", new String[]{"sample"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchProperties(col3.getName(), col3.getID(), col3.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findAuthorizedByCommunityTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Collection 2").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByCommunity", (Object[])new Object[0]).param("uuid", new String[]{this.parentCommunity.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void findAuthorizedByCommunityAdminsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson adminParentCom = EPersonBuilder.createEPerson((Context)this.context).withEmail("adminParentCom@mail.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withAdminGroup(new EPerson[]{adminParentCom}).build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 2").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col3 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Collection 3").build();
        this.context.restoreAuthSystemState();
        String tokenAdminParentCom = this.getAuthToken(adminParentCom.getEmail(), this.password);
        this.getClient(tokenAdminParentCom).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByCommunity", (Object[])new Object[0]).param("uuid", new String[]{this.parentCommunity.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle()), CollectionMatcher.matchProperties(col2.getName(), col2.getID(), col2.getHandle()), CollectionMatcher.matchProperties(col3.getName(), col3.getID(), col3.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
        this.getClient(tokenAdminParentCom).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByCommunity", (Object[])new Object[0]).param("uuid", new String[]{child1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByCommunity", (Object[])new Object[0]).param("uuid", new String[]{this.parentCommunity.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle()), CollectionMatcher.matchProperties(col2.getName(), col2.getID(), col2.getHandle()), CollectionMatcher.matchProperties(col3.getName(), col3.getID(), col3.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
    }

    @Test
    public void findAuthorizedByCommunityWithoutUUIDTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByCommunity", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void findAuthorizedByCommunityWithUnexistentUUIDTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByCommunity", (Object[])new Object[0]).param("uuid", new String[]{UUID.randomUUID().toString()})).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findOneCollectionTestWrongUUID() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Collection 2").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + UUID.randomUUID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findCollectionWithParentCommunity() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Collection 2").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0]).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col1.getName(), col1.getID(), col1.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.not((Matcher)Matchers.is(CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col2.getName(), col2.getID(), col2.getHandle())))));
    }

    @Test
    public void updateTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID().toString()), (Object[])new Object[0]).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col1.getName(), col1.getID(), col1.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/collections")));
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        ObjectMapper mapper = new ObjectMapper();
        CollectionRest collectionRest = (CollectionRest)this.collectionConverter.convert((DSpaceObject)col1, Projection.DEFAULT);
        collectionRest.setMetadata(new MetadataRest().put("dc.title", new MetadataValueRest[]{new MetadataValueRest("Electronic theses and dissertations")}));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/collections/" + col1.getID().toString()), (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(mapper.writeValueAsBytes((Object)collectionRest))).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID().toString()), (Object[])new Object[0]).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CollectionMatcher.matchCollectionEntrySpecificEmbedProjection("Electronic theses and dissertations", col1.getID(), col1.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/collections")));
    }

    @Test
    public void deleteTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withLogo("ThisIsSomeDummyText").build();
        Community parentCommunity2 = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community 2").withLogo("SomeTest").build();
        Community parentCommunityChild1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)parentCommunityChild1).withName("Collection 1").build();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.context.restoreAuthSystemState();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID().toString()), (Object[])new Object[0]).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col1.getName(), col1.getID(), col1.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/collections")));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + col1.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void deleteTestUnAuthorized() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withLogo("ThisIsSomeDummyText").build();
        Community parentCommunity2 = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community 2").withLogo("SomeTest").build();
        Community parentCommunityChild1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)parentCommunityChild1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID().toString()), (Object[])new Object[0]).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col1.getName(), col1.getID(), col1.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/collections")));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + col1.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withLogo("ThisIsSomeDummyText").build();
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        AtomicReference idRefNoEmbeds = new AtomicReference();
        AtomicReference handle = new AtomicReference();
        try {
            ObjectMapper mapper = new ObjectMapper();
            CollectionRest collectionRest = new CollectionRest();
            collectionRest.setName("Collection");
            collectionRest.setMetadata(new MetadataRest().put("dc.description", new MetadataValueRest[]{new MetadataValueRest("<p>Some cool HTML code here</p>")}).put("dc.description.abstract", new MetadataValueRest[]{new MetadataValueRest("Sample top-level community created via the REST API")}).put("dc.description.tableofcontents", new MetadataValueRest[]{new MetadataValueRest("<p>HTML News</p>")}).put("dc.rights", new MetadataValueRest[]{new MetadataValueRest("Custom Copyright Text")}).put("dc.title", new MetadataValueRest[]{new MetadataValueRest("Title Text")}));
            String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/collections", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)collectionRest)).param("parent", new String[]{this.parentCommunity.getID().toString()}).contentType(this.contentType).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CollectionMatcher.matchSpecificEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.not((Matcher)Matchers.empty())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.not((Matcher)Matchers.empty())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)"Title Text")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.handle", (Matcher)Matchers.not((Matcher)Matchers.empty())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"collection")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.description", "<p>Some cool HTML code here</p>"), MetadataMatcher.matchMetadata("dc.description.abstract", "Sample top-level community created via the REST API"), MetadataMatcher.matchMetadata("dc.description.tableofcontents", "<p>HTML News</p>"), MetadataMatcher.matchMetadata("dc.rights", "Custom Copyright Text"), MetadataMatcher.matchMetadata("dc.title", "Title Text")))))).andDo(result -> handle.set((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.handle", (Predicate[])new Predicate[0]))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadataNotEmpty("dc.identifier.uri"), MetadataMatcher.matchMetadataStringEndsWith("dc.identifier.uri", (String)handle.get()))))).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/collections", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)collectionRest)).param("parent", new String[]{this.parentCommunity.getID().toString()}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchNoEmbeds())).andDo(result -> idRefNoEmbeds.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        }
        finally {
            CollectionBuilder.deleteCollection((UUID)((UUID)idRef.get()));
            CollectionBuilder.deleteCollection((UUID)((UUID)idRefNoEmbeds.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createTestByAuthorizedUser() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withLogo("ThisIsSomeDummyText").build();
        ObjectMapper mapper = new ObjectMapper();
        CollectionRest collectionRest = new CollectionRest();
        collectionRest.setName("Collection");
        collectionRest.setMetadata(new MetadataRest().put("dc.description", new MetadataValueRest[]{new MetadataValueRest("<p>Some cool HTML code here</p>")}).put("dc.description.abstract", new MetadataValueRest[]{new MetadataValueRest("Sample top-level community created via the REST API")}).put("dc.description.tableofcontents", new MetadataValueRest[]{new MetadataValueRest("<p>HTML News</p>")}).put("dc.rights", new MetadataValueRest[]{new MetadataValueRest("Custom Copyright Text")}).put("dc.title", new MetadataValueRest[]{new MetadataValueRest("Title Text")}));
        this.context.setCurrentUser(this.eperson);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 3, this.eperson);
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        try {
            String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/collections", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)collectionRest)).param("parent", new String[]{this.parentCommunity.getID().toString()}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.not((Matcher)Matchers.empty())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.not((Matcher)Matchers.empty())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)"Title Text")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.handle", (Matcher)Matchers.not((Matcher)Matchers.empty())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"collection")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.description", "<p>Some cool HTML code here</p>"), MetadataMatcher.matchMetadata("dc.description.abstract", "Sample top-level community created via the REST API"), MetadataMatcher.matchMetadata("dc.description.tableofcontents", "<p>HTML News</p>"), MetadataMatcher.matchMetadata("dc.rights", "Custom Copyright Text"), MetadataMatcher.matchMetadata("dc.title", "Title Text")))))).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        }
        finally {
            CollectionBuilder.deleteCollection((UUID)((UUID)idRef.get()));
        }
    }

    @Test
    public void createTestByUnauthorizedUser() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withLogo("ThisIsSomeDummyText").build();
        ObjectMapper mapper = new ObjectMapper();
        CollectionRest collectionRest = new CollectionRest();
        collectionRest.setName("Collection");
        collectionRest.setMetadata(new MetadataRest().put("dc.description", new MetadataValueRest[]{new MetadataValueRest("<p>Some cool HTML code here</p>")}).put("dc.description.abstract", new MetadataValueRest[]{new MetadataValueRest("Sample top-level community created via the REST API")}).put("dc.description.tableofcontents", new MetadataValueRest[]{new MetadataValueRest("<p>HTML News</p>")}).put("dc.rights", new MetadataValueRest[]{new MetadataValueRest("Custom Copyright Text")}).put("dc.title", new MetadataValueRest[]{new MetadataValueRest("Title Text")}));
        this.context.setCurrentUser(this.eperson);
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/collections", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)collectionRest)).param("parent", new String[]{this.parentCommunity.getID().toString()}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void deleteCollectionEpersonWithDeleteRightsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withLogo("ThisIsSomeDummyText").build();
        Community parentCommunity2 = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community 2").withLogo("SomeTest").build();
        Community parentCommunityChild1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)parentCommunityChild1).withName("Collection 1").build();
        this.context.setCurrentUser(this.eperson);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)col1, 2, this.eperson);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)col1, 1, this.eperson);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.context.restoreAuthSystemState();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID().toString()), (Object[])new Object[0]).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col1.getName(), col1.getID(), col1.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/collections")));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + col1.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.authorizeService.removePoliciesActionFilter(this.context, (DSpaceObject)this.eperson, 2);
        this.authorizeService.removePoliciesActionFilter(this.context, (DSpaceObject)this.eperson, 1);
    }

    @Test
    public void updateCollectionEpersonWithWriteRightsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID().toString()), (Object[])new Object[0]).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col1.getName(), col1.getID(), col1.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/collections")));
        this.context.setCurrentUser(this.eperson);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)col1, 1, this.eperson);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        ObjectMapper mapper = new ObjectMapper();
        CollectionRest collectionRest = (CollectionRest)this.collectionConverter.convert((DSpaceObject)col1, Projection.DEFAULT);
        collectionRest.setMetadata(new MetadataRest().put("dc.title", new MetadataValueRest[]{new MetadataValueRest("Electronic theses and dissertations")}));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/collections/" + col1.getID().toString()), (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(mapper.writeValueAsBytes((Object)collectionRest))).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID().toString()), (Object[])new Object[0]).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CollectionMatcher.matchCollectionEntrySpecificEmbedProjection("Electronic theses and dissertations", col1.getID(), col1.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/collections")));
        this.authorizeService.removePoliciesActionFilter(this.context, (DSpaceObject)this.eperson, 1);
    }

    public void patchCollectionMetadataAuthorized() throws Exception {
        this.runPatchMetadataTests(this.admin, 200);
    }

    @Test
    public void patchCollectionMetadataUnauthorized() throws Exception {
        this.runPatchMetadataTests(this.eperson, 403);
    }

    private void runPatchMetadataTests(EPerson asUser, int expectedStatus) throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(asUser.getEmail(), this.password);
        new MetadataPatchSuite().runWith(this.getClient(token), "/api/core/collections/" + col.getID(), expectedStatus);
    }

    @Test
    public void createTestInvalidParentCommunityUUIDBadRequestException() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withLogo("ThisIsSomeDummyText").build();
        ObjectMapper mapper = new ObjectMapper();
        CollectionRest collectionRest = new CollectionRest();
        collectionRest.setName("Collection");
        collectionRest.setMetadata(new MetadataRest().put("dc.description", new MetadataValueRest[]{new MetadataValueRest("<p>Some cool HTML code here</p>")}).put("dc.description.abstract", new MetadataValueRest[]{new MetadataValueRest("top-level community created via the REST API")}).put("dc.description.tableofcontents", new MetadataValueRest[]{new MetadataValueRest("<p>HTML News</p>")}).put("dc.rights", new MetadataValueRest[]{new MetadataValueRest("Custom Copyright Text")}).put("dc.title", new MetadataValueRest[]{new MetadataValueRest("Title Text")}));
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.context.restoreAuthSystemState();
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/collections", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)collectionRest)).param("parent", new String[]{"123"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void createTestWithoutParentCommunityUUIDBadRequestException() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withLogo("ThisIsSomeDummyText").build();
        ObjectMapper mapper = new ObjectMapper();
        CollectionRest collectionRest = new CollectionRest();
        collectionRest.setName("Collection");
        collectionRest.setMetadata(new MetadataRest().put("dc.description", new MetadataValueRest[]{new MetadataValueRest("<p>Some cool HTML code here</p>")}).put("dc.description.abstract", new MetadataValueRest[]{new MetadataValueRest("top-level community created via the REST API")}).put("dc.description.tableofcontents", new MetadataValueRest[]{new MetadataValueRest("<p>HTML News</p>")}).put("dc.rights", new MetadataValueRest[]{new MetadataValueRest("Custom Copyright Text")}).put("dc.title", new MetadataValueRest[]{new MetadataValueRest("Title Text")}));
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.context.restoreAuthSystemState();
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/collections", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)collectionRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void findAllCollectionsWithMultilanguageTitlesTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withNameForLanguage("Collection 1", "en").withNameForLanguage("Col 1", "fr").withNameForLanguage("Coll 1", "de").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Collection 2").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections", (Object[])new Object[0]).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col1.getName(), col1.getID(), col1.getHandle()), CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col2.getName(), col2.getID(), col2.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 2)));
    }

    @Test
    public void projectonLevelTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child1child = CommunityBuilder.createSubCommunity((Context)this.context, (Community)child1).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withLogo("TestingContentForLogo").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1child).withName("Collection 2").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0]).param("projection", new String[]{"level"}).param("embedLevelDepth", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CollectionMatcher.matchCollectionEntry(col1.getName(), col1.getID(), col1.getHandle()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems._embedded.mappedItems", (Object[])new Object[0]).isEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.parentCommunity", CommunityMatcher.matchCommunityEntry(child1.getName(), child1.getID(), child1.getHandle()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.parentCommunity._embedded.subcommunities", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.logo", (Matcher)Matchers.not((Matcher)Matchers.empty()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.logo._embedded.format", (Object[])new Object[0]).doesNotExist());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0]).param("projection", new String[]{"level"}).param("embedLevelDepth", new String[]{"3"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CollectionMatcher.matchCollectionEntry(col1.getName(), col1.getID(), col1.getHandle()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems._embedded.mappedItems", (Object[])new Object[0]).isEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.parentCommunity", CommunityMatcher.matchCommunityEntry(child1.getName(), child1.getID(), child1.getHandle()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.parentCommunity._embedded.subcommunities", (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.parentCommunity._embedded.subcommunities._embedded.subcommunities", (Matcher)Matchers.contains(CommunityMatcher.matchCommunityEntry(child1child.getID(), child1child.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.parentCommunity._embedded.subcommunities._embedded.subcommunities[0]._embedded.collections._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchCollectionEntry(col2.getName(), col2.getID(), col2.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.parentCommunity._embedded.subcommunities._embedded.subcommunities[0]._embedded.collections._embedded.collections[0]._embedded.logo", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.logo", (Matcher)Matchers.not((Matcher)Matchers.empty()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.logo._embedded.format", (Object[])new Object[0]).exists());
    }

    @Test
    public void projectonLevelEmbedLevelDepthHigherThanEmbedMaxBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child1child = CommunityBuilder.createSubCommunity((Context)this.context, (Community)child1).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withLogo("TestingContentForLogo").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0]).param("projection", new String[]{"level"}).param("embedLevelDepth", new String[]{"100"})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void projectonLevelEmbedLevelDepthNotPresentBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child1child = CommunityBuilder.createSubCommunity((Context)this.context, (Community)child1).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withLogo("TestingContentForLogo").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0]).param("projection", new String[]{"level"})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void testHiddenMetadataForAnonymousUser() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withProvenance("Provenance Data").withNameForLanguage("Col 1", "en").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata("dc.title", "Collection 1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadataDoesNotExist("dc.description.provenance")));
    }

    @Test
    public void testHiddenMetadataForAdminUser() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withProvenance("Provenance Data").withNameForLanguage("Col 1", "en").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata("dc.title", "Collection 1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata("dc.description.provenance", "Provenance Data")));
    }

    @Test
    public void testHiddenMetadataForUserWithWriteRights() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withProvenance("Provenance Data").withNameForLanguage("Col 1", "en").build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(this.eperson).withAction(1).withDspaceObject((DSpaceObject)col1).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata("dc.title", "Collection 1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata.['dc.description.provenance']", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void findAllWithHiddenMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withProvenance("Provenance Test 1").withNameForLanguage("col1", "en").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 2").withProvenance("Provenance Test 2").withNameForLanguage("col2", "it").build();
        this.context.restoreAuthSystemState();
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections", (Object[])new Object[0]).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col1.getName(), col1.getID(), col1.getHandle()), CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col2.getName(), col2.getID(), col2.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata.['dc.description.provenance']", (Object[])new Object[0]).doesNotExist());
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections", (Object[])new Object[0]).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col1.getName(), col1.getID(), col1.getHandle()), CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col2.getName(), col2.getID(), col2.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata.['dc.description.provenance']", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void findAuthorizedCollectionsPaginationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Collection 2").build();
        Collection col3 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 3").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection col4 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 4").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection col5 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 5").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection col6 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 6").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection col7 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 7").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0]).param("page", new String[]{"0"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle()), CollectionMatcher.matchProperties(col2.getName(), col2.getID(), col2.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Object[])new Object[0]).value(Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"page=3"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)4))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)7)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0]).param("page", new String[]{"1"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(col3.getName(), col3.getID(), col3.getHandle()), CollectionMatcher.matchProperties(col4.getName(), col4.getID(), col4.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Object[])new Object[0]).value(Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"page=3"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)4))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)7)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0]).param("page", new String[]{"2"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(col5.getName(), col5.getID(), col5.getHandle()), CollectionMatcher.matchProperties(col6.getName(), col6.getID(), col6.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Object[])new Object[0]).value(Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"page=3"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"page=3"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)4))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)7)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0]).param("page", new String[]{"1"}).param("size", new String[]{"3"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(col4.getName(), col4.getID(), col4.getHandle()), CollectionMatcher.matchProperties(col5.getName(), col5.getID(), col5.getHandle()), CollectionMatcher.matchProperties(col6.getName(), col6.getID(), col6.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Object[])new Object[0]).value(Matchers.hasSize((int)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=3")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=3")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=3")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)"size=3")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)"size=3")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)7)));
    }

    @Test
    public void findAuthorizedCollectionsWithQueryAndPaginationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Sample 1 collection").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Sample 2 collection").build();
        Collection col3 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Sample 3 collection").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection col4 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Sample 4 collection").build();
        Collection col5 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Sample 5 collection").build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0]).param("query", new String[]{"sample"}).param("page", new String[]{"0"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.everyItem((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"collection"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Object[])new Object[0]).value(Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"query=sample"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"query=sample"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"query=sample"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"query=sample"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)5)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0]).param("query", new String[]{"sample"}).param("page", new String[]{"1"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.everyItem((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"collection"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Object[])new Object[0]).value(Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"query=sample"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"query=sample"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"query=sample"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"query=sample"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"query=sample"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)5)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0]).param("query", new String[]{"sample"}).param("page", new String[]{"2"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.everyItem((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"collection"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Object[])new Object[0]).value(Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"query=sample"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"query=sample"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"query=sample"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/collections/search/findSubmitAuthorized?"), (Matcher)Matchers.containsString((String)"query=sample"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)5)));
    }

    @Test
    public void findAuthorizedByCommunityPaginationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withAdminGroup(new EPerson[]{this.eperson}).build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Test collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Test collection 2").build();
        Collection col3 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Test collection 3").build();
        Collection col4 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Test collection 4").build();
        Collection col5 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Test collection 5").build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByCommunity", (Object[])new Object[0]).param("uuid", new String[]{this.parentCommunity.getID().toString()}).param("page", new String[]{"0"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle()), CollectionMatcher.matchProperties(col2.getName(), col2.getID(), col2.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Object[])new Object[0]).value(Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)5)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByCommunity", (Object[])new Object[0]).param("uuid", new String[]{this.parentCommunity.getID().toString()}).param("page", new String[]{"1"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(col3.getName(), col3.getID(), col3.getHandle()), CollectionMatcher.matchProperties(col4.getName(), col4.getID(), col4.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Object[])new Object[0]).value(Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)5)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByCommunity", (Object[])new Object[0]).param("uuid", new String[]{this.parentCommunity.getID().toString()}).param("page", new String[]{"2"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(col5.getName(), col5.getID(), col5.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Object[])new Object[0]).value(Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)5)));
    }

    @Test
    public void findAuthorizedByCommunityWithQueryPaginationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Sample 1 collection").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Sample 2 collection").build();
        Collection col3 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Sample 3 collection").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection col4 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Sample 4 collection").build();
        Collection col5 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Sample 5 collection").build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByCommunity", (Object[])new Object[0]).param("uuid", new String[]{this.parentCommunity.getID().toString()}).param("query", new String[]{"sample"}).param("page", new String[]{"0"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.everyItem((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"collection"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Object[])new Object[0]).value(Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)5)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByCommunity", (Object[])new Object[0]).param("uuid", new String[]{this.parentCommunity.getID().toString()}).param("query", new String[]{"sample"}).param("page", new String[]{"1"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.everyItem((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"collection"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Object[])new Object[0]).value(Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)5)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByCommunity", (Object[])new Object[0]).param("uuid", new String[]{this.parentCommunity.getID().toString()}).param("query", new String[]{"sample"}).param("page", new String[]{"2"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.everyItem((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"collection"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Object[])new Object[0]).value(Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)5)));
    }

    @Test
    public void findOneTestWithEmbedsNoPageSize() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection").build();
        Collection mappedCollection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Mapped Collection").build();
        Item item0 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 0").build();
        Item item1 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 1").build();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 2").build();
        Item item3 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 3").build();
        Item item4 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 4").build();
        Item item5 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 5").build();
        Item item6 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 6").build();
        Item item7 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 7").build();
        Item item8 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 8").build();
        Item item9 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 9").build();
        this.collectionService.addItem(this.context, mappedCollection, item0);
        this.collectionService.addItem(this.context, mappedCollection, item1);
        this.collectionService.addItem(this.context, mappedCollection, item2);
        this.collectionService.addItem(this.context, mappedCollection, item3);
        this.collectionService.addItem(this.context, mappedCollection, item4);
        this.collectionService.addItem(this.context, mappedCollection, item5);
        this.collectionService.addItem(this.context, mappedCollection, item6);
        this.collectionService.addItem(this.context, mappedCollection, item7);
        this.collectionService.addItem(this.context, mappedCollection, item8);
        this.collectionService.addItem(this.context, mappedCollection, item9);
        this.collectionService.update(this.context, (DSpaceObject)mappedCollection);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + mappedCollection.getID()), (Object[])new Object[0]).param("embed", new String[]{"mappedItems"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CollectionMatcher.matchCollection(mappedCollection))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems._embedded.mappedItems", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ItemMatcher.matchItemProperties(item0), ItemMatcher.matchItemProperties(item1), ItemMatcher.matchItemProperties(item2), ItemMatcher.matchItemProperties(item3), ItemMatcher.matchItemProperties(item4), ItemMatcher.matchItemProperties(item5), ItemMatcher.matchItemProperties(item6), ItemMatcher.matchItemProperties(item7), ItemMatcher.matchItemProperties(item8), ItemMatcher.matchItemProperties(item9)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/collections/" + mappedCollection.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems.page.totalElements", (Matcher)Matchers.is((Object)10)));
    }

    @Test
    public void findOneTestWithEmbedsWithPageSize() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection").build();
        Collection mappedCollection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Mapped Collection").build();
        ArrayList<Item> items = new ArrayList<Item>();
        Comparator<Item> compareByUUID = Comparator.comparing(i -> i.getID().toString());
        Item item0 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 0").build();
        items.add(item0);
        Item item1 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 1").build();
        items.add(item1);
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 2").build();
        items.add(item2);
        Item item3 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 3").build();
        items.add(item3);
        Item item4 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 4").build();
        items.add(item4);
        Item item5 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 5").build();
        items.add(item5);
        Item item6 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 6").build();
        items.add(item6);
        Item item7 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 7").build();
        items.add(item7);
        Item item8 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 8").build();
        items.add(item8);
        Item item9 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 9").build();
        items.add(item9);
        items.sort(compareByUUID);
        this.collectionService.addItem(this.context, mappedCollection, item0);
        this.collectionService.addItem(this.context, mappedCollection, item1);
        this.collectionService.addItem(this.context, mappedCollection, item2);
        this.collectionService.addItem(this.context, mappedCollection, item3);
        this.collectionService.addItem(this.context, mappedCollection, item4);
        this.collectionService.addItem(this.context, mappedCollection, item5);
        this.collectionService.addItem(this.context, mappedCollection, item6);
        this.collectionService.addItem(this.context, mappedCollection, item7);
        this.collectionService.addItem(this.context, mappedCollection, item8);
        this.collectionService.addItem(this.context, mappedCollection, item9);
        this.collectionService.update(this.context, (DSpaceObject)mappedCollection);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + mappedCollection.getID()), (Object[])new Object[0]).param("embed", new String[]{"mappedItems"}).param("embed.size", new String[]{"mappedItems=5"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CollectionMatcher.matchCollection(mappedCollection))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems._embedded.mappedItems", (Matcher)Matchers.containsInRelativeOrder((Matcher[])new Matcher[]{ItemMatcher.matchItemProperties((Item)items.get(0)), ItemMatcher.matchItemProperties((Item)items.get(1)), ItemMatcher.matchItemProperties((Item)items.get(2)), ItemMatcher.matchItemProperties((Item)items.get(3)), ItemMatcher.matchItemProperties((Item)items.get(4))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/collections/" + mappedCollection.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems.page.size", (Matcher)Matchers.is((Object)5))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems.page.totalElements", (Matcher)Matchers.is((Object)10)));
    }

    @Test
    public void findOneTestWithEmbedsWithInvalidPageSize() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection").build();
        Collection mappedCollection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Mapped Collection").build();
        Item item0 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 0").build();
        Item item1 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 1").build();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 2").build();
        Item item3 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 3").build();
        Item item4 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 4").build();
        Item item5 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 5").build();
        Item item6 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 6").build();
        Item item7 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 7").build();
        Item item8 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 8").build();
        Item item9 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 9").build();
        this.collectionService.addItem(this.context, mappedCollection, item0);
        this.collectionService.addItem(this.context, mappedCollection, item1);
        this.collectionService.addItem(this.context, mappedCollection, item2);
        this.collectionService.addItem(this.context, mappedCollection, item3);
        this.collectionService.addItem(this.context, mappedCollection, item4);
        this.collectionService.addItem(this.context, mappedCollection, item5);
        this.collectionService.addItem(this.context, mappedCollection, item6);
        this.collectionService.addItem(this.context, mappedCollection, item7);
        this.collectionService.addItem(this.context, mappedCollection, item8);
        this.collectionService.addItem(this.context, mappedCollection, item9);
        this.collectionService.update(this.context, (DSpaceObject)mappedCollection);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + mappedCollection.getID()), (Object[])new Object[0]).param("embed", new String[]{"mappedItems"}).param("embed.size", new String[]{"mappedItems=invalidPage"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CollectionMatcher.matchCollection(mappedCollection))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems._embedded.mappedItems", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ItemMatcher.matchItemProperties(item0), ItemMatcher.matchItemProperties(item1), ItemMatcher.matchItemProperties(item2), ItemMatcher.matchItemProperties(item3), ItemMatcher.matchItemProperties(item4), ItemMatcher.matchItemProperties(item5), ItemMatcher.matchItemProperties(item6), ItemMatcher.matchItemProperties(item7), ItemMatcher.matchItemProperties(item8), ItemMatcher.matchItemProperties(item9)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/collections/" + mappedCollection.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems.page.totalElements", (Matcher)Matchers.is((Object)10)));
    }

    private void setUpAuthorizedSearch() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.topLevelCommunityAAdmin = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("topLevelCommunityAAdmin@my.edu").withPassword(this.password).build();
        this.topLevelCommunityA = CommunityBuilder.createCommunity((Context)this.context).withName("The name of this community is topLevelCommunityA").withAdminGroup(new EPerson[]{this.topLevelCommunityAAdmin}).build();
        this.subCommunityAAdmin = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("subCommunityAAdmin@my.edu").withPassword(this.password).build();
        this.subCommunityA = CommunityBuilder.createCommunity((Context)this.context).withName("The name of this sub-community is subCommunityA").withAdminGroup(new EPerson[]{this.subCommunityAAdmin}).addParentCommunity(this.context, this.topLevelCommunityA).build();
        this.submitter = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("submitter@my.edu").withPassword(this.password).build();
        this.collectionAAdmin = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("collectionAAdmin@my.edu").withPassword(this.password).build();
        this.collectionA = CollectionBuilder.createCollection((Context)this.context, (Community)this.subCommunityA).withName("The name of this collection is collectionA").withAdminGroup(new EPerson[]{this.collectionAAdmin}).withSubmitterGroup(new EPerson[]{this.submitter}).build();
        this.context.restoreAuthSystemState();
        this.configurationService.setProperty("org.dspace.app.rest.authorization.AlwaysThrowExceptionFeature.turnoff", (Object)"true");
    }

    @Test
    public void testAdminAuthorizedSearch() throws Exception {
        this.setUpAuthorizedSearch();
        this.context.turnOffAuthorisationSystem();
        this.communityB = CommunityBuilder.createCommunity((Context)this.context).withName("topLevelCommunityB is a very original name").withAdminGroup(new EPerson[]{this.admin}).build();
        this.communityC = CommunityBuilder.createCommunity((Context)this.context).withName("the last community is named topLevelCommunityC").build();
        this.collectionB = CollectionBuilder.createCollection((Context)this.context, (Community)this.subCommunityA).withName("collectionB is a very original name").build();
        this.collectionC = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityC).withName("the last collection is collectionC").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(this.collectionA.getName(), this.collectionA.getID(), this.collectionA.getHandle()), CollectionMatcher.matchProperties(this.collectionB.getName(), this.collectionB.getID(), this.collectionB.getHandle()), CollectionMatcher.matchProperties(this.collectionC.getName(), this.collectionC.getID(), this.collectionC.getHandle())})));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.collectionB.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(this.collectionB.getName(), this.collectionB.getID(), this.collectionB.getHandle())})));
    }

    @Test
    public void testCommunityAdminAuthorizedSearch() throws Exception {
        this.setUpAuthorizedSearch();
        this.context.turnOffAuthorisationSystem();
        this.communityB = CommunityBuilder.createCommunity((Context)this.context).withName("topLevelCommunityB is a very original name").withAdminGroup(new EPerson[]{this.topLevelCommunityAAdmin}).build();
        this.communityC = CommunityBuilder.createCommunity((Context)this.context).withName("the last community is named topLevelCommunityC").build();
        this.collectionB = CollectionBuilder.createCollection((Context)this.context, (Community)this.topLevelCommunityA).withName("collectionB is a very original name").build();
        this.collectionC = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityC).withName("the last collection is collectionC").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.topLevelCommunityAAdmin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(this.collectionA.getName(), this.collectionA.getID(), this.collectionA.getHandle()), CollectionMatcher.matchProperties(this.collectionB.getName(), this.collectionB.getID(), this.collectionB.getHandle())})));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.collectionB.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(this.collectionB.getName(), this.collectionB.getID(), this.collectionB.getHandle())})));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.collectionC.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubCommunityAdminAuthorizedSearch() throws Exception {
        this.setUpAuthorizedSearch();
        this.context.turnOffAuthorisationSystem();
        this.communityB = CommunityBuilder.createCommunity((Context)this.context).withName("topLevelCommunityB is a very original name").addParentCommunity(this.context, this.subCommunityA).build();
        this.communityC = CommunityBuilder.createCommunity((Context)this.context).withName("the last community is topLevelCommunityC").build();
        this.collectionB = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityB).withName("collectionB is a very original name").build();
        this.collectionC = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityC).withName("the last collection is collectionC").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.subCommunityAAdmin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(this.collectionA.getName(), this.collectionA.getID(), this.collectionA.getHandle()), CollectionMatcher.matchProperties(this.collectionB.getName(), this.collectionB.getID(), this.collectionB.getHandle())})));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.collectionB.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(this.collectionB.getName(), this.collectionB.getID(), this.collectionB.getHandle())})));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.collectionC.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testCollectionAdminAuthorizedSearch() throws Exception {
        this.setUpAuthorizedSearch();
        this.context.turnOffAuthorisationSystem();
        this.communityB = CommunityBuilder.createCommunity((Context)this.context).withName("topLevelCommunityB is a very original name").addParentCommunity(this.context, this.subCommunityA).build();
        this.communityC = CommunityBuilder.createCommunity((Context)this.context).withName("the last community is topLevelCommunityC").build();
        this.collectionB = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityB).withName("collectionB is a very original name").withAdminGroup(new EPerson[]{this.collectionAAdmin}).build();
        this.collectionC = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityC).withName("the last collection is collectionC").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.collectionAAdmin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(this.collectionA.getName(), this.collectionA.getID(), this.collectionA.getHandle()), CollectionMatcher.matchProperties(this.collectionB.getName(), this.collectionB.getID(), this.collectionB.getHandle())})));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.collectionB.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(this.collectionB.getName(), this.collectionB.getID(), this.collectionB.getHandle())})));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.collectionC.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubmitterAuthorizedSearch() throws Exception {
        this.setUpAuthorizedSearch();
        this.context.turnOffAuthorisationSystem();
        this.communityB = CommunityBuilder.createCommunity((Context)this.context).withName("topLevelCommunityB is a very original name").addParentCommunity(this.context, this.subCommunityA).build();
        this.communityC = CommunityBuilder.createCommunity((Context)this.context).withName("the last community is topLevelCommunityC").build();
        this.collectionB = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityB).withName("collectionB is a very original name").withSubmitterGroup(new EPerson[]{this.submitter}).withAdminGroup(new EPerson[]{this.collectionAAdmin}).build();
        this.collectionC = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityC).withName("the last collection is collectionC").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.submitter.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Object[])new Object[0]).doesNotExist());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.collectionB.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Object[])new Object[0]).doesNotExist());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.collectionC.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubGroupOfAdminGroupAuthorizedSearch() throws Exception {
        this.setUpAuthorizedSearch();
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("adminSubGroup").withParent(this.groupService.findByName(this.context, "Administrator")).addMember(this.eperson).build();
        this.communityB = CommunityBuilder.createCommunity((Context)this.context).withName("topLevelCommunityB is a very original name").build();
        this.communityC = CommunityBuilder.createCommunity((Context)this.context).withName("the last community is topLevelCommunityC").build();
        this.collectionB = CollectionBuilder.createCollection((Context)this.context, (Community)this.subCommunityA).withName("collectionB is a very original name").build();
        this.collectionC = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityC).withName("the last collection is collectionC").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(this.collectionA.getName(), this.collectionA.getID(), this.collectionA.getHandle()), CollectionMatcher.matchProperties(this.collectionB.getName(), this.collectionB.getID(), this.collectionB.getHandle()), CollectionMatcher.matchProperties(this.collectionC.getName(), this.collectionC.getID(), this.collectionC.getHandle())})));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.collectionB.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(this.collectionB.getName(), this.collectionB.getID(), this.collectionB.getHandle())})));
    }

    @Test
    public void testSubGroupOfCommunityAdminGroupAuthorizedSearch() throws Exception {
        this.setUpAuthorizedSearch();
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("communityAdminSubGroup").withParent(this.groupService.findByName(this.context, "COMMUNITY_" + this.topLevelCommunityA.getID() + "_ADMIN")).addMember(this.eperson).build();
        this.communityB = CommunityBuilder.createCommunity((Context)this.context).withName("topLevelCommunityB is a very original name").build();
        this.communityC = CommunityBuilder.createCommunity((Context)this.context).withName("the last community is topLevelCommunityC").build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.communityB).withAction(11).withGroup(this.groupService.findByName(this.context, "COMMUNITY_" + this.topLevelCommunityA.getID() + "_ADMIN")).build();
        this.collectionB = CollectionBuilder.createCollection((Context)this.context, (Community)this.subCommunityA).withName("collectionB is a very original name").build();
        this.collectionC = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityC).withName("the last collection is collectionC").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(this.collectionA.getName(), this.collectionA.getID(), this.collectionA.getHandle()), CollectionMatcher.matchProperties(this.collectionB.getName(), this.collectionB.getID(), this.collectionB.getHandle())})));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.collectionB.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(this.collectionB.getName(), this.collectionB.getID(), this.collectionB.getHandle())})));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.collectionC.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubGroupOfSubCommunityAdminGroupAuthorizedSearch() throws Exception {
        this.setUpAuthorizedSearch();
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("communityAdminSubGroup").withParent(this.groupService.findByName(this.context, "COMMUNITY_" + this.subCommunityA.getID() + "_ADMIN")).addMember(this.eperson).build();
        this.communityB = CommunityBuilder.createCommunity((Context)this.context).withName("topLevelCommunityB is a very original name").addParentCommunity(this.context, this.topLevelCommunityA).build();
        this.communityC = CommunityBuilder.createCommunity((Context)this.context).withName("the last community is topLevelCommunityC").addParentCommunity(this.context, this.topLevelCommunityA).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.communityB).withAction(11).withGroup(this.groupService.findByName(this.context, "COMMUNITY_" + this.subCommunityA.getID() + "_ADMIN")).build();
        this.collectionB = CollectionBuilder.createCollection((Context)this.context, (Community)this.subCommunityA).withName("collectionB is a very original name").build();
        this.collectionC = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityC).withName("the last collection is collectionC").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(this.collectionA.getName(), this.collectionA.getID(), this.collectionA.getHandle()), CollectionMatcher.matchProperties(this.collectionB.getName(), this.collectionB.getID(), this.collectionB.getHandle())})));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.collectionB.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(this.collectionB.getName(), this.collectionB.getID(), this.collectionB.getHandle())})));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.collectionC.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubGroupOfCollectionAdminGroupAuthorizedSearch() throws Exception {
        this.setUpAuthorizedSearch();
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("collectionAdminSubGroup").withParent(this.groupService.findByName(this.context, "COLLECTION_" + this.collectionA.getID() + "_ADMIN")).addMember(this.eperson).build();
        this.communityB = CommunityBuilder.createCommunity((Context)this.context).withName("topLevelCommunityB is a very original name").addParentCommunity(this.context, this.topLevelCommunityA).build();
        this.communityC = CommunityBuilder.createCommunity((Context)this.context).withName("the last community is topLevelCommunityC").addParentCommunity(this.context, this.topLevelCommunityA).build();
        this.collectionB = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityB).withName("collectionB is a very original name").build();
        this.collectionC = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityC).withName("the last collection is collectionC").build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.collectionB).withAction(11).withGroup(this.groupService.findByName(this.context, "COLLECTION_" + this.collectionA.getID() + "_ADMIN")).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(this.collectionA.getName(), this.collectionA.getID(), this.collectionA.getHandle()), CollectionMatcher.matchProperties(this.collectionB.getName(), this.collectionB.getID(), this.collectionB.getHandle())})));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.collectionB.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(this.collectionB.getName(), this.collectionB.getID(), this.collectionB.getHandle())})));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.collectionC.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubGroupOfSubmitterGroupAuthorizedSearch() throws Exception {
        this.setUpAuthorizedSearch();
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("collectionAdminSubGroup").withParent(this.groupService.findByName(this.context, "COLLECTION_" + this.collectionA.getID() + "_SUBMIT")).addMember(this.eperson).build();
        this.communityB = CommunityBuilder.createCommunity((Context)this.context).withName("topLevelCommunityB is a very original name").addParentCommunity(this.context, this.topLevelCommunityA).build();
        this.communityC = CommunityBuilder.createCommunity((Context)this.context).withName("the last community is topLevelCommunityC").addParentCommunity(this.context, this.topLevelCommunityA).build();
        this.collectionB = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityB).withName("collectionB is a very original name").build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.collectionB).withAction(3).withGroup(this.groupService.findByName(this.context, "COLLECTION_" + this.collectionA.getID() + "_SUBMIT")).build();
        this.collectionC = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityC).withName("the last collection is collectionC").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Object[])new Object[0]).doesNotExist());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.collectionB.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Object[])new Object[0]).doesNotExist());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.collectionC.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testAdminAuthorizedSearchUnauthenticated() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void patchMetadataCheckReindexingTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("MyTest").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{"MyTest"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchProperties(col.getName(), col.getID(), col.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        ArrayList<Operation> updateTitle = new ArrayList<Operation>();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("value", "New Name");
        updateTitle.add((Operation)new ReplaceOperation("/metadata/dc.title/0", value));
        String patchBody = this.getPatchContent(updateTitle);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/collections/" + col.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)"New Name")));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{"MyTest"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void removeColAdminGroupToCheckReindexingTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("MyTest").withAdminGroup(new EPerson[]{this.eperson}).build();
        this.context.restoreAuthSystemState();
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{"MyTest"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + col1.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{"MyTest"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void addColAdminGroupToCheckReindexingTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("MyTest").build();
        this.context.restoreAuthSystemState();
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{"MyTest"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        AtomicReference idRef = new AtomicReference();
        ObjectMapper mapper = new ObjectMapper();
        GroupRest groupRest = new GroupRest();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + col1.getID() + "/adminGroup"), (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + idRef.get() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + this.eperson.getID()));
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{"MyTest"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findAuthorizedCollectionsByEntityType() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EntityType journal = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Journal").build();
        EntityType publication = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Publication").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community subCommunityA = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("SubCommunity A").build();
        Community subCommunityB = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("SubCommunity B").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)subCommunityA).withEntityType(journal.getLabel()).withName("Collection 1").withAdminGroup(new EPerson[]{this.eperson}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)subCommunityB).withEntityType(journal.getLabel()).withName("Collection 2").withAdminGroup(new EPerson[]{this.eperson}).build();
        CollectionBuilder.createCollection((Context)this.context, (Community)subCommunityA).withEntityType(publication.getLabel()).withName("Collection 3").withAdminGroup(new EPerson[]{this.eperson}).build();
        CollectionBuilder.createCollection((Context)this.context, (Community)subCommunityA).withEntityType(journal.getLabel()).withName("Collection 4").build();
        this.context.restoreAuthSystemState();
        String ePersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(ePersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByEntityType", (Object[])new Object[0]).param("entityType", new String[]{journal.getLabel()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.equalTo((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchCollection(col1), CollectionMatcher.matchCollection(col2)})));
    }

    @Test
    public void findSubmitAuthorizedByEntityTypeNotFoundTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EntityType journal = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Journal").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType(journal.getLabel()).withName("Collection 1").withAdminGroup(new EPerson[]{this.eperson}).build();
        this.context.restoreAuthSystemState();
        String ePersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(ePersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByEntityType", (Object[])new Object[0]).param("entityType", new String[]{"test"})).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByEntityType", (Object[])new Object[0]).param("entityType", new String[]{"test"})).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findAuthorizedCollectionsByEntityTypeEmptyResponseTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EntityType publication = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Publication").build();
        this.context.restoreAuthSystemState();
        String ePersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(ePersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByEntityType", (Object[])new Object[0]).param("entityType", new String[]{publication.getLabel()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.equalTo((Object)0)));
    }

    @Test
    public void findAuthorizedCollectionsByEntityAndQueryType() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EntityType journal = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Journal").build();
        EntityType publication = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Publication").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community subCommunityA = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("SubCommunity A").build();
        Community subCommunityB = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("SubCommunity B").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)subCommunityA).withEntityType(journal.getLabel()).withName("Thesis Collection").withAdminGroup(new EPerson[]{this.eperson}).build();
        CollectionBuilder.createCollection((Context)this.context, (Community)subCommunityB).withEntityType(journal.getLabel()).withName("Work Collection").withAdminGroup(new EPerson[]{this.eperson}).build();
        CollectionBuilder.createCollection((Context)this.context, (Community)subCommunityA).withEntityType(publication.getLabel()).withName("Thesis").withAdminGroup(new EPerson[]{this.eperson}).build();
        CollectionBuilder.createCollection((Context)this.context, (Community)subCommunityA).withEntityType(journal.getLabel()).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        String ePersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(ePersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByEntityType", (Object[])new Object[0]).param("entityType", new String[]{journal.getLabel()}).param("query", new String[]{"Thesis"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.equalTo((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchCollection(col1))));
    }

    @Test
    public void findSubmitAuthorizedCollectionsByCommunityAndEntityTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EntityType publication = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Publication").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        CollectionBuilder.createCollection((Context)this.context, (Community)child1).withEntityType(publication.getLabel()).withName("Test Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withEntityType(publication.getLabel()).withName("Publication Collection 2").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection col3 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withEntityType(publication.getLabel()).withName("Publication Collection 3").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection colWithoutEntity = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName(" Test Collection 4").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByCommunityAndEntityType", (Object[])new Object[0]).param("uuid", new String[]{child2.getID().toString()}).param("entityType", new String[]{publication.getLabel()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.equalTo((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchCollection(col2), CollectionMatcher.matchCollection(col3)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.not((Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchCollection(colWithoutEntity)}))));
    }

    @Test
    public void findSubmitAuthorizedCollectionsByCommunityAndEntityWithQueryTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EntityType journal = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Journal").build();
        EntityType publication = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Publication").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType(journal.getLabel()).withName("Test Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType(journal.getLabel()).withName("Publication Collection 2").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection col3 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType(publication.getLabel()).withName("Publication Collection 3 Test").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection colWithoutEntity = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 4 Test").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByCommunityAndEntityType", (Object[])new Object[0]).param("uuid", new String[]{this.parentCommunity.getID().toString()}).param("entityType", new String[]{journal.getLabel()}).param("query", new String[]{"test"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.equalTo((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchCollection(col1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.not((Matcher)Matchers.contains(CollectionMatcher.matchCollection(colWithoutEntity)))));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByCommunityAndEntityType", (Object[])new Object[0]).param("uuid", new String[]{this.parentCommunity.getID().toString()}).param("entityType", new String[]{publication.getLabel()}).param("query", new String[]{"publication"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.equalTo((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchCollection(col3)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.not((Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchCollection(colWithoutEntity), CollectionMatcher.matchCollection(col2)}))));
    }

    @Test
    public void findSubmitAuthorizedAllCollectionsByCommunityAndEntityBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EntityType publication = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Publication").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType(publication.getLabel()).withName("Test Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByCommunityAndEntityType", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByCommunityAndEntityType", (Object[])new Object[0]).param("uuid", new String[]{this.parentCommunity.getID().toString()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByCommunityAndEntityType", (Object[])new Object[0]).param("entityType", new String[]{publication.getLabel()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void findSubmitAuthorizedByCommunityAndEntityTypeNotFoundTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EntityType publication = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Publication").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType(publication.getLabel()).withName("Test Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByCommunityAndEntityType", (Object[])new Object[0]).param("entityType", new String[]{publication.getLabel()}).param("uuid", new String[]{UUID.randomUUID().toString()})).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByCommunityAndEntityType", (Object[])new Object[0]).param("entityType", new String[]{"test"}).param("uuid", new String[]{this.parentCommunity.getID().toString()})).andExpect(MockMvcResultMatchers.status().isNotFound());
    }
}

