/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.model.FeedbackRest;
import org.dspace.app.rest.repository.FeedbackRestRepository;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.content.FeedbackServiceImpl;
import org.dspace.content.service.FeedbackService;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class FeedbackRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private FeedbackRestRepository feedbackRestRepository;

    @Test
    public void findAllTest() throws Exception {
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/tools/feedbacks", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isMethodNotAllowed());
    }

    @Test
    public void findOneTest() throws Exception {
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/tools/feedbacks/1", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isMethodNotAllowed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sendFeedbackTest() throws Exception {
        this.configurationService.setProperty("feedback.recipient", (Object)"recipient.email@test.com");
        FeedbackService originFeedbackService = this.feedbackRestRepository.getFeedbackService();
        try {
            FeedbackService feedbackServiceMock = (FeedbackService)Mockito.mock(FeedbackServiceImpl.class);
            this.feedbackRestRepository.setFeedbackService(feedbackServiceMock);
            ObjectMapper mapper = new ObjectMapper();
            FeedbackRest feedbackRest = new FeedbackRest();
            feedbackRest.setEmail("misha.boychuk@test.com");
            feedbackRest.setMessage("My feedback!");
            String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/tools/feedbacks", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)feedbackRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
            ((FeedbackService)Mockito.verify((Object)feedbackServiceMock)).sendEmail((Context)ArgumentMatchers.isNotNull(), (HttpServletRequest)ArgumentMatchers.isNotNull(), (String)ArgumentMatchers.eq((Object)"recipient.email@test.com"), (String)ArgumentMatchers.eq((Object)"misha.boychuk@test.com"), (String)ArgumentMatchers.eq((Object)"My feedback!"), (String)ArgumentMatchers.isNull());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{feedbackServiceMock});
        }
        finally {
            this.feedbackRestRepository.setFeedbackService(originFeedbackService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sendFeedbackWithRecipientEmailNotConfiguredTest() throws Exception {
        this.configurationService.setProperty("feedback.recipient", null);
        FeedbackService originFeedbackService = this.feedbackRestRepository.getFeedbackService();
        try {
            FeedbackService feedbackServiceMock = (FeedbackService)Mockito.mock(FeedbackServiceImpl.class);
            this.feedbackRestRepository.setFeedbackService(feedbackServiceMock);
            ObjectMapper mapper = new ObjectMapper();
            FeedbackRest feedbackRest = new FeedbackRest();
            feedbackRest.setEmail("misha.boychuk@test.com");
            feedbackRest.setMessage("My feedback!");
            String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/tools/feedbacks", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)feedbackRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isNotFound());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{feedbackServiceMock});
        }
        finally {
            this.feedbackRestRepository.setFeedbackService(originFeedbackService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sendFeedbackBadRequestTest() throws Exception {
        FeedbackService originFeedbackService = this.feedbackRestRepository.getFeedbackService();
        try {
            FeedbackService feedbackServiceMock = (FeedbackService)Mockito.mock(FeedbackServiceImpl.class);
            this.feedbackRestRepository.setFeedbackService(feedbackServiceMock);
            ObjectMapper mapper = new ObjectMapper();
            FeedbackRest feedbackRest = new FeedbackRest();
            feedbackRest.setMessage("My feedback!");
            String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/tools/feedbacks", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)feedbackRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{feedbackServiceMock});
        }
        finally {
            this.feedbackRestRepository.setFeedbackService(originFeedbackService);
        }
    }
}

