/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.concurrent.atomic.AtomicReference;
import org.dspace.app.rest.RelationshipRestRepositoryIT;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.RelationshipBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.RelationshipType;
import org.dspace.core.Context;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class LeftTiltedRelationshipRestRepositoryIT
extends RelationshipRestRepositoryIT {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.isAuthorOfPublicationRelationshipType.setTilted(RelationshipType.Tilted.LEFT);
        this.relationshipTypeService.update(this.context, (Object)this.isAuthorOfPublicationRelationshipType);
        this.context.restoreAuthSystemState();
    }

    @Override
    @Test
    public void testIsAuthorOfPublicationRelationshipMetadataViaREST() throws Exception {
        this.context.turnOffAuthorisationSystem();
        RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.publication1, (Item)this.author1, (RelationshipType)this.isAuthorOfPublicationRelationshipType).build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/items/{uuid}", (Object[])new Object[]{this.author1.getID()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)String.format("$.metadata['%s.isPublicationOfAuthor']", MetadataSchemaEnum.RELATION.getName()), (Object[])new Object[0]).doesNotExist());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/items/{uuid}", (Object[])new Object[]{this.publication1.getID()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata(String.format("%s.isAuthorOfPublication", MetadataSchemaEnum.RELATION.getName()), this.author1.getID().toString())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test
    public void deleteRelationship() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item author2 = ItemBuilder.createItem((Context)this.context, (Collection)this.col1).withTitle("Author2").withIssueDate("2016-02-13").withPersonIdentifierFirstName("Maria").withPersonIdentifierLastName("Smith").build();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.context.restoreAuthSystemState();
        AtomicReference idRef1 = new AtomicReference();
        AtomicReference idRef2 = new AtomicReference();
        try {
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/items/" + this.publication1.getID() + "\nhttps://localhost:8080/spring-rest/api/core/items/" + this.author1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef1.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.publication1.getID() + "/relationships"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"page.totalElements", (Matcher)Matchers.is((Object)1)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.author1.getID() + "/relationships"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"page.totalElements", (Matcher)Matchers.is((Object)0)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + author2.getID() + "/relationships"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"page.totalElements", (Matcher)Matchers.is((Object)0)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.isAuthorOfPublicationRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/items/" + this.publication1.getID() + "\nhttps://localhost:8080/spring-rest/api/core/items/" + author2.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef2.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.publication1.getID() + "/relationships"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"page.totalElements", (Matcher)Matchers.is((Object)2)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.author1.getID() + "/relationships"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"page.totalElements", (Matcher)Matchers.is((Object)0)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + author2.getID() + "/relationships"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"page.totalElements", (Matcher)Matchers.is((Object)0)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/relationships/" + idRef1), (Object[])new Object[0]));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.publication1.getID() + "/relationships"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"page.totalElements", (Matcher)Matchers.is((Object)1)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.author1.getID() + "/relationships"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"page.totalElements", (Matcher)Matchers.is((Object)0)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + author2.getID() + "/relationships"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"page.totalElements", (Matcher)Matchers.is((Object)0)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/relationships/" + idRef2), (Object[])new Object[0]));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.publication1.getID() + "/relationships"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"page.totalElements", (Matcher)Matchers.is((Object)0)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.author1.getID() + "/relationships"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"page.totalElements", (Matcher)Matchers.is((Object)0)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + author2.getID() + "/relationships"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"page.totalElements", (Matcher)Matchers.is((Object)0)));
        }
        finally {
            if (idRef1.get() != null) {
                RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef1.get()));
            }
            if (idRef2.get() != null) {
                RelationshipBuilder.deleteRelationship((Integer)((Integer)idRef2.get()));
            }
        }
    }
}

