/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.dspace.app.rest.matcher.MetadataFieldMatcher;
import org.dspace.app.rest.model.MetadataFieldRest;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.MetadataFieldBuilder;
import org.dspace.builder.MetadataSchemaBuilder;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataFieldServiceImpl;
import org.dspace.content.MetadataSchema;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.MetadataSchemaService;
import org.dspace.core.Context;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class MetadatafieldRestRepositoryIT
extends AbstractControllerIntegrationTest {
    private static final String ELEMENT = "test element";
    private static final String QUALIFIER = "test qualifier";
    private static final String SCOPE_NOTE = "test scope_note";
    private static final String ELEMENT_UPDATED = "test element updated";
    private static final String QUALIFIER_UPDATED = "test qualifier updated";
    private static final String SCOPE_NOTE_UPDATED = "test scope_note updated";
    private MetadataSchema metadataSchema;
    public static final String METADATAFIELDS_ENDPOINT = "/api/core/metadatafields/";
    private static final String SEARCH_BYFIELDNAME_ENDPOINT = "/api/core/metadatafields/search/byFieldName";
    @Autowired
    private MetadataSchemaService metadataSchemaService;
    @Autowired
    private MetadataFieldServiceImpl metadataFieldService;

    @Before
    public void setup() throws Exception {
        this.metadataSchema = (MetadataSchema)this.metadataSchemaService.findAll(this.context).get(0);
    }

    @Test
    public void findAll() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataField metadataField = MetadataFieldBuilder.createMetadataField((Context)this.context, (String)"AnElement", (String)"AQualifier", (String)"AScopeNote").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/metadatafields", (Object[])new Object[0]).param("size", new String[]{String.valueOf(100)})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{MetadataFieldMatcher.matchMetadataFieldByKeys("dc", "title", null), MetadataFieldMatcher.matchMetadataFieldByKeys("dc", "date", "issued")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.containsString((String)"/api/core/metadatafields"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/metadatafields"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.containsString((String)"/api/core/metadatafields"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.containsString((String)"/api/core/metadatafields"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)100)));
    }

    @Test
    public void findOne() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataField metadataField = MetadataFieldBuilder.createMetadataField((Context)this.context, (String)"AnElement", (String)"AQualifier", (String)"AScopeNote").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)(METADATAFIELDS_ENDPOINT + metadataField.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(MetadataFieldMatcher.matchMetadataField(metadataField))));
    }

    @Test
    public void searchMethodsExist() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/metadatafields", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.search.href", (Matcher)Matchers.notNullValue()));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/metadatafields/search", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.bySchema", (Matcher)Matchers.notNullValue()));
    }

    @Test
    public void findBySchema() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataSchema schema = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)"ASchema", (String)"http://www.dspace.org/ns/aschema").build();
        MetadataField metadataField = MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)schema, (String)"AnElement", (String)"AQualifier", (String)"AScopeNote").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/metadatafields/search/bySchema", (Object[])new Object[0]).param("schema", new String[]{"dc"}).param("size", new String[]{String.valueOf(100)})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{MetadataFieldMatcher.matchMetadataFieldByKeys("dc", "title", null), MetadataFieldMatcher.matchMetadataFieldByKeys("dc", "date", "issued")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)100)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/metadatafields/search/bySchema", (Object[])new Object[0]).param("schema", new String[]{schema.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataField(metadataField)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findByUndefinedSchema() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/metadatafields/search/bySchema", (Object[])new Object[0]).param("schema", new String[]{"undefined"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findByNullSchema() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/metadatafields/search/bySchema", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void findByFieldName_schema() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataSchema schema = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)"ASchema", (String)"http://www.dspace.org/ns/aschema").build();
        MetadataField metadataField = MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)schema, (String)"AnElement", (String)"AQualifier", (String)"AScopeNote").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)SEARCH_BYFIELDNAME_ENDPOINT, (Object[])new Object[0]).param("schema", new String[]{schema.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataField(metadataField)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findByFieldName_element() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataSchema schema = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)"ASchema", (String)"http://www.dspace.org/ns/aschema").build();
        MetadataSchema schema2 = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)"ASchema2", (String)"http://www.dspace.org/ns/aschema2").build();
        MetadataField metadataField = MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)schema, (String)"AnElement", (String)"AQualifier", (String)"AScopeNote").build();
        MetadataField metadataField2 = MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)schema2, (String)"AnElement", (String)"AQualifier2", (String)"AScopeNote2").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)SEARCH_BYFIELDNAME_ENDPOINT, (Object[])new Object[0]).param("element", new String[]{"AnElement"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataField(metadataField)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataField(metadataField2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void findByFieldName_elementAndQualifier() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataSchema schema = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)"ASchema", (String)"http://www.dspace.org/ns/aschema").build();
        MetadataSchema schema2 = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)"ASchema2", (String)"http://www.dspace.org/ns/aschema2").build();
        MetadataField metadataField = MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)schema, (String)"AnElement1", (String)"AQualifier", (String)"AScopeNote").build();
        MetadataField metadataField2 = MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)schema2, (String)"AnElement2", (String)"AQualifier", (String)"AScopeNote2").build();
        MetadataField metadataField3 = MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)schema, (String)"AnElement2", (String)"AQualifier", (String)"AScopeNote2").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)SEARCH_BYFIELDNAME_ENDPOINT, (Object[])new Object[0]).param("element", new String[]{"AnElement2"}).param("qualifier", new String[]{"AQualifier"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataField(metadataField2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataField(metadataField3)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.not((Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataField(metadataField))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void findByFieldName_schemaAndQualifier() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataSchema schema = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)"ASchema", (String)"http://www.dspace.org/ns/aschema").build();
        MetadataSchema schema2 = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)"ASchema2", (String)"http://www.dspace.org/ns/aschema2").build();
        MetadataField metadataField = MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)schema, (String)"AnElement1", (String)"AQualifier", (String)"AScopeNote").build();
        MetadataField metadataField2 = MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)schema2, (String)"AnElement2", (String)"AQualifier", (String)"AScopeNote2").build();
        MetadataField metadataField3 = MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)schema, (String)"AnElement3", (String)"AQualifier", (String)"AScopeNote3").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)SEARCH_BYFIELDNAME_ENDPOINT, (Object[])new Object[0]).param("schema", new String[]{schema.getName()}).param("qualifier", new String[]{"AQualifier"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataField(metadataField)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataField(metadataField3)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.not((Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataField(metadataField2))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void findByFieldName_schemaElementAndQualifier() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataSchema schema = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)"ASchema", (String)"http://www.dspace.org/ns/aschema").build();
        MetadataSchema schema2 = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)"ASchema2", (String)"http://www.dspace.org/ns/aschema2").build();
        MetadataField metadataField = MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)schema, (String)"AnElement1", (String)"AQualifier", (String)"AScopeNote").build();
        MetadataField metadataField2 = MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)schema2, (String)"AnElement2", (String)"AQualifier", (String)"AScopeNote2").build();
        MetadataField metadataField3 = MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)schema, (String)"AnElement3", (String)"AQualifier", (String)"AScopeNote3").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)SEARCH_BYFIELDNAME_ENDPOINT, (Object[])new Object[0]).param("schema", new String[]{schema.getName()}).param("element", new String[]{metadataField3.getElement()}).param("qualifier", new String[]{metadataField3.getQualifier()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.not((Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataField(metadataField))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.not((Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataField(metadataField2))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataField(metadataField3)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findByFieldName_query() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataSchema schema = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)"ASchema", (String)"http://www.dspace.org/ns/aschema").build();
        MetadataSchema schema2 = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)"ASchema2", (String)"http://www.dspace.org/ns/aschema2").build();
        MetadataField metadataField = MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)schema, (String)"AnElement1", (String)"AQualifier", (String)"AScopeNote").build();
        MetadataField metadataField2 = MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)schema2, (String)"AnElement2", (String)"AQualifier", (String)"AScopeNote2").build();
        MetadataField metadataField3 = MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)schema, (String)"AnElement3", (String)"AQualifier", (String)"AScopeNote2").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)SEARCH_BYFIELDNAME_ENDPOINT, (Object[])new Object[0]).param("query", new String[]{schema.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataField(metadataField)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataField(metadataField3)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataField(metadataField2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)SEARCH_BYFIELDNAME_ENDPOINT, (Object[])new Object[0]).param("query", new String[]{schema.getName() + ".AnElement3"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.not((Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataField(metadataField))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataField(metadataField3)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.not((Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataField(metadataField2))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)SEARCH_BYFIELDNAME_ENDPOINT, (Object[])new Object[0]).param("query", new String[]{"AnElement3.AQual"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.not((Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataField(metadataField))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataField(metadataField3)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.not((Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataField(metadataField2))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findByFieldName_query_noQualifier() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataSchema schema = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)"ASchema", (String)"http://www.dspace.org/ns/aschema").build();
        MetadataSchema schema2 = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)"test", (String)"http://www.dspace.org/ns/aschema2").build();
        MetadataField metadataField = MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)schema, (String)"AnElement1", null, (String)"AScopeNote").build();
        MetadataField metadataField2 = MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)schema2, (String)"AnElement2", null, (String)"AScopeNote2").build();
        MetadataField metadataField3 = MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)schema, (String)"test", null, (String)"AScopeNote2").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)SEARCH_BYFIELDNAME_ENDPOINT, (Object[])new Object[0]).param("query", new String[]{"test"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.not((Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataField(metadataField))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataField(metadataField3)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataField(metadataField2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void findByFieldName_invalidQuery() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)SEARCH_BYFIELDNAME_ENDPOINT, (Object[])new Object[0]).param("query", new String[]{"schema.element.qualifier.morestuff"})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void findByFieldName_exactName() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataSchema schema = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)"ASchema", (String)"http://www.dspace.org/ns/aschema").build();
        MetadataSchema schema2 = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)"test", (String)"http://www.dspace.org/ns/aschema2").build();
        MetadataField metadataField = MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)schema, (String)"AnElement1", null, (String)"AScopeNote").build();
        MetadataField metadataField2 = MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)schema2, (String)"AnElement2", null, (String)"AScopeNote2").build();
        MetadataField metadataField3 = MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)schema, (String)"test", null, (String)"AScopeNote2").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)SEARCH_BYFIELDNAME_ENDPOINT, (Object[])new Object[0]).param("exactName", new String[]{metadataField.toString('.')})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataField(metadataField)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.not((Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataField(metadataField3))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.not((Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataField(metadataField2))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findByFieldName_exactName_NoResult() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)SEARCH_BYFIELDNAME_ENDPOINT, (Object[])new Object[0]).param("exactName", new String[]{"not.valid.mdstring"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findByFieldName_exactName_combinedDiscoveryQueryParams_query() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataSchema schema = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)"ASchema", (String)"http://www.dspace.org/ns/aschema").build();
        MetadataField metadataField = MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)schema, (String)"AnElement1", null, (String)"AScopeNote").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)SEARCH_BYFIELDNAME_ENDPOINT, (Object[])new Object[0]).param("exactName", new String[]{metadataField.toString('.')}).param("query", new String[]{"query"})).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void findByFieldName_exactName_combinedDiscoveryQueryParams_schema() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataSchema schema = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)"ASchema", (String)"http://www.dspace.org/ns/aschema").build();
        MetadataField metadataField = MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)schema, (String)"AnElement1", null, (String)"AScopeNote").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)SEARCH_BYFIELDNAME_ENDPOINT, (Object[])new Object[0]).param("exactName", new String[]{metadataField.toString('.')}).param("schema", new String[]{"schema"})).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void findByFieldName_exactName_combinedDiscoveryQueryParams_element() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataSchema schema = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)"ASchema", (String)"http://www.dspace.org/ns/aschema").build();
        MetadataField metadataField = MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)schema, (String)"AnElement1", null, (String)"AScopeNote").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)SEARCH_BYFIELDNAME_ENDPOINT, (Object[])new Object[0]).param("exactName", new String[]{metadataField.toString('.')}).param("element", new String[]{"element"})).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void findByFieldName_exactName_combinedDiscoveryQueryParams_qualifier() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataSchema schema = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)"ASchema", (String)"http://www.dspace.org/ns/aschema").build();
        MetadataField metadataField = MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)schema, (String)"AnElement1", null, (String)"AScopeNote").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)SEARCH_BYFIELDNAME_ENDPOINT, (Object[])new Object[0]).param("exactName", new String[]{metadataField.toString('.')}).param("qualifier", new String[]{"qualifier"})).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createSuccess() throws Exception {
        MetadataFieldRest metadataFieldRest = new MetadataFieldRest();
        metadataFieldRest.setElement("testElementForCreate");
        metadataFieldRest.setQualifier("testQualifierForCreate");
        metadataFieldRest.setScopeNote(SCOPE_NOTE);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        try {
            MatcherAssert.assertThat((Object)this.metadataFieldService.findByElement(this.context, this.metadataSchema, ELEMENT, QUALIFIER), (Matcher)Matchers.nullValue());
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/metadatafields", (Object[])new Object[0]).param("schemaId", new String[]{"" + this.metadataSchema.getID()}).param("projection", new String[]{"full"}).content(new ObjectMapper().writeValueAsBytes((Object)metadataFieldRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)(METADATAFIELDS_ENDPOINT + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", MetadataFieldMatcher.matchMetadataFieldByKeys(this.metadataSchema.getName(), "testElementForCreate", "testQualifierForCreate")));
        }
        finally {
            MetadataFieldBuilder.deleteMetadataField((Integer)((Integer)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void createBlankQualifier() throws Exception {
        MetadataFieldRest metadataFieldRest = new MetadataFieldRest();
        metadataFieldRest.setElement(ELEMENT);
        metadataFieldRest.setQualifier("");
        metadataFieldRest.setScopeNote(SCOPE_NOTE);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        Integer id = null;
        try {
            MatcherAssert.assertThat((Object)this.metadataFieldService.findByElement(this.context, this.metadataSchema, ELEMENT, null), (Matcher)Matchers.nullValue());
            id = (Integer)JsonPath.read((String)this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/metadatafields", (Object[])new Object[0]).param("schemaId", new String[]{"" + this.metadataSchema.getID()}).content(new ObjectMapper().writeValueAsBytes((Object)metadataFieldRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andReturn().getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]);
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)(METADATAFIELDS_ENDPOINT + id), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", MetadataFieldMatcher.matchMetadataFieldByKeys(this.metadataSchema.getName(), ELEMENT, null)));
            if (id == null) return;
        }
        catch (Throwable throwable) {
            if (id == null) throw throwable;
            MetadataFieldBuilder.deleteMetadataField(id);
            throw throwable;
        }
        MetadataFieldBuilder.deleteMetadataField((Integer)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void create_checkAddedToIndex() throws Exception {
        MetadataFieldRest metadataFieldRest = new MetadataFieldRest();
        metadataFieldRest.setElement("testElementForCreate");
        metadataFieldRest.setQualifier("testQualifierForCreate");
        metadataFieldRest.setScopeNote(SCOPE_NOTE);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        try {
            MatcherAssert.assertThat((Object)this.metadataFieldService.findByElement(this.context, this.metadataSchema, ELEMENT, QUALIFIER), (Matcher)Matchers.nullValue());
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/metadatafields", (Object[])new Object[0]).param("schemaId", new String[]{"" + this.metadataSchema.getID()}).param("projection", new String[]{"full"}).content(new ObjectMapper().writeValueAsBytes((Object)metadataFieldRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)(METADATAFIELDS_ENDPOINT + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", MetadataFieldMatcher.matchMetadataFieldByKeys(this.metadataSchema.getName(), "testElementForCreate", "testQualifierForCreate")));
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)SEARCH_BYFIELDNAME_ENDPOINT, (Object[])new Object[0]).param("schema", new String[]{this.metadataSchema.getName()}).param("element", new String[]{metadataFieldRest.getElement()}).param("qualifier", new String[]{metadataFieldRest.getQualifier()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataFieldByKeys(this.metadataSchema.getName(), metadataFieldRest.getElement(), metadataFieldRest.getQualifier())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        }
        finally {
            MetadataFieldBuilder.deleteMetadataField((Integer)((Integer)idRef.get()));
        }
    }

    @Test
    public void createUnauthorized() throws Exception {
        MetadataFieldRest metadataFieldRest = new MetadataFieldRest();
        metadataFieldRest.setElement(ELEMENT);
        metadataFieldRest.setQualifier(QUALIFIER);
        metadataFieldRest.setScopeNote(SCOPE_NOTE);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/metadatafields", (Object[])new Object[0]).param("schemaId", new String[]{"" + this.metadataSchema.getID()}).content(new ObjectMapper().writeValueAsBytes((Object)metadataFieldRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void createUnauthorizedEPersonNoAdminRights() throws Exception {
        MetadataFieldRest metadataFieldRest = new MetadataFieldRest();
        metadataFieldRest.setElement(ELEMENT);
        metadataFieldRest.setQualifier(QUALIFIER);
        metadataFieldRest.setScopeNote(SCOPE_NOTE);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/metadatafields", (Object[])new Object[0]).param("schemaId", new String[]{"" + this.metadataSchema.getID()}).content(new ObjectMapper().writeValueAsBytes((Object)metadataFieldRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void deleteSuccess() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataField metadataField = MetadataFieldBuilder.createMetadataField((Context)this.context, (String)ELEMENT, (String)QUALIFIER, (String)SCOPE_NOTE).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)(METADATAFIELDS_ENDPOINT + metadataField.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)(METADATAFIELDS_ENDPOINT + metadataField.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)(METADATAFIELDS_ENDPOINT + metadataField.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void deleteUnauthorized() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataField metadataField = MetadataFieldBuilder.createMetadataField((Context)this.context, (String)ELEMENT, (String)QUALIFIER, (String)SCOPE_NOTE).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)(METADATAFIELDS_ENDPOINT + metadataField.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)(METADATAFIELDS_ENDPOINT + metadataField.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)(METADATAFIELDS_ENDPOINT + metadataField.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void deleteUnauthorizedEPersonNoAdminRights() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataField metadataField = MetadataFieldBuilder.createMetadataField((Context)this.context, (String)ELEMENT, (String)QUALIFIER, (String)SCOPE_NOTE).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)(METADATAFIELDS_ENDPOINT + metadataField.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)(METADATAFIELDS_ENDPOINT + metadataField.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)(METADATAFIELDS_ENDPOINT + metadataField.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void deleteNonExisting() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataField metadataField = MetadataFieldBuilder.createMetadataField((Context)this.context, (String)ELEMENT, (String)QUALIFIER, (String)SCOPE_NOTE).build();
        this.context.restoreAuthSystemState();
        Integer id = metadataField.getID();
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)(METADATAFIELDS_ENDPOINT + id), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        MatcherAssert.assertThat((Object)this.metadataFieldService.find(this.context, id.intValue()), (Matcher)Matchers.nullValue());
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)(METADATAFIELDS_ENDPOINT + id), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void delete_checkDeletedFromIndex() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataSchema schema = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)"ASchema", (String)"http://www.dspace.org/ns/aschema").build();
        MetadataField metadataField = MetadataFieldBuilder.createMetadataField((Context)this.context, (MetadataSchema)schema, (String)ELEMENT, (String)QUALIFIER, (String)SCOPE_NOTE).build();
        this.context.restoreAuthSystemState();
        Integer id = metadataField.getID();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)SEARCH_BYFIELDNAME_ENDPOINT, (Object[])new Object[0]).param("schema", new String[]{schema.getName()}).param("element", new String[]{metadataField.getElement()}).param("qualifier", new String[]{metadataField.getQualifier()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataField(metadataField))));
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)(METADATAFIELDS_ENDPOINT + id), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        MatcherAssert.assertThat((Object)this.metadataFieldService.find(this.context, id.intValue()), (Matcher)Matchers.nullValue());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)SEARCH_BYFIELDNAME_ENDPOINT, (Object[])new Object[0]).param("schema", new String[]{schema.getName()}).param("element", new String[]{metadataField.getElement()}).param("qualifier", new String[]{metadataField.getQualifier()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void update() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataField metadataField = MetadataFieldBuilder.createMetadataField((Context)this.context, (String)ELEMENT, (String)QUALIFIER, (String)SCOPE_NOTE).build();
        this.context.restoreAuthSystemState();
        MetadataFieldRest metadataFieldRest = new MetadataFieldRest();
        metadataFieldRest.setId((Serializable)metadataField.getID());
        metadataFieldRest.setElement(ELEMENT_UPDATED);
        metadataFieldRest.setQualifier(QUALIFIER_UPDATED);
        metadataFieldRest.setScopeNote(SCOPE_NOTE_UPDATED);
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.put((String)(METADATAFIELDS_ENDPOINT + metadataField.getID()), (Object[])new Object[0]).content(new ObjectMapper().writeValueAsBytes((Object)metadataFieldRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)(METADATAFIELDS_ENDPOINT + metadataField.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", MetadataFieldMatcher.matchMetadataFieldByKeys(this.metadataSchema.getName(), ELEMENT_UPDATED, QUALIFIER_UPDATED)));
    }

    @Test
    public void update_checkUpdatedInIndex() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataField metadataField = MetadataFieldBuilder.createMetadataField((Context)this.context, (String)ELEMENT, (String)QUALIFIER, (String)SCOPE_NOTE).build();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)SEARCH_BYFIELDNAME_ENDPOINT, (Object[])new Object[0]).param("schema", new String[]{this.metadataSchema.getName()}).param("element", new String[]{metadataField.getElement()}).param("qualifier", new String[]{metadataField.getQualifier()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataFieldByKeys(this.metadataSchema.getName(), metadataField.getElement(), metadataField.getQualifier())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.context.restoreAuthSystemState();
        MetadataFieldRest metadataFieldRest = new MetadataFieldRest();
        metadataFieldRest.setId((Serializable)metadataField.getID());
        metadataFieldRest.setElement(ELEMENT_UPDATED);
        metadataFieldRest.setQualifier(QUALIFIER_UPDATED);
        metadataFieldRest.setScopeNote(SCOPE_NOTE_UPDATED);
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.put((String)(METADATAFIELDS_ENDPOINT + metadataField.getID()), (Object[])new Object[0]).content(new ObjectMapper().writeValueAsBytes((Object)metadataFieldRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)SEARCH_BYFIELDNAME_ENDPOINT, (Object[])new Object[0]).param("schema", new String[]{this.metadataSchema.getName()}).param("element", new String[]{ELEMENT_UPDATED}).param("qualifier", new String[]{QUALIFIER_UPDATED})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.hasItem(MetadataFieldMatcher.matchMetadataFieldByKeys(this.metadataSchema.getName(), ELEMENT_UPDATED, QUALIFIER_UPDATED)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)SEARCH_BYFIELDNAME_ENDPOINT, (Object[])new Object[0]).param("schema", new String[]{this.metadataSchema.getName()}).param("element", new String[]{metadataField.getElement()}).param("qualifier", new String[]{metadataField.getQualifier()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void updateUnauthorized() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataField metadataField = MetadataFieldBuilder.createMetadataField((Context)this.context, (String)ELEMENT, (String)QUALIFIER, (String)SCOPE_NOTE).build();
        this.context.restoreAuthSystemState();
        MetadataFieldRest metadataFieldRest = new MetadataFieldRest();
        metadataFieldRest.setId((Serializable)metadataField.getID());
        metadataFieldRest.setElement(ELEMENT_UPDATED);
        metadataFieldRest.setQualifier(QUALIFIER_UPDATED);
        metadataFieldRest.setScopeNote(SCOPE_NOTE_UPDATED);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.put((String)(METADATAFIELDS_ENDPOINT + metadataField.getID()), (Object[])new Object[0]).content(new ObjectMapper().writeValueAsBytes((Object)metadataFieldRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)(METADATAFIELDS_ENDPOINT + metadataField.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", MetadataFieldMatcher.matchMetadataFieldByKeys(this.metadataSchema.getName(), ELEMENT, QUALIFIER)));
    }

    @Test
    public void updateWrongRights() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataField metadataField = MetadataFieldBuilder.createMetadataField((Context)this.context, (String)ELEMENT, (String)QUALIFIER, (String)SCOPE_NOTE).build();
        this.context.restoreAuthSystemState();
        MetadataFieldRest metadataFieldRest = new MetadataFieldRest();
        metadataFieldRest.setId((Serializable)metadataField.getID());
        metadataFieldRest.setElement(ELEMENT_UPDATED);
        metadataFieldRest.setQualifier(QUALIFIER_UPDATED);
        metadataFieldRest.setScopeNote(SCOPE_NOTE_UPDATED);
        this.getClient(this.getAuthToken(this.eperson.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.put((String)(METADATAFIELDS_ENDPOINT + metadataField.getID()), (Object[])new Object[0]).content(new ObjectMapper().writeValueAsBytes((Object)metadataFieldRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)(METADATAFIELDS_ENDPOINT + metadataField.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", MetadataFieldMatcher.matchMetadataFieldByKeys(this.metadataSchema.getName(), ELEMENT, QUALIFIER)));
    }

    @Test
    public void findAllPaginationTest() throws Exception {
        List alphabeticMdFields = ContentServiceFactory.getInstance().getMetadataFieldService().findAll(this.context).stream().sorted(Comparator.comparing(mdf -> mdf.toString('.'))).collect(Collectors.toList());
        int numberOfMdFields = alphabeticMdFields.size();
        int pageSize = 3;
        int numberOfPages = (int)Math.ceil((double)numberOfMdFields / (double)pageSize);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/metadatafields", (Object[])new Object[0]).param("size", new String[]{String.valueOf(pageSize)}).param("page", new String[]{"0"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{MetadataFieldMatcher.matchMetadataField((MetadataField)alphabeticMdFields.get(0)), MetadataFieldMatcher.matchMetadataField((MetadataField)alphabeticMdFields.get(1)), MetadataFieldMatcher.matchMetadataField((MetadataField)alphabeticMdFields.get(2))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/metadatafields?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)("size=" + pageSize))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/metadatafields?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)("size=" + pageSize))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/metadatafields?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)("size=" + pageSize))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/metadatafields?"), (Matcher)Matchers.containsString((String)("page=" + (numberOfPages - 1))), (Matcher)Matchers.containsString((String)("size=" + pageSize))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)numberOfMdFields))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)numberOfPages))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)pageSize)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/metadatafields", (Object[])new Object[0]).param("size", new String[]{String.valueOf(pageSize)}).param("page", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{MetadataFieldMatcher.matchMetadataField((MetadataField)alphabeticMdFields.get(3)), MetadataFieldMatcher.matchMetadataField((MetadataField)alphabeticMdFields.get(4)), MetadataFieldMatcher.matchMetadataField((MetadataField)alphabeticMdFields.get(5))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/metadatafields?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)("size=" + pageSize))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/metadatafields?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)("size=" + pageSize))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/metadatafields?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)("size=" + pageSize))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/metadatafields?"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)("size=" + pageSize))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/metadatafields?"), (Matcher)Matchers.containsString((String)("page=" + (numberOfPages - 1))), (Matcher)Matchers.containsString((String)("size=" + pageSize))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)numberOfMdFields))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)numberOfPages))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)pageSize)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/metadatafields", (Object[])new Object[0]).param("size", new String[]{String.valueOf(pageSize)}).param("page", new String[]{String.valueOf(numberOfPages - 1)})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadatafields", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{MetadataFieldMatcher.matchMetadataField((MetadataField)alphabeticMdFields.get(alphabeticMdFields.size() - 1))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/metadatafields?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)("size=" + pageSize))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/metadatafields?"), (Matcher)Matchers.containsString((String)("page=" + (numberOfPages - 2))), (Matcher)Matchers.containsString((String)("size=" + pageSize))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/metadatafields?"), (Matcher)Matchers.containsString((String)("page=" + (numberOfPages - 1))), (Matcher)Matchers.containsString((String)("size=" + pageSize))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/metadatafields?"), (Matcher)Matchers.containsString((String)("page=" + (numberOfPages - 1))), (Matcher)Matchers.containsString((String)("size=" + pageSize))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)numberOfMdFields))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)numberOfPages))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)pageSize)));
    }
}

