/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import javax.servlet.ServletException;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class SitemapRestControllerIT
extends AbstractControllerIntegrationTest {
    @Autowired
    ConfigurationService configurationService;
    private static final String SITEMAPS_ENDPOINT = "sitemaps";
    private Item item1;
    private Item item2;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.configurationService.setProperty("sitemap.path", (Object)SITEMAPS_ENDPOINT);
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).build();
        this.item1 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Test 1").withIssueDate("2010-10-17").build();
        this.item2 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Test 2").withIssueDate("2015-8-3").build();
        this.runDSpaceScript(new String[]{"generate-sitemaps"});
        this.context.restoreAuthSystemState();
    }

    @After
    public void destroy() throws Exception {
        this.runDSpaceScript(new String[]{"generate-sitemaps", "-d"});
        super.destroy();
    }

    @Test
    public void testSitemap_notValidSiteMapFile() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sitemaps/no-such-file", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test(expected=ServletException.class)
    public void testSitemap_fileSystemTraversal_dspaceCfg() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sitemaps/%2e%2e/config/dspace.cfg", (Object[])new Object[0]));
    }

    @Test(expected=ServletException.class)
    public void testSitemap_fileSystemTraversal_dspaceCfg2() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sitemaps/%2e%2e%2fconfig%2fdspace.cfg", (Object[])new Object[0]));
    }

    @Test
    public void testSitemap_sitemapIndexHtml() throws Exception {
        MvcResult result = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sitemaps/sitemap_index.html", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("text/html;charset=UTF-8")).andReturn();
        String response = result.getResponse().getContentAsString();
        Assert.assertTrue((boolean)response.contains("/sitemap0.html"));
    }

    @Test
    public void testSitemap_sitemap0Html() throws Exception {
        MvcResult result = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sitemaps/sitemap0.html", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("text/html;charset=UTF-8")).andReturn();
        String response = result.getResponse().getContentAsString();
        Assert.assertTrue((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/items/" + this.item1.getID()));
        Assert.assertTrue((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/items/" + this.item2.getID()));
    }

    @Test
    public void testSitemap_sitemapIndexXml() throws Exception {
        MvcResult result = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sitemaps/sitemap_index.xml", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("application/xml;charset=UTF-8")).andReturn();
        String response = result.getResponse().getContentAsString();
        Assert.assertTrue((boolean)response.contains("/sitemap0.xml"));
    }

    @Test
    public void testSitemap_sitemap0Xml() throws Exception {
        MvcResult result = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sitemaps/sitemap0.xml", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("application/xml;charset=UTF-8")).andReturn();
        String response = result.getResponse().getContentAsString();
        Assert.assertTrue((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/items/" + this.item1.getID()));
        Assert.assertTrue((boolean)response.contains(this.configurationService.getProperty("dspace.ui.url") + "/items/" + this.item2.getID()));
    }
}

