/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import org.dspace.app.rest.matcher.SubmissionCCLicenseMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class SubmissionCCLicenseRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Test
    public void findAllTest() throws Exception {
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissioncclicenses", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.submissioncclicenses", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SubmissionCCLicenseMatcher.matchLicenseEntry(1, new int[]{3, 2, 3}), SubmissionCCLicenseMatcher.matchLicenseEntry(2, new int[]{2}), SubmissionCCLicenseMatcher.matchLicenseEntry(3, new int[0])})));
    }

    @Test
    public void findOneTest() throws Exception {
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissioncclicenses/license1", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(SubmissionCCLicenseMatcher.matchLicenseEntry(1, new int[]{3, 2, 3}))));
    }

    @Test
    public void findOneTestNonExistingLicense() throws Exception {
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissioncclicenses/non-existing-license", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findAllTestUnAuthorized() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissioncclicenses", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneTestUnAuthorized() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissioncclicenses/license1", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }
}

