/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.IOException;
import java.sql.SQLException;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.WorkspaceItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.handle.service.HandleService;
import org.dspace.identifier.DOIIdentifierProvider;
import org.dspace.services.ConfigurationService;
import org.junit.After;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class SubmissionShowIdentifiersRestIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private WorkspaceItemService workspaceItemService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private HandleService handleService;
    private Collection collection;
    private EPerson submitter;

    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Root community").build();
        this.submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter.em@test.com").withPassword(this.password).build();
        this.collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection").withEntityType("Publication").withSubmitterGroup(new EPerson[]{this.submitter}).build();
        this.configurationService.setProperty("identifiers.submission.register", (Object)true);
        this.context.restoreAuthSystemState();
    }

    @After
    public void after() throws SQLException, IOException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        this.workspaceItemService.findAll(this.context).forEach(this::deleteWorkspaceItem);
        this.configurationService.setProperty("identifiers.submission.register", (Object)false);
        this.context.restoreAuthSystemState();
    }

    private void deleteWorkspaceItem(WorkspaceItem workspaceItem) {
        try {
            this.workspaceItemService.deleteAll(this.context, workspaceItem);
        }
        catch (IOException | SQLException | AuthorizeException e) {
            throw new RuntimeException();
        }
    }

    @Test
    public void testItemHandleReservation() throws Exception {
        this.context.turnOffAuthorisationSystem();
        WorkspaceItem workspaceItem = this.createWorkspaceItem("Test publication", this.collection);
        this.context.restoreAuthSystemState();
        String expectedHandle = this.handleService.resolveToURL(this.context, workspaceItem.getItem().getHandle());
        String submitterToken = this.getAuthToken(this.submitter.getEmail(), this.password);
        this.getClient(submitterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + workspaceItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.identifiers.identifiers[1].type", (Object[])new Object[0]).value((Object)"identifier")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.identifiers.identifiers[1].value", (Object[])new Object[0]).value((Object)expectedHandle)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.identifiers.identifiers[1].identifierType", (Object[])new Object[0]).value((Object)"handle"));
    }

    @Test
    public void testItemDoiReservation() throws Exception {
        this.context.turnOffAuthorisationSystem();
        WorkspaceItem workspaceItem = this.createWorkspaceItem("Test publication", this.collection);
        this.context.restoreAuthSystemState();
        String submitterToken = this.getAuthToken(this.submitter.getEmail(), this.password);
        this.getClient(submitterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + workspaceItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.identifiers.identifiers[0].type", (Object[])new Object[0]).value((Object)"identifier")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.identifiers.identifiers[0].identifierType", (Object[])new Object[0]).value((Object)"doi")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.identifiers.identifiers[0].identifierStatus", (Object[])new Object[0]).value((Object)DOIIdentifierProvider.statusText[DOIIdentifierProvider.PENDING]));
    }

    private WorkspaceItem createWorkspaceItem(String title, Collection collection) {
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).withTitle(title).withSubmitter(this.submitter).build();
        return workspaceItem;
    }
}

