/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;
import org.dspace.alerts.AllowSessionsEnum;
import org.dspace.alerts.SystemWideAlert;
import org.dspace.app.rest.model.SystemWideAlertRest;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.SystemWideAlertBuilder;
import org.dspace.core.Context;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class SystemWideAlertRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Test
    public void findAllTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Date countdownDate = new Date();
        SystemWideAlert systemWideAlert1 = SystemWideAlertBuilder.createSystemWideAlert((Context)this.context, (String)"Test alert 1").withAllowSessions(AllowSessionsEnum.ALLOW_CURRENT_SESSIONS_ONLY).withCountdownDate(countdownDate).isActive(true).build();
        SystemWideAlert systemWideAlert2 = SystemWideAlertBuilder.createSystemWideAlert((Context)this.context, (String)"Test alert 2").withAllowSessions(AllowSessionsEnum.ALLOW_ADMIN_SESSIONS_ONLY).withCountdownDate(null).isActive(false).build();
        this.context.restoreAuthSystemState();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/systemwidealerts/", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.systemwidealerts", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.alertId", (Matcher)Matchers.is((Object)systemWideAlert1.getID())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.message", (Matcher)Matchers.is((Object)systemWideAlert1.getMessage())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.allowSessions", (Matcher)Matchers.is((Object)systemWideAlert1.getAllowSessions().getValue())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.countdownTo", (Matcher)Matchers.startsWith((String)sdf.format(systemWideAlert1.getCountdownTo()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.active", (Matcher)Matchers.is((Object)systemWideAlert1.isActive()))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.alertId", (Matcher)Matchers.is((Object)systemWideAlert2.getID())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.message", (Matcher)Matchers.is((Object)systemWideAlert2.getMessage())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.allowSessions", (Matcher)Matchers.is((Object)systemWideAlert2.getAllowSessions().getValue())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.countdownTo", (Matcher)Matchers.is((Object)systemWideAlert2.getCountdownTo())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.active", (Matcher)Matchers.is((Object)systemWideAlert2.isActive())))})));
    }

    @Test
    public void findAllUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Date countdownDate = new Date();
        SystemWideAlert systemWideAlert1 = SystemWideAlertBuilder.createSystemWideAlert((Context)this.context, (String)"Test alert 1").withAllowSessions(AllowSessionsEnum.ALLOW_CURRENT_SESSIONS_ONLY).withCountdownDate(countdownDate).isActive(true).build();
        SystemWideAlert systemWideAlert2 = SystemWideAlertBuilder.createSystemWideAlert((Context)this.context, (String)"Test alert 2").withAllowSessions(AllowSessionsEnum.ALLOW_ADMIN_SESSIONS_ONLY).withCountdownDate(null).isActive(false).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/systemwidealerts/", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findAllForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Date countdownDate = new Date();
        SystemWideAlert systemWideAlert1 = SystemWideAlertBuilder.createSystemWideAlert((Context)this.context, (String)"Test alert 1").withAllowSessions(AllowSessionsEnum.ALLOW_CURRENT_SESSIONS_ONLY).withCountdownDate(countdownDate).isActive(true).build();
        SystemWideAlert systemWideAlert2 = SystemWideAlertBuilder.createSystemWideAlert((Context)this.context, (String)"Test alert 2").withAllowSessions(AllowSessionsEnum.ALLOW_ADMIN_SESSIONS_ONLY).withCountdownDate(null).isActive(false).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/systemwidealerts/", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findOneTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Date countdownDate = new Date();
        SystemWideAlert systemWideAlert1 = SystemWideAlertBuilder.createSystemWideAlert((Context)this.context, (String)"Test alert 1").withAllowSessions(AllowSessionsEnum.ALLOW_CURRENT_SESSIONS_ONLY).withCountdownDate(countdownDate).isActive(true).build();
        SystemWideAlert systemWideAlert2 = SystemWideAlertBuilder.createSystemWideAlert((Context)this.context, (String)"Test alert 2").withAllowSessions(AllowSessionsEnum.ALLOW_ADMIN_SESSIONS_ONLY).withCountdownDate(null).isActive(false).build();
        this.context.restoreAuthSystemState();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/system/systemwidealerts/" + systemWideAlert1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.alertId", (Matcher)Matchers.is((Object)systemWideAlert1.getID())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.message", (Matcher)Matchers.is((Object)systemWideAlert1.getMessage())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.allowSessions", (Matcher)Matchers.is((Object)systemWideAlert1.getAllowSessions().getValue())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.countdownTo", (Matcher)Matchers.startsWith((String)sdf.format(systemWideAlert1.getCountdownTo()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.active", (Matcher)Matchers.is((Object)systemWideAlert1.isActive())))));
    }

    @Test
    public void findOneUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Date countdownDate = new Date();
        SystemWideAlert systemWideAlert1 = SystemWideAlertBuilder.createSystemWideAlert((Context)this.context, (String)"Test alert 1").withAllowSessions(AllowSessionsEnum.ALLOW_CURRENT_SESSIONS_ONLY).withCountdownDate(countdownDate).isActive(true).build();
        SystemWideAlert systemWideAlert2 = SystemWideAlertBuilder.createSystemWideAlert((Context)this.context, (String)"Test alert 2").withAllowSessions(AllowSessionsEnum.ALLOW_ADMIN_SESSIONS_ONLY).withCountdownDate(null).isActive(false).build();
        this.context.restoreAuthSystemState();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/system/systemwidealerts/" + systemWideAlert1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.alertId", (Matcher)Matchers.is((Object)systemWideAlert1.getID())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.message", (Matcher)Matchers.is((Object)systemWideAlert1.getMessage())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.allowSessions", (Matcher)Matchers.is((Object)systemWideAlert1.getAllowSessions().getValue())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.countdownTo", (Matcher)Matchers.startsWith((String)sdf.format(systemWideAlert1.getCountdownTo()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.active", (Matcher)Matchers.is((Object)systemWideAlert1.isActive())))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/system/systemwidealerts/" + systemWideAlert2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findOneForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Date countdownDate = new Date();
        SystemWideAlert systemWideAlert1 = SystemWideAlertBuilder.createSystemWideAlert((Context)this.context, (String)"Test alert 1").withAllowSessions(AllowSessionsEnum.ALLOW_CURRENT_SESSIONS_ONLY).withCountdownDate(countdownDate).isActive(true).build();
        SystemWideAlert systemWideAlert2 = SystemWideAlertBuilder.createSystemWideAlert((Context)this.context, (String)"Test alert 2").withAllowSessions(AllowSessionsEnum.ALLOW_ADMIN_SESSIONS_ONLY).withCountdownDate(null).isActive(false).build();
        this.context.restoreAuthSystemState();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/system/systemwidealerts/" + systemWideAlert1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.alertId", (Matcher)Matchers.is((Object)systemWideAlert1.getID())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.message", (Matcher)Matchers.is((Object)systemWideAlert1.getMessage())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.allowSessions", (Matcher)Matchers.is((Object)systemWideAlert1.getAllowSessions().getValue())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.countdownTo", (Matcher)Matchers.startsWith((String)sdf.format(systemWideAlert1.getCountdownTo()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.active", (Matcher)Matchers.is((Object)systemWideAlert1.isActive())))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/system/systemwidealerts/" + systemWideAlert2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findAllActiveTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Date countdownDate = new Date();
        SystemWideAlert systemWideAlert1 = SystemWideAlertBuilder.createSystemWideAlert((Context)this.context, (String)"Test alert 1").withAllowSessions(AllowSessionsEnum.ALLOW_CURRENT_SESSIONS_ONLY).withCountdownDate(countdownDate).isActive(true).build();
        SystemWideAlert systemWideAlert2 = SystemWideAlertBuilder.createSystemWideAlert((Context)this.context, (String)"Test alert 2").withAllowSessions(AllowSessionsEnum.ALLOW_ADMIN_SESSIONS_ONLY).withCountdownDate(null).isActive(false).build();
        SystemWideAlert systemWideAlert3 = SystemWideAlertBuilder.createSystemWideAlert((Context)this.context, (String)"Test alert 3").withAllowSessions(AllowSessionsEnum.ALLOW_ADMIN_SESSIONS_ONLY).withCountdownDate(null).isActive(true).build();
        this.context.restoreAuthSystemState();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/system/systemwidealerts/search/active", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.systemwidealerts", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.alertId", (Matcher)Matchers.is((Object)systemWideAlert1.getID())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.message", (Matcher)Matchers.is((Object)systemWideAlert1.getMessage())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.allowSessions", (Matcher)Matchers.is((Object)systemWideAlert1.getAllowSessions().getValue())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.countdownTo", (Matcher)Matchers.startsWith((String)sdf.format(systemWideAlert1.getCountdownTo()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.active", (Matcher)Matchers.is((Object)systemWideAlert1.isActive()))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.alertId", (Matcher)Matchers.is((Object)systemWideAlert3.getID())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.message", (Matcher)Matchers.is((Object)systemWideAlert3.getMessage())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.allowSessions", (Matcher)Matchers.is((Object)systemWideAlert3.getAllowSessions().getValue())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.countdownTo", (Matcher)Matchers.is((Object)systemWideAlert3.getCountdownTo())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.active", (Matcher)Matchers.is((Object)systemWideAlert3.isActive())))})));
    }

    @Test
    public void createTest() throws Exception {
        SystemWideAlertRest systemWideAlertRest = new SystemWideAlertRest();
        systemWideAlertRest.setMessage("Alert test message");
        systemWideAlertRest.setCountdownTo(new Date());
        systemWideAlertRest.setAllowSessions(AllowSessionsEnum.ALLOW_CURRENT_SESSIONS_ONLY.getValue());
        systemWideAlertRest.setActive(true);
        ObjectMapper mapper = new ObjectMapper();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/system/systemwidealerts/", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)systemWideAlertRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.alertId"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.message", (Matcher)Matchers.is((Object)systemWideAlertRest.getMessage())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.allowSessions", (Matcher)Matchers.is((Object)systemWideAlertRest.getAllowSessions())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.countdownTo", (Matcher)Matchers.startsWith((String)sdf.format(systemWideAlertRest.getCountdownTo()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.active", (Matcher)Matchers.is((Object)systemWideAlertRest.isActive()))))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.alertId", (Predicate[])new Predicate[0])));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/system/systemwidealerts/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.alertId", (Matcher)Matchers.is((Object)((Integer)idRef.get()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.message", (Matcher)Matchers.is((Object)systemWideAlertRest.getMessage())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.allowSessions", (Matcher)Matchers.is((Object)systemWideAlertRest.getAllowSessions())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.countdownTo", (Matcher)Matchers.startsWith((String)sdf.format(systemWideAlertRest.getCountdownTo()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.active", (Matcher)Matchers.is((Object)systemWideAlertRest.isActive())))));
    }

    @Test
    public void createForbiddenTest() throws Exception {
        SystemWideAlertRest systemWideAlertRest = new SystemWideAlertRest();
        systemWideAlertRest.setMessage("Alert test message");
        systemWideAlertRest.setCountdownTo(new Date());
        systemWideAlertRest.setAllowSessions(AllowSessionsEnum.ALLOW_CURRENT_SESSIONS_ONLY.getValue());
        systemWideAlertRest.setActive(true);
        ObjectMapper mapper = new ObjectMapper();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/system/systemwidealerts/", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)systemWideAlertRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void createUnAuthorizedTest() throws Exception {
        SystemWideAlertRest systemWideAlertRest = new SystemWideAlertRest();
        systemWideAlertRest.setMessage("Alert test message");
        systemWideAlertRest.setCountdownTo(new Date());
        systemWideAlertRest.setAllowSessions(AllowSessionsEnum.ALLOW_CURRENT_SESSIONS_ONLY.getValue());
        systemWideAlertRest.setActive(true);
        ObjectMapper mapper = new ObjectMapper();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/system/systemwidealerts/", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)systemWideAlertRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void createWhenAlreadyExistsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        SystemWideAlert systemWideAlert = SystemWideAlertBuilder.createSystemWideAlert((Context)this.context, (String)"Test alert").withAllowSessions(AllowSessionsEnum.ALLOW_ADMIN_SESSIONS_ONLY).withCountdownDate(null).isActive(false).build();
        this.context.restoreAuthSystemState();
        SystemWideAlertRest systemWideAlertRest = new SystemWideAlertRest();
        systemWideAlertRest.setMessage("Alert test message");
        systemWideAlertRest.setCountdownTo(new Date());
        systemWideAlertRest.setAllowSessions(AllowSessionsEnum.ALLOW_CURRENT_SESSIONS_ONLY.getValue());
        systemWideAlertRest.setActive(true);
        ObjectMapper mapper = new ObjectMapper();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/system/systemwidealerts/", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)systemWideAlertRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void putTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        SystemWideAlert systemWideAlert = SystemWideAlertBuilder.createSystemWideAlert((Context)this.context, (String)"Alert test message").withAllowSessions(AllowSessionsEnum.ALLOW_ADMIN_SESSIONS_ONLY).withCountdownDate(null).isActive(false).build();
        this.context.restoreAuthSystemState();
        SystemWideAlertRest systemWideAlertRest = new SystemWideAlertRest();
        systemWideAlertRest.setAlertId(systemWideAlert.getID());
        systemWideAlertRest.setMessage("Updated alert test message");
        systemWideAlertRest.setCountdownTo(new Date());
        systemWideAlertRest.setAllowSessions(AllowSessionsEnum.ALLOW_CURRENT_SESSIONS_ONLY.getValue());
        systemWideAlertRest.setActive(true);
        ObjectMapper mapper = new ObjectMapper();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/system/systemwidealerts/" + systemWideAlert.getID()), (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)systemWideAlertRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.alertId"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.message", (Matcher)Matchers.is((Object)systemWideAlertRest.getMessage())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.allowSessions", (Matcher)Matchers.is((Object)systemWideAlertRest.getAllowSessions())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.countdownTo", (Matcher)Matchers.startsWith((String)sdf.format(systemWideAlertRest.getCountdownTo()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.active", (Matcher)Matchers.is((Object)systemWideAlertRest.isActive())))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/system/systemwidealerts/" + systemWideAlert.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.alertId", (Matcher)Matchers.is((Object)systemWideAlert.getID())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.message", (Matcher)Matchers.is((Object)systemWideAlertRest.getMessage())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.allowSessions", (Matcher)Matchers.is((Object)systemWideAlertRest.getAllowSessions())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.countdownTo", (Matcher)Matchers.startsWith((String)sdf.format(systemWideAlertRest.getCountdownTo()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.active", (Matcher)Matchers.is((Object)systemWideAlertRest.isActive())))));
    }
}

