/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.IOUtils;
import org.dspace.app.rest.authorization.Authorization;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.converter.VersionConverter;
import org.dspace.app.rest.matcher.AuthorizationMatcher;
import org.dspace.app.rest.matcher.ItemMatcher;
import org.dspace.app.rest.matcher.VersionMatcher;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.VersionRest;
import org.dspace.app.rest.model.patch.AddOperation;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.patch.RemoveOperation;
import org.dspace.app.rest.model.patch.ReplaceOperation;
import org.dspace.app.rest.projection.DefaultProjection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.BundleBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.VersionBuilder;
import org.dspace.builder.WorkflowItemBuilder;
import org.dspace.builder.WorkspaceItemBuilder;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.services.ConfigurationService;
import org.dspace.versioning.Version;
import org.dspace.versioning.service.VersioningService;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class VersionRestRepositoryIT
extends AbstractControllerIntegrationTest {
    private Item item;
    private Version version;
    @Autowired
    private VersioningService versioningService;
    @Autowired
    private VersionConverter versionConverter;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private InstallItemService installItemService;
    @Autowired
    private WorkspaceItemService workspaceItemService;
    @Autowired
    private AuthorizationFeatureService authorizationFeatureService;
    @Autowired
    private ItemService itemService;

    @Before
    public void setup() throws SQLException, AuthorizeException {
        this.configurationService.setProperty("webui.submit.upload.required", (Object)false);
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.version = VersionBuilder.createVersion((Context)this.context, (Item)this.item, (String)"Fixing some typos").build();
        this.context.restoreAuthSystemState();
    }

    @Test
    public void findOneTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versions/" + this.version.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(VersionMatcher.matchEntry(this.version)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.versionhistory.href", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)("api/versioning/versions/" + this.version.getID() + "/versionhistory"))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.item.href", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)("api/versioning/versions/" + this.version.getID() + "/item"))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)("api/versioning/versions/" + this.version.getID()))})));
    }

    @Test
    public void findOneSubmitterNameVisisbleTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versions/" + this.version.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(VersionMatcher.matchEntry(this.version)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.submitterName", (Matcher)Matchers.is((Object)this.version.getEPerson().getFullName())));
    }

    @Test
    public void findOneSubmitterNameConfigurationPropertyFalseAdminUserLinkVisibleTest() throws Exception {
        this.configurationService.setProperty("versioning.item.history.include.submitter", (Object)false);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versions/" + this.version.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(VersionMatcher.matchEntry(this.version)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.submitterName", (Matcher)Matchers.is((Object)this.version.getEPerson().getFullName())));
        this.configurationService.setProperty("versioning.item.history.include.submitter", (Object)true);
    }

    @Test
    public void findOneSubmitterNameConfigurationPropertyTrueNormalUserLinkVisibleTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versions/" + this.version.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(VersionMatcher.matchEntry(this.version)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.submitterName", (Matcher)Matchers.is((Object)this.version.getEPerson().getFullName())));
    }

    @Test
    public void findOneSubmitterNameConfigurationPropertyTrueAnonUserLinkVisibleTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versions/" + this.version.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(VersionMatcher.matchEntry(this.version)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.submitterName", (Matcher)Matchers.is((Object)this.version.getEPerson().getFullName())));
    }

    @Test
    public void findOneSubmitterNameConfigurationPropertyFalseNormalUserLinkInvisibleTest() throws Exception {
        this.configurationService.setProperty("versioning.item.history.include.submitter", (Object)false);
        String adminToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versions/" + this.version.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(VersionMatcher.matchEntry(this.version)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.submitterName", (Object[])new Object[0]).doesNotExist());
        this.configurationService.setProperty("versioning.item.history.include.submitter", (Object)true);
    }

    @Test
    public void findOneUnauthorizedTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versions/" + this.version.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneForbiddenTest() throws Exception {
        this.configurationService.setProperty("versioning.item.history.view.admin", (Object)true);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versions/" + this.version.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.configurationService.setProperty("versioning.item.history.view.admin", (Object)false);
    }

    @Test
    public void findOneWithVersioningDisabledTest() throws Exception {
        this.configurationService.setProperty("versioning.enabled", (Object)false);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/versioning/versions/2147483647", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/versioning/versions/2147483647", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/versioning/versions/2147483647", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void versionForItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        WorkspaceItem workspaceItem = this.workspaceItemService.findByItem(this.context, this.version.getItem());
        this.installItemService.installItem(this.context, (InProgressSubmission)workspaceItem);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.version.getItem().getID() + "/version"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(VersionMatcher.matchEntry(this.version))));
    }

    @Test
    public void versionItemTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versions/" + this.version.getID() + "/item"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ItemMatcher.matchItemProperties(this.version.getItem()))));
    }

    @Test
    public void versionItemTestWrongId() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versions/" + (this.version.getID() + 5) * 57 + "/item"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createFirstVersionItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-04-27").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        try {
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/versioning/versions", (Object[])new Object[0]).param("summary", new String[]{"test summary!"}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/core/items/" + item.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.version", (Matcher)Matchers.is((Object)2)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.summary", (Matcher)Matchers.is((Object)"test summary!")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.submitterName", (Matcher)Matchers.is((Object)"first (admin) last (admin)")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"version"))))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        }
        finally {
            VersionBuilder.delete((Integer)((Integer)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createFirstVersionWithoutSummaryTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-04-27").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        try {
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/versioning/versions", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/core/items/" + item.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.version", (Matcher)Matchers.is((Object)2)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.summary", (Matcher)Matchers.emptyOrNullString()), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.submitterName", (Matcher)Matchers.is((Object)"first (admin) last (admin)")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"version"))))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        }
        finally {
            VersionBuilder.delete((Integer)((Integer)idRef.get()));
        }
    }

    @Test
    public void createFirstVersionItemBadRequestTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/versioning/versions", (Object[])new Object[0]).param("summary", new String[]{"test summary!"}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/core/test/" + UUID.randomUUID())).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void createFirstVersionItemForbiddenTest() throws Exception {
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/versioning/versions", (Object[])new Object[0]).param("summary", new String[]{"test summary!"}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/core/items/" + this.item.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void createFirstVersionItemUnauthorizedTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/versioning/versions", (Object[])new Object[0]).param("summary", new String[]{"test summary!"}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/core/items/" + this.item.getID())).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createVersionFromVersionedItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").withSubmitterGroup(new EPerson[]{this.admin}).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-04-27").withAuthor("Doe, John").withSubject("ExtraEntry").grantLicense().build();
        Version v2 = VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"test").build();
        Item lastVersionItem = v2.getItem();
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + lastVersionItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/workspaceitems/search/item", (Object[])new Object[0]).param("uuid", new String[]{String.valueOf(lastVersionItem.getID())})).andExpect(MockMvcResultMatchers.status().isOk()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"http://localhost/api/workflow/workflowitems", (Object[])new Object[0]).content("/api/submission/workspaceitems/" + idRef.get()).contentType(this.textUriContentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + lastVersionItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)true)));
        try {
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/versioning/versions", (Object[])new Object[0]).param("summary", new String[]{"test summary."}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/core/items/" + v2.getItem().getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.version", (Matcher)Matchers.is((Object)3)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.summary", (Matcher)Matchers.is((Object)"test summary.")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.submitterName", (Matcher)Matchers.is((Object)"first (admin) last (admin)")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"version"))))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        }
        finally {
            VersionBuilder.delete((Integer)((Integer)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createVersionByPreviousVersionRespectCurrentVersionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-03-20").withAuthor("Doe, John").withSubject("ExtraEntry").grantLicense().build();
        Version v2 = VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"test").build();
        Item lastVersionItem = v2.getItem();
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)true)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + lastVersionItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/versioning/versions", (Object[])new Object[0]).param("summary", new String[]{"check first version"}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/core/items/" + item.getID())).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/workspaceitems/search/item", (Object[])new Object[0]).param("uuid", new String[]{String.valueOf(lastVersionItem.getID())})).andExpect(MockMvcResultMatchers.status().isOk()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"http://localhost/api/workflow/workflowitems", (Object[])new Object[0]).content("/api/submission/workspaceitems/" + idRef.get()).contentType(this.textUriContentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + lastVersionItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)true)));
        try {
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/versioning/versions", (Object[])new Object[0]).param("summary", new String[]{"check first version"}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/core/items/" + item.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.version", (Matcher)Matchers.is((Object)3)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.summary", (Matcher)Matchers.is((Object)"check first version")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.submitterName", (Matcher)Matchers.is((Object)"first (admin) last (admin)")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"version"))))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        }
        finally {
            VersionBuilder.delete((Integer)((Integer)idRef.get()));
        }
    }

    @Test
    public void createVersionWithLastVersionInSubmissionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-03-20").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Version v = VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"test summary").build();
        Item item2 = v.getItem();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)true)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item2.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/versioning/versions", (Object[])new Object[0]).param("summary", new String[]{"check first version"}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/core/items/" + item.getID())).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void createVersionFromWorkflowItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withWorkflowGroup(1, new EPerson[]{this.admin}).withName("Collection test").build();
        XmlWorkflowItem workflowItem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col).withTitle("Workflow Item 1").withIssueDate("2017-10-17").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/versioning/versions", (Object[])new Object[0]).param("summary", new String[]{"fix workspaceitem"}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/core/items/" + workflowItem.getItem().getID())).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void createVersionFromWorkspaceItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").build();
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col).withTitle("Workspace Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/versioning/versions", (Object[])new Object[0]).param("summary", new String[]{"fix workspaceitem"}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/core/items/" + witem.getItem().getID())).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createFirstVersionItemWithSubmitterTest() throws Exception {
        this.configurationService.setProperty("versioning.submitterCanCreateNewVersion", (Object)true);
        this.context.turnOffAuthorisationSystem();
        Community rootCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)rootCommunity).withName("Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Item itemA = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public item").withIssueDate("2021-04-19").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        itemA.setSubmitter(this.eperson);
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        try {
            this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/versioning/versions", (Object[])new Object[0]).param("summary", new String[]{"test summary!"}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/core/items/" + itemA.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.version", (Matcher)Matchers.is((Object)2)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.summary", (Matcher)Matchers.is((Object)"test summary!")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"version"))))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        }
        finally {
            VersionBuilder.delete((Integer)((Integer)idRef.get()));
        }
    }

    @Test
    public void createFirstVersionItemWithSubmitterAndPropertyForSubmitterDisabledTest() throws Exception {
        this.configurationService.setProperty("versioning.submitterCanCreateNewVersion", (Object)false);
        this.context.turnOffAuthorisationSystem();
        Community rootCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)rootCommunity).withName("Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Item itemA = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public item").withIssueDate("2021-04-19").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        itemA.setSubmitter(this.eperson);
        this.context.restoreAuthSystemState();
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/versioning/versions", (Object[])new Object[0]).param("summary", new String[]{"test summary!"}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/core/items/" + itemA.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createFirstVersionItemWithEntityTypeTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").withEntityType("Publication").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-04-27").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        try {
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/versioning/versions", (Object[])new Object[0]).param("summary", new String[]{"test summary!"}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/core/items/" + item.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.version", (Matcher)Matchers.is((Object)2)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.summary", (Matcher)Matchers.is((Object)"test summary!")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.submitterName", (Matcher)Matchers.is((Object)"first (admin) last (admin)")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"version"))))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        }
        finally {
            VersionBuilder.delete((Integer)((Integer)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createFirstVersionItemWithEntityTypeBySubmitterTest() throws Exception {
        this.configurationService.setProperty("versioning.submitterCanCreateNewVersion", (Object)true);
        this.context.turnOffAuthorisationSystem();
        Community rootCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)rootCommunity).withName("Collection 1").withEntityType("Publication").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Item itemA = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public item").withIssueDate("2021-04-19").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        itemA.setSubmitter(this.eperson);
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        try {
            this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/versioning/versions", (Object[])new Object[0]).param("summary", new String[]{"test summary!"}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/core/items/" + itemA.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.version", (Matcher)Matchers.is((Object)2)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.summary", (Matcher)Matchers.is((Object)"test summary!")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"version"))))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        }
        finally {
            VersionBuilder.delete((Integer)((Integer)idRef.get()));
        }
    }

    @Test
    public void createVersionWithVersioningDisabledTest() throws Exception {
        this.configurationService.setProperty("versioning.enabled", (Object)false);
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-04-27").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/versioning/versions", (Object[])new Object[0]).param("summary", new String[]{"test summary!"}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/core/items/" + item.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/versioning/versions", (Object[])new Object[0]).param("summary", new String[]{"test summary!"}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/core/items/" + item.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/versioning/versions", (Object[])new Object[0]).param("summary", new String[]{"test summary!"}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/core/items/" + item.getID())).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createNewVersionItemByCollectionAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community rootCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        EPerson colAdmin = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withEmail("coladmin@email.com").withPassword(this.password).withNameInMetadata("Collection", "Admin").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)rootCommunity).withName("Collection 1").withAdminGroup(new EPerson[]{colAdmin}).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2022-12-19").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        item.setSubmitter(this.eperson);
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        String token = this.getAuthToken(colAdmin.getEmail(), this.password);
        try {
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/versioning/versions", (Object[])new Object[0]).param("summary", new String[]{"test summary!"}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/core/items/" + item.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.version", (Matcher)Matchers.is((Object)2)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.summary", (Matcher)Matchers.is((Object)"test summary!")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"version"))))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        }
        finally {
            VersionBuilder.delete((Integer)((Integer)idRef.get()));
        }
    }

    @Test
    public void patchReplaceSummaryTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-04-27").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Version v2 = VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"test").build();
        this.context.restoreAuthSystemState();
        String newSummary = "New Summary";
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/summary", (Object)newSummary);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/versioning/versions/" + v2.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.version", (Matcher)Matchers.is((Object)v2.getVersionNumber())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.summary", (Matcher)Matchers.is((Object)newSummary)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.submitterName", (Matcher)Matchers.is((Object)"first last")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"version"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)("api/versioning/versions/" + v2.getID()))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.item.href", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)("api/versioning/versions/" + v2.getID() + "/item"))})));
    }

    @Test
    public void patchRemoveSummaryTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-04-27").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Version v2 = VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"test").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        RemoveOperation replaceOperation = new RemoveOperation("/summary");
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/versioning/versions/" + v2.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.version", (Matcher)Matchers.is((Object)v2.getVersionNumber())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.summary", (Matcher)Matchers.emptyString()), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.submitterName", (Matcher)Matchers.is((Object)"first last")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"version"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)("api/versioning/versions/" + v2.getID()))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.item.href", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)("api/versioning/versions/" + v2.getID() + "/item"))})));
    }

    @Test
    public void patchAddSummaryTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-04-27").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Version v2 = VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"").build();
        this.context.restoreAuthSystemState();
        String summary = "First Summary!";
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation replaceOperation = new AddOperation("/summary", (Object)summary);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/versioning/versions/" + v2.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.version", (Matcher)Matchers.is((Object)v2.getVersionNumber())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.summary", (Matcher)Matchers.is((Object)summary)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.submitterName", (Matcher)Matchers.is((Object)"first last")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"version"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)("api/versioning/versions/" + v2.getID()))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.item.href", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)("api/versioning/versions/" + v2.getID() + "/item"))})));
    }

    @Test
    public void patchVersionNotFoundTest() throws Exception {
        String summary = "Test Summary!";
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation replaceOperation = new AddOperation("/summary", (Object)summary);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/versioning/versions/2147483647", (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void patchAddSummaryBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-04-27").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Version v2 = VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"test").build();
        this.context.restoreAuthSystemState();
        String summary = "First Summary!";
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation replaceOperation = new AddOperation("/summary", (Object)summary);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/versioning/versions/" + v2.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void patchWrongPathUnprocessableEntityTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-04-27").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Version v2 = VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"test").build();
        this.context.restoreAuthSystemState();
        String summary = "First Summary!";
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation replaceOperation = new AddOperation("/wrongPath", (Object)summary);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/versioning/versions/" + v2.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void patchReplaceVersionUnprocessableEntityTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-04-27").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Version v2 = VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"test").build();
        this.context.restoreAuthSystemState();
        String newVersion = "133";
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/version", (Object)newVersion);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/versioning/versions/" + v2.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void patchReplaceSummaryUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-04-27").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Version v2 = VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"test").build();
        this.context.restoreAuthSystemState();
        String newSummary = "New Summary";
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/summary", (Object)newSummary);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/versioning/versions/" + v2.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void patchRemoveSummaryUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-04-27").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Version v2 = VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"test").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        RemoveOperation replaceOperation = new RemoveOperation("/summary");
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/versioning/versions/" + v2.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void patchRemoveSummaryForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-04-27").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Version v2 = VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"test").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        RemoveOperation replaceOperation = new RemoveOperation("/summary");
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/versioning/versions/" + v2.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void patchReplaceSummaryByCollectionAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection title").withAdminGroup(new EPerson[]{this.eperson}).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-03-08").withSubject("ExtraEntry").build();
        Version v2 = VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"test").build();
        this.context.restoreAuthSystemState();
        String newSummary = "New Summary";
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/summary", (Object)newSummary);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String colAdminToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(colAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/versioning/versions/" + v2.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.version", (Matcher)Matchers.is((Object)v2.getVersionNumber())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.summary", (Matcher)Matchers.is((Object)newSummary)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"version")))));
    }

    @Test
    public void patchReplaceSummaryByCommunityAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson adminCommA = EPersonBuilder.createEPerson((Context)this.context).withEmail("adminCommA@mail.com").withPassword(this.password).build();
        EPerson adminCommB = EPersonBuilder.createEPerson((Context)this.context).withEmail("adminCommB@mail.com").withPassword(this.password).build();
        Community rootCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community subCommunityA = CommunityBuilder.createSubCommunity((Context)this.context, (Community)rootCommunity).withName("subCommunity A").withAdminGroup(new EPerson[]{adminCommA}).build();
        CommunityBuilder.createSubCommunity((Context)this.context, (Community)rootCommunity).withName("subCommunity B").withAdminGroup(new EPerson[]{adminCommB}).build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)subCommunityA).withName("Collection title").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-03-08").withSubject("ExtraEntry").build();
        Version v2 = VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"test").build();
        this.context.restoreAuthSystemState();
        String newSummary = "New Summary";
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/summary", (Object)newSummary);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String adminCommAToken = this.getAuthToken(adminCommA.getEmail(), this.password);
        String adminCommBToken = this.getAuthToken(adminCommB.getEmail(), this.password);
        this.getClient(adminCommBToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/versioning/versions/" + v2.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(adminCommAToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versions/" + v2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(VersionMatcher.matchEntry(v2))));
        this.getClient(adminCommAToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/versioning/versions/" + v2.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(adminCommAToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versions/" + v2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.version", (Matcher)Matchers.is((Object)v2.getVersionNumber())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.summary", (Matcher)Matchers.is((Object)newSummary)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"version")))));
    }

    @Test
    public void patchReplaceSummaryWithVersioningDisabledTest() throws Exception {
        this.configurationService.setProperty("versioning.enabled", (Object)false);
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").build();
        ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-04-27").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String newSummary = "New Summary";
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/summary", (Object)newSummary);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/versioning/versions/2147483647", (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/versioning/versions/2147483647", (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/versioning/versions/2147483647", (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void deleteVersionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").withSubmitterGroup(new EPerson[]{this.admin}).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-03-20").withAuthor("Doe, John").withSubject("ExtraEntry").grantLicense().build();
        Version v2 = VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"test").build();
        Item lastVersionItem = v2.getItem();
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        Integer versionID = v2.getID();
        Item versionItem = v2.getItem();
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + lastVersionItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/workspaceitems/search/item", (Object[])new Object[0]).param("uuid", new String[]{String.valueOf(lastVersionItem.getID())})).andExpect(MockMvcResultMatchers.status().isOk()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"http://localhost/api/workflow/workflowitems", (Object[])new Object[0]).content("/api/submission/workspaceitems/" + idRef.get()).contentType(this.textUriContentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + lastVersionItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)true)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versions/" + versionID), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(VersionMatcher.matchEntry(v2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.versionhistory.href", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)("api/versioning/versions/" + v2.getID() + "/versionhistory"))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.item.href", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)("api/versioning/versions/" + v2.getID() + "/item"))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)("api/versioning/versions/" + v2.getID()))})));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + versionItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(204));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versions/" + versionID), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void checkDeleteOfMultipleVersionWithAuthorizationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        AuthorizationFeature canDeleteVersionFeature = this.authorizationFeatureService.find("canDeleteVersion");
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-03-20").withAuthor("Doe, John").withSubject("ExtraEntry").grantLicense().build();
        Version v2 = VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"test").build();
        Item lastVersionItem = v2.getItem();
        Version v1 = this.versioningService.getVersion(this.context, item);
        VersionRest versionRest = this.versionConverter.convert(v1, DefaultProjection.DEFAULT);
        Authorization admin2ItemA = new Authorization(this.admin, canDeleteVersionFeature, (BaseObjectRest)versionRest);
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)true)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + lastVersionItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/workspaceitems/search/item", (Object[])new Object[0]).param("uuid", new String[]{String.valueOf(lastVersionItem.getID())})).andExpect(MockMvcResultMatchers.status().isOk()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"http://localhost/api/workflow/workflowitems", (Object[])new Object[0]).content("/api/submission/workspaceitems/" + idRef.get()).contentType(this.textUriContentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + lastVersionItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)true)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + admin2ItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(admin2ItemA))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createFirstVersionItemWithBitstreamBySubmitterTest() throws Exception {
        this.configurationService.setProperty("versioning.submitterCanCreateNewVersion", (Object)true);
        this.context.turnOffAuthorisationSystem();
        Community rootCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)rootCommunity).withName("Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Item itemA = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public item").withIssueDate("2021-04-19").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        itemA.setSubmitter(this.eperson);
        Bundle bundle = BundleBuilder.createBundle((Context)this.context, (Item)itemA).withName("Bundle 0").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (Charset)StandardCharsets.UTF_8);){
            BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle, (InputStream)is).withName("Bitstream0").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        try {
            this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/versioning/versions", (Object[])new Object[0]).param("summary", new String[]{"test summary!"}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/core/items/" + itemA.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.version", (Matcher)Matchers.is((Object)2)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.summary", (Matcher)Matchers.is((Object)"test summary!")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"version"))))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        }
        finally {
            VersionBuilder.delete((Integer)((Integer)idRef.get()));
        }
    }

    @Test
    public void ignoreCollectionEntityTypeWhenCreatingNewVersionOfItem() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Collection").withEntityType("Person").build();
        Item v1 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("item version 1").build();
        this.itemService.replaceMetadata(this.context, (DSpaceObject)v1, "dspace", "entity", "type", "*", "Publication", null, -1, 0);
        this.itemService.update(this.context, (DSpaceObject)v1);
        this.context.commit();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + v1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.['dc.title']", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.value", (Matcher)Matchers.is((Object)"item version 1"))})), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.['dspace.entity.type']", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.value", (Matcher)Matchers.is((Object)"Publication"))})))));
        Item v2 = this.createNewVersion(v1, "item version 2");
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + v2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.['dc.title']", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.value", (Matcher)Matchers.is((Object)"item version 2"))})), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.['dspace.entity.type']", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.value", (Matcher)Matchers.is((Object)"Publication"))})))));
    }

    protected Item createNewVersion(Item oldItem, String newTitle) throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item newItem = VersionBuilder.createVersion((Context)this.context, (Item)oldItem, (String)("create: " + newTitle)).build().getItem();
        Assert.assertNotEquals((Object)oldItem, (Object)newItem);
        this.itemService.replaceMetadata(this.context, (DSpaceObject)newItem, "dc", "title", null, "*", newTitle, null, -1, 0);
        this.itemService.update(this.context, (DSpaceObject)newItem);
        this.context.commit();
        this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.findByItem(this.context, newItem));
        this.context.commit();
        this.context.restoreAuthSystemState();
        return newItem;
    }
}

