/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.authorization.Authorization;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.converter.CollectionConverter;
import org.dspace.app.rest.converter.CommunityConverter;
import org.dspace.app.rest.converter.ItemConverter;
import org.dspace.app.rest.matcher.AuthorizationMatcher;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.model.CommunityRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.projection.DefaultProjection;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.ResourcePolicyBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.discovery.SearchServiceException;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CanSubscribeFeatureIT
extends AbstractControllerIntegrationTest {
    private static final Logger log = LogManager.getLogger(CanSubscribeFeatureIT.class);
    @Autowired
    private ItemConverter itemConverter;
    @Autowired
    private CollectionConverter collectionConverter;
    @Autowired
    private CommunityConverter communityConverter;
    @Autowired
    private AuthorizationFeatureService authorizationFeatureService;
    @Autowired
    private ResourcePolicyService resourcePolicyService;
    private Community communityAuthorized;
    private Collection collectionAuthorized;
    private AuthorizationFeature canSubscribeFeature;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Community").build();
        this.communityAuthorized = CommunityBuilder.createCommunity((Context)this.context).withName("communityA").build();
        this.collectionAuthorized = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityAuthorized).withName("Collection A").build();
        this.context.restoreAuthSystemState();
        this.canSubscribeFeature = this.authorizationFeatureService.find("canSubscribeDso");
    }

    @Test
    public void canSubscribeCommunityAndCollectionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CommunityRest comRest = (CommunityRest)this.communityConverter.convert((DSpaceObject)this.parentCommunity, DefaultProjection.DEFAULT);
        CollectionRest colRest = (CollectionRest)this.collectionConverter.convert((DSpaceObject)this.collectionAuthorized, DefaultProjection.DEFAULT);
        Authorization epersonToCommunity = new Authorization(this.eperson, this.canSubscribeFeature, (BaseObjectRest)comRest);
        Authorization adminToCommunity = new Authorization(this.admin, this.canSubscribeFeature, (BaseObjectRest)comRest);
        Authorization epersonToCollection = new Authorization(this.eperson, this.canSubscribeFeature, (BaseObjectRest)colRest);
        Authorization adminToCollection = new Authorization(this.admin, this.canSubscribeFeature, (BaseObjectRest)colRest);
        Authorization anonymousToCommunity = new Authorization(null, this.canSubscribeFeature, (BaseObjectRest)comRest);
        Authorization anonymousToCollection = new Authorization(null, this.canSubscribeFeature, (BaseObjectRest)colRest);
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + epersonToCommunity.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(epersonToCommunity))));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + adminToCommunity.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(adminToCommunity))));
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + epersonToCollection.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(epersonToCollection))));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + adminToCollection.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(adminToCollection))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + anonymousToCommunity.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + anonymousToCollection.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void canNotSubscribeItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePersonNotSubscribePermission = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withPassword(this.password).withEmail("test@email.it").build();
        Group groupWithReadPermission = GroupBuilder.createGroup((Context)this.context).withName("Group A").addMember(this.eperson).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.collectionAuthorized).withTitle("Test item").build();
        this.cleanUpPermissions(this.resourcePolicyService.find(this.context, (DSpaceObject)item));
        this.setPermissions((DSpaceObject)item, groupWithReadPermission, 0);
        ItemRest itemRest = this.itemConverter.convert(item, Projection.DEFAULT);
        Authorization anonymousToItem = new Authorization(null, this.canSubscribeFeature, (BaseObjectRest)itemRest);
        Authorization epersonToItem = new Authorization(this.eperson, this.canSubscribeFeature, (BaseObjectRest)itemRest);
        Authorization adminToItem = new Authorization(this.admin, this.canSubscribeFeature, (BaseObjectRest)itemRest);
        Authorization ePersonNotSubscribePermissionToItem = new Authorization(ePersonNotSubscribePermission, this.canSubscribeFeature, (BaseObjectRest)itemRest);
        this.context.restoreAuthSystemState();
        String token1 = this.getAuthToken(this.eperson.getEmail(), this.password);
        String token2 = this.getAuthToken(this.admin.getEmail(), this.password);
        String token3 = this.getAuthToken(ePersonNotSubscribePermission.getEmail(), this.password);
        this.getClient(token1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + epersonToItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(token2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + adminToItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(token3).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + ePersonNotSubscribePermissionToItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + anonymousToItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void canNotSubscribeCollectionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePersonNotSubscribePermission = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withPassword(this.password).withEmail("test@email.it").build();
        Group groupWithReadPermission = GroupBuilder.createGroup((Context)this.context).withName("Group A").addMember(this.eperson).build();
        this.cleanUpPermissions(this.resourcePolicyService.find(this.context, (DSpaceObject)this.collectionAuthorized));
        this.setPermissions((DSpaceObject)this.collectionAuthorized, groupWithReadPermission, 0);
        CollectionRest collectionRest = (CollectionRest)this.collectionConverter.convert((DSpaceObject)this.collectionAuthorized, Projection.DEFAULT);
        Authorization epersonToCollection = new Authorization(this.eperson, this.canSubscribeFeature, (BaseObjectRest)collectionRest);
        Authorization adminToCollection = new Authorization(this.admin, this.canSubscribeFeature, (BaseObjectRest)collectionRest);
        Authorization ePersonNotSubscribePermissionToColl = new Authorization(ePersonNotSubscribePermission, this.canSubscribeFeature, (BaseObjectRest)collectionRest);
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        String token = this.getAuthToken(ePersonNotSubscribePermission.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + epersonToCollection.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(epersonToCollection))));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + adminToCollection.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(adminToCollection))));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + ePersonNotSubscribePermissionToColl.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void canNotSubscribeCommunityTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePersonNotSubscribePermission = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withPassword(this.password).withEmail("test@email.it").build();
        Group groupWithReadPermission = GroupBuilder.createGroup((Context)this.context).withName("Group A").addMember(this.eperson).build();
        this.cleanUpPermissions(this.resourcePolicyService.find(this.context, (DSpaceObject)this.communityAuthorized));
        this.setPermissions((DSpaceObject)this.communityAuthorized, groupWithReadPermission, 0);
        CommunityRest communityRest = (CommunityRest)this.communityConverter.convert((DSpaceObject)this.communityAuthorized, Projection.DEFAULT);
        Authorization epersonToComm = new Authorization(this.eperson, this.canSubscribeFeature, (BaseObjectRest)communityRest);
        Authorization adminToComm = new Authorization(this.admin, this.canSubscribeFeature, (BaseObjectRest)communityRest);
        Authorization ePersonNotSubscribePermissionToComm = new Authorization(ePersonNotSubscribePermission, this.canSubscribeFeature, (BaseObjectRest)communityRest);
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        String token = this.getAuthToken(ePersonNotSubscribePermission.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + epersonToComm.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(epersonToComm))));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + adminToComm.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(adminToComm))));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + ePersonNotSubscribePermissionToComm.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    private void setPermissions(DSpaceObject dSpaceObject, Group group, Integer permissions) {
        try {
            ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject(dSpaceObject).withAction(permissions.intValue()).withGroup(group).build();
        }
        catch (SQLException | AuthorizeException sqlException) {
            log.error(sqlException.getMessage());
        }
    }

    private void cleanUpPermissions(List<ResourcePolicy> resourcePolicies) {
        try {
            for (ResourcePolicy resourcePolicy : resourcePolicies) {
                ResourcePolicyBuilder.delete((Integer)resourcePolicy.getID());
            }
        }
        catch (IOException | SQLException | SearchServiceException sqlException) {
            log.error(sqlException.getMessage());
        }
    }
}

