/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import org.dspace.app.rest.authorization.Authorization;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.converter.SiteConverter;
import org.dspace.app.rest.matcher.AuthorizationMatcher;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.SiteRest;
import org.dspace.app.rest.projection.DefaultProjection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.EPersonBuilder;
import org.dspace.content.Site;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.SiteService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class EnrollAdministratorIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private AuthorizationFeatureService authorizationFeatureService;
    @Autowired
    GroupService groupService;
    @Autowired
    private SiteConverter siteConverter;
    private SiteService siteService;
    private AuthorizationFeature administratorFeature;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.siteService = ContentServiceFactory.getInstance().getSiteService();
        this.administratorFeature = this.authorizationFeatureService.find("administratorOf");
    }

    @Test
    public void addUserToAdminGroupOnSiteTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("johnbrown@example.com").withPassword(this.password).build();
        this.context.restoreAuthSystemState();
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, DefaultProjection.DEFAULT);
        Group adminGroup = this.groupService.findByName(this.context, "Administrator");
        String tokenEperson1 = this.getAuthToken(eperson1.getEmail(), this.password);
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + adminGroup.getID() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + eperson1.getID())).andExpect(MockMvcResultMatchers.status().isNoContent());
        Authorization authAdminSite = new Authorization(eperson1, this.administratorFeature, (BaseObjectRest)siteRest);
        this.getClient(tokenEperson1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminSite))));
    }
}

