/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import java.util.concurrent.Callable;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.converter.CollectionConverter;
import org.dspace.app.rest.converter.SiteConverter;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.model.SiteRest;
import org.dspace.app.rest.projection.DefaultProjection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.ResourcePolicyBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Site;
import org.dspace.content.service.SiteService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class SubmitFeatureIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private AuthorizationFeatureService authorizationFeatureService;
    @Autowired
    private SiteService siteService;
    @Autowired
    private CollectionConverter collectionConverter;
    @Autowired
    private SiteConverter siteConverter;
    @Autowired
    private Utils utils;
    private Group group;
    private String siteUri;
    private String epersonToken;
    private AuthorizationFeature submitFeature;
    private Community communityA;
    private Collection collectionA1;
    private Collection collectionA2;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.withSuppressedAuthorization(() -> {
            this.communityA = CommunityBuilder.createCommunity((Context)this.context).withName("Community A").build();
            this.collectionA1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityA).withName("Collection A1").build();
            this.collectionA2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityA).withName("Collection A2").build();
            this.group = GroupBuilder.createGroup((Context)this.context).withName("group").addMember(this.eperson).build();
            return null;
        });
        this.submitFeature = this.authorizationFeatureService.find("canSubmit");
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, DefaultProjection.DEFAULT);
        this.siteUri = this.utils.linkToSingleResource((RestAddressableModel)siteRest, "self").getHref();
    }

    @Test
    public void testNoRights() throws Exception {
        this.expectZeroResults(this.requestSitewideSubmitFeature());
    }

    @Test
    public void testDirectEPersonAddPolicy() throws Exception {
        ResourcePolicy rp = ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(this.eperson).withDspaceObject((DSpaceObject)this.collectionA1).withAction(3).build();
        this.expectSomeResults(this.requestSitewideSubmitFeature());
    }

    @Test
    public void testDirectGroupAddPolicy() throws Exception {
        ResourcePolicy rp = ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withGroup(this.group).withDspaceObject((DSpaceObject)this.collectionA1).withAction(3).build();
        this.expectSomeResults(this.requestSitewideSubmitFeature());
    }

    @Test
    public void testDirectEPersonAdminPolicy() throws Exception {
        ResourcePolicy rp = ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(this.eperson).withDspaceObject((DSpaceObject)this.collectionA1).withAction(11).build();
        this.expectSomeResults(this.requestSitewideSubmitFeature());
    }

    @Test
    public void testDirectGroupAdminPolicy() throws Exception {
        ResourcePolicy rp = ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withGroup(this.group).withDspaceObject((DSpaceObject)this.collectionA1).withAction(11).build();
        this.expectSomeResults(this.requestSitewideSubmitFeature());
    }

    @Test
    public void testCollectionAdmin() throws Exception {
        this.withSuppressedAuthorization(() -> {
            Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityA).withName("this is another test collection").withAdminGroup(new EPerson[]{this.eperson}).build();
            return null;
        });
        this.expectSomeResults(this.requestSitewideSubmitFeature());
    }

    @Test
    public void testCommunityWithoutCollectionsAdmin() throws Exception {
        this.withSuppressedAuthorization(() -> {
            Community comm = CommunityBuilder.createCommunity((Context)this.context).withName("This community contains no collections").withAdminGroup(new EPerson[]{this.eperson}).build();
            return null;
        });
        this.expectZeroResults(this.requestSitewideSubmitFeature());
    }

    @Test
    public void testCommunityWithCollectionsAdmin() throws Exception {
        this.withSuppressedAuthorization(() -> {
            Community comm = CommunityBuilder.createCommunity((Context)this.context).withName("This community contains a collection").withAdminGroup(new EPerson[]{this.eperson}).build();
            Collection coll = CollectionBuilder.createCollection((Context)this.context, (Community)comm).withName("Contained collection").build();
            return null;
        });
        this.expectSomeResults(this.requestSitewideSubmitFeature());
    }

    @Test
    public void testCommunityWithSubCommunityWithCollectionsAdmin() throws Exception {
        this.withSuppressedAuthorization(() -> {
            Community parent = CommunityBuilder.createCommunity((Context)this.context).withName("This community contains no collections").withAdminGroup(new EPerson[]{this.eperson}).build();
            Community child = CommunityBuilder.createSubCommunity((Context)this.context, (Community)parent).withName("This community contains a collection").build();
            Collection coll = CollectionBuilder.createCollection((Context)this.context, (Community)child).withName("Contained collection").build();
            return null;
        });
        this.expectSomeResults(this.requestSitewideSubmitFeature());
    }

    @Test
    public void testNoRightsOnCollection() throws Exception {
        this.expectZeroResults(this.requestSubmitFeature(this.getCollectionUri(this.collectionA1)));
        this.expectZeroResults(this.requestSubmitFeature(this.getCollectionUri(this.collectionA2)));
    }

    @Test
    public void testDirectEPersonAddPolicyOnCollection() throws Exception {
        ResourcePolicy rp = ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(this.eperson).withDspaceObject((DSpaceObject)this.collectionA1).withAction(3).build();
        this.expectSomeResults(this.requestSubmitFeature(this.getCollectionUri(this.collectionA1)));
        this.expectZeroResults(this.requestSubmitFeature(this.getCollectionUri(this.collectionA2)));
    }

    @Test
    public void testDirectGroupAddPolicyOnCollection() throws Exception {
        ResourcePolicy rp = ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withGroup(this.group).withDspaceObject((DSpaceObject)this.collectionA1).withAction(3).build();
        this.expectSomeResults(this.requestSubmitFeature(this.getCollectionUri(this.collectionA1)));
        this.expectZeroResults(this.requestSubmitFeature(this.getCollectionUri(this.collectionA2)));
    }

    @Test
    public void testDirectEPersonAdminPolicyOnCollection() throws Exception {
        ResourcePolicy rp = ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(this.eperson).withDspaceObject((DSpaceObject)this.collectionA1).withAction(11).build();
        this.expectSomeResults(this.requestSubmitFeature(this.getCollectionUri(this.collectionA1)));
        this.expectZeroResults(this.requestSubmitFeature(this.getCollectionUri(this.collectionA2)));
    }

    @Test
    public void testDirectGroupAdminPolicyOnCollection() throws Exception {
        ResourcePolicy rp = ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withGroup(this.group).withDspaceObject((DSpaceObject)this.collectionA1).withAction(11).build();
        this.expectSomeResults(this.requestSubmitFeature(this.getCollectionUri(this.collectionA1)));
        this.expectZeroResults(this.requestSubmitFeature(this.getCollectionUri(this.collectionA2)));
    }

    @Test
    public void testCollectionAdminOnCollection() throws Exception {
        Collection col = this.withSuppressedAuthorization(() -> CollectionBuilder.createCollection((Context)this.context, (Community)this.communityA).withName("this is another test collection").withAdminGroup(new EPerson[]{this.eperson}).build());
        this.expectSomeResults(this.requestSubmitFeature(this.getCollectionUri(col)));
        this.expectZeroResults(this.requestSubmitFeature(this.getCollectionUri(this.collectionA1)));
    }

    @Test
    public void testCommunityWithCollectionsAdminOnCollection() throws Exception {
        Collection coll = this.withSuppressedAuthorization(() -> {
            Community comm = CommunityBuilder.createCommunity((Context)this.context).withName("This community contains a collection").withAdminGroup(new EPerson[]{this.eperson}).build();
            return CollectionBuilder.createCollection((Context)this.context, (Community)comm).withName("Contained collection").build();
        });
        this.expectSomeResults(this.requestSubmitFeature(this.getCollectionUri(coll)));
    }

    @Test
    public void testCommunityWithSubCommunityWithCollectionsAdminOnCollection() throws Exception {
        Collection coll = this.withSuppressedAuthorization(() -> {
            Community parent = CommunityBuilder.createCommunity((Context)this.context).withName("This community contains no collections").withAdminGroup(new EPerson[]{this.eperson}).build();
            Community child = CommunityBuilder.createSubCommunity((Context)this.context, (Community)parent).withName("This community contains a collection").build();
            return CollectionBuilder.createCollection((Context)this.context, (Community)child).withName("Contained collection").build();
        });
        this.expectSomeResults(this.requestSubmitFeature(this.getCollectionUri(coll)));
    }

    private ResultActions requestSitewideSubmitFeature() throws Exception {
        return this.requestSubmitFeature(this.siteUri);
    }

    private ResultActions requestSubmitFeature(String uri) throws Exception {
        this.epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        return this.getClient(this.epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object?", (Object[])new Object[0]).param("uri", new String[]{uri}).param("feature", new String[]{this.submitFeature.getName()}).param("embed", new String[]{"feature"}));
    }

    private ResultActions expectSomeResults(ResultActions actions) throws Exception {
        return actions.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
    }

    private ResultActions expectZeroResults(ResultActions actions) throws Exception {
        return actions.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    private <T> T withSuppressedAuthorization(Callable<T> fn) throws Exception {
        this.context.turnOffAuthorisationSystem();
        T result = fn.call();
        this.context.restoreAuthSystemState();
        return result;
    }

    private String getCollectionUri(Collection collection) {
        CollectionRest collectionRest = (CollectionRest)this.collectionConverter.convert((DSpaceObject)collection, DefaultProjection.DEFAULT);
        return this.utils.linkToSingleResource((RestAddressableModel)collectionRest, "self").getHref();
    }
}

