/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.eperson;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.requestitem.RequestItemAuthor;
import org.dspace.app.requestitem.RequestItemAuthorExtractor;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.patch.ReplaceOperation;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.WorkflowItemBuilder;
import org.dspace.builder.WorkspaceItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.versioning.Version;
import org.dspace.versioning.factory.VersionServiceFactory;
import org.dspace.versioning.service.VersioningService;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.service.XmlWorkflowService;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.service.XmlWorkflowItemService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class DeleteEPersonSubmitterIT
extends AbstractControllerIntegrationTest {
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected XmlWorkflowService xmlWorkflowService = XmlWorkflowServiceFactory.getInstance().getXmlWorkflowService();
    protected XmlWorkflowItemService xmlWorkflowItemService = XmlWorkflowServiceFactory.getInstance().getXmlWorkflowItemService();
    protected VersioningService versioningService = VersionServiceFactory.getInstance().getVersionService();
    protected RequestItemAuthorExtractor requestItemAuthorExtractor = (RequestItemAuthorExtractor)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName("org.dspace.app.requestitem.RequestItemAuthorExtractor", RequestItemAuthorExtractor.class);
    private EPerson submitter;
    private EPerson submitterForVersion1;
    private EPerson submitterForVersion2;
    private EPerson workflowUser;
    private static final Logger log = LogManager.getLogger(DeleteEPersonSubmitterIT.class);

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.org").build();
        this.workflowUser = EPersonBuilder.createEPerson((Context)this.context).withEmail("workflowUser@example.org").build();
        this.submitterForVersion1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitterForVersion1@example.org").build();
        this.submitterForVersion2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitterForVersion2@example.org").build();
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testArchivedItemSubmitterDelete() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community parent = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)parent).build();
        WorkspaceItem wsi = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).withSubmitter(this.submitter).withTitle("Test Item").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Item installItem = this.installItemService.installItem(this.context, (InProgressSubmission)wsi);
        this.assertDeletionOfEperson(this.submitter);
        Assert.assertNull((Object)this.retrieveItemSubmitter(installItem.getID()));
        Item item = (Item)this.itemService.find(this.context, installItem.getID());
        List requestItemAuthor = this.requestItemAuthorExtractor.getRequestItemAuthor(this.context, item);
        Assert.assertEquals((Object)"Help Desk", (Object)((RequestItemAuthor)requestItemAuthor.get(0)).getFullName());
        Assert.assertEquals((Object)"dspace-help@myu.edu", (Object)((RequestItemAuthor)requestItemAuthor.get(0)).getEmail());
    }

    @Test
    public void testWIthdrawnItemSubmitterDelete() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community parent = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)parent).build();
        WorkspaceItem wsi = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).withSubmitter(this.submitter).withTitle("Test Item").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Item item = this.installItemService.installItem(this.context, (InProgressSubmission)wsi);
        ArrayList<Operation> opsToWithDraw = new ArrayList<Operation>();
        ReplaceOperation replaceOperationToWithDraw = new ReplaceOperation("/withdrawn", (Object)true);
        opsToWithDraw.add((Operation)replaceOperationToWithDraw);
        String patchBodyToWithdraw = this.getPatchContent(opsToWithDraw);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).content(patchBodyToWithdraw).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
        this.assertDeletionOfEperson(this.submitter);
        Assert.assertNull((Object)this.retrieveItemSubmitter(item.getID()));
        ArrayList<Operation> opsToReinstate = new ArrayList<Operation>();
        ReplaceOperation replaceOperationToReinstate = new ReplaceOperation("/withdrawn", (Object)false);
        opsToReinstate.add((Operation)replaceOperationToReinstate);
        String patchBodyToReinstate = this.getPatchContent(opsToReinstate);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).content(patchBodyToReinstate).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)true)));
        Assert.assertNull((Object)this.retrieveItemSubmitter(item.getID()));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).content(patchBodyToWithdraw).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
        Assert.assertNull((Object)this.retrieveItemSubmitter(item.getID()));
    }

    @Test
    public void testVersionItemSubmitterDelete() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.context.turnOffAuthorisationSystem();
        Community parent = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)parent).build();
        WorkspaceItem wsi = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).withSubmitter(this.submitter).withTitle("Test Item").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Item item = this.installItemService.installItem(this.context, (InProgressSubmission)wsi);
        this.context.setCurrentUser(this.submitter);
        Version version1 = this.versioningService.createNewVersion(this.context, item);
        Integer version1ID = version1.getID();
        WorkspaceItem version1WorkspaceItem = this.workspaceItemService.findByItem(this.context, version1.getItem());
        this.installItemService.installItem(this.context, (InProgressSubmission)version1WorkspaceItem);
        this.assertDeletionOfEperson(this.submitter);
        Assert.assertNull((Object)this.retrieveItemSubmitter(item.getID()));
        Item version1Item = this.retrieveVersionItem(version1ID);
        Assert.assertNull((Object)this.retrieveItemSubmitter(version1Item.getID()));
        this.context.setCurrentUser(this.submitterForVersion1);
        Version version2 = this.versioningService.createNewVersion(this.context, item);
        Integer version2ID = version2.getID();
        WorkspaceItem version2WorkspaceItem = this.workspaceItemService.findByItem(this.context, version2.getItem());
        this.installItemService.installItem(this.context, (InProgressSubmission)version2WorkspaceItem);
        Item version2Item = this.retrieveVersionItem(version2ID);
        Assert.assertEquals((Object)this.submitterForVersion1.getID(), (Object)this.retrieveItemSubmitter(version2Item.getID()).getID());
        this.context.setCurrentUser(this.submitterForVersion2);
        Version version3 = this.versioningService.createNewVersion(this.context, version2Item);
        Integer version3ID = version3.getID();
        this.assertDeletionOfEperson(this.submitterForVersion2);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versions/" + version3ID + "/item"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.cleanupVersion(version1ID);
        this.cleanupVersion(version2ID);
        this.cleanupVersion(version3ID);
    }

    @Test
    public void testWorkspaceItemSubmitterDelete() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community parent = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)parent).build();
        WorkspaceItem wsi = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).withSubmitter(this.submitter).withTitle("Test Item").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + wsi.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.assertDeletionOfEperson(this.submitter);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + wsi.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void testWorkflowItemSubmitterDelete() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community parent = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)parent).withWorkflowGroup(1, new EPerson[]{this.workflowUser}).build();
        XmlWorkflowItem workflowItem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)collection).withSubmitter(this.submitter).withTitle("Test Item").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + workflowItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.assertDeletionOfEperson(this.submitter);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + workflowItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    private void assertDeletionOfEperson(EPerson ePerson) throws SQLException {
        try {
            String token = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        }
        catch (Exception ex) {
            log.error("Caught an Exception while deleting an EPerson. " + ex.getClass().getName() + ": ", (Throwable)ex);
            Assert.fail((String)("Caught an Exception while deleting an EPerson. " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
        EPerson ePersonCheck = (EPerson)this.ePersonService.find(this.context, ePerson.getID());
        Assert.assertNull((Object)ePersonCheck);
    }

    private EPerson retrieveItemSubmitter(UUID itemID) throws Exception {
        Item item = (Item)this.itemService.find(this.context, itemID);
        return item.getSubmitter();
    }

    private Item retrieveVersionItem(int id) throws Exception {
        AtomicReference idRef = new AtomicReference();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versions/" + id + "/item"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andDo(result -> idRef.set((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.uuid", (Predicate[])new Predicate[0])));
        return (Item)this.itemService.find(this.context, UUID.fromString((String)idRef.get()));
    }

    private void cleanupVersion(int id) throws SQLException {
        Version version = this.versioningService.getVersion(this.context, id);
        this.versioningService.delete(this.context, version);
    }
}

