/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.hdlresolver;

import java.util.Arrays;
import java.util.List;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.StringContains;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class HdlResolverRestControllerIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private ConfigurationService configurationService;

    @Test
    public void givenMappedIdentifierWhenCallHdlresolverThenReturnsMappedURL() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withLogo("TestingContentForLogo").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").withHandle("123456789/testHdlResolver").build();
        this.context.restoreAuthSystemState();
        ResultMatcher matchHandleResponse = MockMvcResultMatchers.jsonPath((String)"$[0]", (Matcher)StringContains.containsString((String)"123456789/testHdlResolver"));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/listhandles/" + publicItem1.getHandle()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(matchHandleResponse);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/resolve/" + publicItem1.getHandle()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(matchHandleResponse);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/hdlresolver/" + publicItem1.getHandle()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(matchHandleResponse);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/wrongController/" + publicItem1.getHandle()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void givenAnyHandlesWhenDisabledListhandleThenReturnsNotFoundResp() throws Exception {
        this.configurationService.setProperty("handle.hide.listhandles", (Object)true);
        try {
            this.context.turnOffAuthorisationSystem();
            this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
            Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withLogo("TestingContentForLogo").build();
            String handlePrefix = "123456789/PREFIX";
            ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").withHandle(handlePrefix).build();
            this.context.restoreAuthSystemState();
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/listhandles/", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/listhandles/" + handlePrefix), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/listhandles/anyHandlePrefixHere", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.configurationService.setProperty("handle.hide.listhandles", (Object)false);
        }
    }

    @Test
    public void givenMappedHandlesWhenCalledListHandlesWithoutPrefixThenReturnsBadRequestResp() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withLogo("TestingContentForLogo").build();
        String handlePrefix = "123456789/PREFIX";
        ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").withHandle(handlePrefix).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/listhandles/", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void givenMappedHandlesWhenCalledListHandlesWithPrefixThenReturnsAllHandlesWithThatPrefix() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withLogo("TestingContentForLogo").build();
        String handlePrefix = "123456789/PREFIX";
        ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").withHandle(handlePrefix).build();
        String handlePrefix1 = "123456789/PREFIX1";
        ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").withHandle(handlePrefix1).build();
        String noHandle = "123456789/NOPREFIX";
        ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").withHandle(noHandle).build();
        String testHandle = "123456789/TEST";
        ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").withHandle(testHandle).build();
        this.context.restoreAuthSystemState();
        ResultMatcher matchHandleResponse = MockMvcResultMatchers.jsonPath((String)"$[*]", (Matcher)Matchers.allOf((Matcher)Matchers.containsInAnyOrder((Object[])new String[]{handlePrefix, handlePrefix1}), (Matcher)Matchers.not((Matcher)Matchers.containsInAnyOrder((Object[])new String[]{noHandle, testHandle}))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/listhandles/" + handlePrefix), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(matchHandleResponse);
    }

    @Test
    public void givenNullHdlIdentifierWhenCallHdlresolverThenReturnsBadRequest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hdlresolver/null", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/resolve/null", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void givenEmptyHdlIdentifierWhenCallHdlresolverThenReturnsNull() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hdlresolver/ ", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/resolve/ ", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void givenIdentifierNotMappedWhenCallHdlresolverThenReturnsNull() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hdlresolver/testHdlResolver/2", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string("null"));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/resolve/testHdlResolver/2", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string("null"));
    }

    @Test
    public void givenMappedPrefixWhenNoAdditionalPrefixesConfThenReturnsHandlePrefix() throws Exception {
        String handlePrefix = this.configurationService.getProperty("handle.prefix");
        ResultMatcher matchHandleResponse = MockMvcResultMatchers.jsonPath((String)"$[*]", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsInAnyOrder((Object[])new String[]{handlePrefix})}));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/listprefixes/", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(matchHandleResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenMappedPrefixWhenAdditionalPrefixesConfThenReturnsAllOfThem() throws Exception {
        String handlePrefix = this.configurationService.getProperty("handle.prefix");
        String[] defaultValue = this.configurationService.getArrayProperty("handle.additional.prefixes");
        try {
            String additionalPrefixes = "additional1,additional2";
            this.configurationService.setProperty("handle.additional.prefixes", (Object)additionalPrefixes);
            List<String> validPrefixes = Arrays.asList(additionalPrefixes.split(","));
            validPrefixes.add(handlePrefix);
            ResultMatcher matchHandleResponse = MockMvcResultMatchers.jsonPath((String)"$[*]", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsInAnyOrder((Object[])new List[]{validPrefixes})}));
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/listprefixes/", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(matchHandleResponse);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.configurationService.setProperty("handle.additional.prefixse", (Object)defaultValue);
        }
    }
}

