/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.matcher;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.util.ArrayList;
import java.util.List;
import org.dspace.external.provider.ExternalDataProvider;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class ExternalSourceMatcher {
    private ExternalSourceMatcher() {
    }

    public static Matcher<Iterable<? extends List<Matcher>>> matchAllExternalSources(List<ExternalDataProvider> providers, int max) {
        ArrayList<Matcher<? super Object>> matchers = new ArrayList<Matcher<? super Object>>();
        int count = 0;
        for (ExternalDataProvider provider : providers) {
            if (++count > max) break;
            matchers.add(ExternalSourceMatcher.matchExternalSource(provider));
        }
        return Matchers.contains((Matcher[])matchers.toArray(new Matcher[0]));
    }

    public static Matcher<? super Object> matchExternalSource(ExternalDataProvider provider) {
        return ExternalSourceMatcher.matchExternalSource(provider.getSourceIdentifier(), provider.getSourceIdentifier(), false);
    }

    public static Matcher<? super Object> matchExternalSource(String id, String name, boolean hierarchical) {
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)id)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)name)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.hierarchical", (Matcher)Matchers.is((Object)hierarchical)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.entries.href", (Matcher)Matchers.is((Object)("http://localhost/api/integration/externalsources/" + name + "/entries"))));
    }
}

