/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.matcher;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.StringEndsWith;

public class MetadataMatcher {
    private MetadataMatcher() {
    }

    public static Matcher<? super Object> matchMetadata(String key, String value) {
        return JsonPathMatchers.hasJsonPath((String)("$.['" + key + "'][*].value"), (Matcher)Matchers.hasItem((Object)value));
    }

    public static Matcher<? super Object> matchMetadataNotEmpty(String key) {
        return JsonPathMatchers.hasJsonPath((String)("$.['" + key + "']"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
    }

    public static Matcher<? super Object> matchMetadataStringEndsWith(String key, String subString) {
        return JsonPathMatchers.hasJsonPath((String)("$.['" + key + "'][*].value"), (Matcher)Matchers.hasItem((Matcher)StringEndsWith.endsWith((String)subString)));
    }

    public static Matcher<? super Object> matchMetadata(String key, String value, int position) {
        return JsonPathMatchers.hasJsonPath((String)("$.['" + key + "'][" + position + "].value"), (Matcher)Matchers.is((Object)value));
    }

    public static Matcher<? super Object> matchMetadata(String key, String value, String authority, int position) {
        Matcher hasValue = JsonPathMatchers.hasJsonPath((String)("$.['" + key + "'][" + position + "].value"), (Matcher)Matchers.is((Object)value));
        Matcher hasAuthority = JsonPathMatchers.hasJsonPath((String)("$.['" + key + "'][" + position + "].authority"), (Matcher)Matchers.is((Object)authority));
        return Matchers.allOf((Matcher)hasValue, (Matcher)hasAuthority);
    }

    public static Matcher<? super Object> matchMetadataDoesNotExist(String key) {
        return JsonPathMatchers.hasNoJsonPath((String)("$.['" + key + "']"));
    }
}

