/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.assertj.core.api.Assertions;
import org.dspace.app.rest.security.DSpaceCsrfTokenRepository;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.web.csrf.CsrfToken;

@RunWith(value=MockitoJUnitRunner.class)
public class DSpaceCsrfTokenRepositoryTest {
    DSpaceCsrfTokenRepository repository;
    MockHttpServletResponse response;
    MockHttpServletRequest request;

    @Before
    public void setup() {
        this.repository = new DSpaceCsrfTokenRepository();
        this.request = new MockHttpServletRequest();
        this.response = new MockHttpServletResponse();
        this.request.setContextPath("/context");
    }

    @Test
    public void generateToken() {
        CsrfToken generateToken = this.repository.generateToken((HttpServletRequest)this.request);
        Assertions.assertThat((Object)generateToken).isNotNull();
        Assertions.assertThat((String)generateToken.getHeaderName()).isEqualTo("X-XSRF-TOKEN");
        Assertions.assertThat((String)generateToken.getParameterName()).isEqualTo("_csrf");
        Assertions.assertThat((String)generateToken.getToken()).isNotEmpty();
    }

    @Test
    public void generateTokenCustom() {
        String headerName = "headerName";
        String parameterName = "paramName";
        this.repository.setHeaderName(headerName);
        this.repository.setParameterName(parameterName);
        CsrfToken generateToken = this.repository.generateToken((HttpServletRequest)this.request);
        Assertions.assertThat((Object)generateToken).isNotNull();
        Assertions.assertThat((String)generateToken.getHeaderName()).isEqualTo(headerName);
        Assertions.assertThat((String)generateToken.getParameterName()).isEqualTo(parameterName);
        Assertions.assertThat((String)generateToken.getToken()).isNotEmpty();
    }

    @Test
    public void saveToken() {
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((int)tokenCookie.getMaxAge()).isEqualTo(-1);
        Assertions.assertThat((String)tokenCookie.getName()).isEqualTo("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((String)tokenCookie.getPath()).isEqualTo(this.request.getContextPath());
        Assertions.assertThat((boolean)tokenCookie.getSecure()).isEqualTo(this.request.isSecure());
        Assertions.assertThat((String)tokenCookie.getValue()).isEqualTo(token.getToken());
        Assertions.assertThat((boolean)tokenCookie.isHttpOnly()).isEqualTo(true);
    }

    @Test
    public void saveTokenSecure() {
        this.request.setSecure(true);
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((boolean)tokenCookie.getSecure()).isTrue();
        List headers = this.response.getHeaders("Set-Cookie");
        Assertions.assertThat((int)headers.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)headers.get(0))).containsIgnoringCase((CharSequence)"SameSite=None");
    }

    @Test
    public void saveTokenNull() {
        this.request.setSecure(true);
        this.repository.saveToken(null, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((int)tokenCookie.getMaxAge()).isZero();
        Assertions.assertThat((String)tokenCookie.getName()).isEqualTo("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((String)tokenCookie.getPath()).isEqualTo(this.request.getContextPath());
        Assertions.assertThat((boolean)tokenCookie.getSecure()).isEqualTo(this.request.isSecure());
        Assertions.assertThat((String)tokenCookie.getValue()).isEmpty();
    }

    @Test
    public void saveTokenHttpOnlyTrue() {
        this.repository.setCookieHttpOnly(true);
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((boolean)tokenCookie.isHttpOnly()).isTrue();
    }

    @Test
    public void saveTokenHttpOnlyFalse() {
        this.repository.setCookieHttpOnly(false);
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((boolean)tokenCookie.isHttpOnly()).isFalse();
    }

    @Test
    public void saveTokenWithHttpOnlyFalse() {
        this.repository = DSpaceCsrfTokenRepository.withHttpOnlyFalse();
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((boolean)tokenCookie.isHttpOnly()).isFalse();
    }

    @Test
    public void saveTokenCustomPath() {
        String customPath = "/custompath";
        this.repository.setCookiePath(customPath);
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((String)tokenCookie.getPath()).isEqualTo(this.repository.getCookiePath());
    }

    @Test
    public void saveTokenEmptyCustomPath() {
        String customPath = "";
        this.repository.setCookiePath(customPath);
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((String)tokenCookie.getPath()).isEqualTo(this.request.getContextPath());
    }

    @Test
    public void saveTokenNullCustomPath() {
        String customPath = null;
        this.repository.setCookiePath(customPath);
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((String)tokenCookie.getPath()).isEqualTo(this.request.getContextPath());
    }

    @Test
    public void saveTokenWithCookieDomain() {
        String domainName = "example.com";
        this.repository.setCookieDomain(domainName);
        CsrfToken token = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(token, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie tokenCookie = this.response.getCookie("DSPACE-XSRF-COOKIE");
        Assertions.assertThat((String)tokenCookie.getDomain()).isEqualTo(domainName);
    }

    @Test
    public void loadTokenNoCookiesNull() {
        Assertions.assertThat((Object)this.repository.loadToken((HttpServletRequest)this.request)).isNull();
    }

    @Test
    public void loadTokenCookieIncorrectNameNull() {
        this.request.setCookies(new Cookie[]{new Cookie("other", "name")});
        Assertions.assertThat((Object)this.repository.loadToken((HttpServletRequest)this.request)).isNull();
    }

    @Test
    public void loadTokenCookieValueEmptyString() {
        this.request.setCookies(new Cookie[]{new Cookie("DSPACE-XSRF-COOKIE", "")});
        Assertions.assertThat((Object)this.repository.loadToken((HttpServletRequest)this.request)).isNull();
    }

    @Test
    public void loadToken() {
        CsrfToken generateToken = this.repository.generateToken((HttpServletRequest)this.request);
        this.request.setCookies(new Cookie[]{new Cookie("DSPACE-XSRF-COOKIE", generateToken.getToken())});
        CsrfToken loadToken = this.repository.loadToken((HttpServletRequest)this.request);
        Assertions.assertThat((Object)loadToken).isNotNull();
        Assertions.assertThat((String)loadToken.getHeaderName()).isEqualTo(generateToken.getHeaderName());
        Assertions.assertThat((String)loadToken.getParameterName()).isEqualTo(generateToken.getParameterName());
        Assertions.assertThat((String)loadToken.getToken()).isNotEmpty();
    }

    @Test
    public void loadTokenCustom() {
        String cookieName = "cookieName";
        String value = "value";
        String headerName = "headerName";
        String parameterName = "paramName";
        this.repository.setHeaderName(headerName);
        this.repository.setParameterName(parameterName);
        this.repository.setCookieName(cookieName);
        this.request.setCookies(new Cookie[]{new Cookie(cookieName, value)});
        CsrfToken loadToken = this.repository.loadToken((HttpServletRequest)this.request);
        Assertions.assertThat((Object)loadToken).isNotNull();
        Assertions.assertThat((String)loadToken.getHeaderName()).isEqualTo(headerName);
        Assertions.assertThat((String)loadToken.getParameterName()).isEqualTo(parameterName);
        Assertions.assertThat((String)loadToken.getToken()).isEqualTo(value);
    }

    @Test(expected=IllegalArgumentException.class)
    public void setCookieNameNullIllegalArgumentException() {
        this.repository.setCookieName(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void setParameterNameNullIllegalArgumentException() {
        this.repository.setParameterName(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void setHeaderNameNullIllegalArgumentException() {
        this.repository.setHeaderName(null);
    }
}

