/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.sword;

import org.dspace.app.rest.test.AbstractWebClientIntegrationTest;
import org.dspace.services.ConfigurationService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.TestPropertySource;

@TestPropertySource(properties={"sword-server.enabled = true"})
public class Swordv1IT
extends AbstractWebClientIntegrationTest {
    @Autowired
    private ConfigurationService configurationService;
    private final String SERVICE_DOC_PATH = "/sword/servicedocument";
    private final String DEPOSIT_PATH = "/sword/deposit";
    private final String MEDIA_LINK_PATH = "/sword/media-link";

    @Before
    public void onlyRunIfConfigExists() {
        try {
            Class.forName("org.dspace.app.configuration.SWORDWebConfig");
        }
        catch (ClassNotFoundException ce) {
            Assume.assumeNoException((Throwable)ce);
        }
        this.configurationService.setProperty("sword-server.servicedocument.url", (Object)this.getURL("/sword/servicedocument"));
        this.configurationService.setProperty("sword-server.deposit.url", (Object)this.getURL("/sword/deposit"));
        this.configurationService.setProperty("sword-server.media-link.url", (Object)this.getURL("/sword/media-link"));
    }

    @Test
    public void serviceDocumentUnauthorizedTest() throws Exception {
        ResponseEntity<String> response = this.getResponseAsString("/sword/servicedocument");
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)HttpStatus.UNAUTHORIZED));
    }

    @Test
    public void serviceDocumentTest() throws Exception {
        ResponseEntity<String> response = this.getResponseAsString("/sword/servicedocument", this.admin.getEmail(), this.password);
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)HttpStatus.OK));
        Assert.assertThat((Object)response.getHeaders().getContentType().toString(), (Matcher)CoreMatchers.equalTo((Object)"application/atomsvc+xml;charset=UTF-8"));
        Assert.assertThat((Object)((String)response.getBody()), (Matcher)CoreMatchers.containsString((String)"<sword:version>1.3</sword:version>"));
    }

    @Test
    public void depositUnauthorizedTest() throws Exception {
        ResponseEntity<String> response = this.postResponseAsString("/sword/deposit", null, null, null);
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)HttpStatus.UNAUTHORIZED));
    }

    @Test
    @Ignore
    public void depositTest() throws Exception {
    }

    @Test
    public void mediaLinkUnauthorizedTest() throws Exception {
        ResponseEntity<String> response = this.getResponseAsString("/sword/media-link");
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)HttpStatus.UNAUTHORIZED));
    }

    @Test
    @Ignore
    public void mediaLinkTest() throws Exception {
    }
}

