/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.model.CommunityRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.model.SiteRest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="canViewUsageStatistics", description="It can be used to verify if statistics can be viewed")
public class CanViewUsageStatisticsFeature
implements AuthorizationFeature {
    public static final String NAME = "canViewUsageStatistics";
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private Utils utils;

    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        if (object instanceof SiteRest || object instanceof CommunityRest || object instanceof CollectionRest || object instanceof ItemRest) {
            if (this.configurationService.getBooleanProperty("usage-statistics.authorization.admin.usage", true)) {
                return this.authorizeService.isAdmin(context, (DSpaceObject)this.utils.getDSpaceAPIObjectFromRest(context, object));
            }
            return this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)this.utils.getDSpaceAPIObjectFromRest(context, object), 0);
        }
        return false;
    }

    public String[] getSupportedTypes() {
        return new String[]{"core.site", "core.community", "core.collection", "core.item"};
    }
}

