/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.text.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.converter.DSpaceConverter;
import org.dspace.app.rest.model.AccessConditionOptionRest;
import org.dspace.app.rest.model.SubmissionAccessOptionRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.submit.model.AccessConditionConfiguration;
import org.dspace.submit.model.AccessConditionOption;
import org.dspace.util.DateMathParser;
import org.springframework.stereotype.Component;

@Component
public class SubmissionAccessOptionConverter
implements DSpaceConverter<AccessConditionConfiguration, SubmissionAccessOptionRest> {
    DateMathParser dateMathParser = new DateMathParser();

    public SubmissionAccessOptionRest convert(AccessConditionConfiguration config, Projection projection) {
        SubmissionAccessOptionRest model = new SubmissionAccessOptionRest();
        model.setId(config.getName());
        model.setCanChangeDiscoverable(config.getCanChangeDiscoverable());
        model.setProjection(projection);
        for (AccessConditionOption option : config.getOptions()) {
            AccessConditionOptionRest optionRest = new AccessConditionOptionRest();
            optionRest.setHasStartDate(option.getHasStartDate());
            optionRest.setHasEndDate(option.getHasEndDate());
            if (StringUtils.isNotBlank((CharSequence)option.getStartDateLimit())) {
                try {
                    optionRest.setMaxStartDate(this.dateMathParser.parseMath(option.getStartDateLimit()));
                }
                catch (ParseException e) {
                    throw new IllegalStateException("Wrong start date limit configuration for the access condition option named  " + option.getName());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)option.getEndDateLimit())) {
                try {
                    optionRest.setMaxEndDate(this.dateMathParser.parseMath(option.getEndDateLimit()));
                }
                catch (ParseException e) {
                    throw new IllegalStateException("Wrong end date limit configuration for the access condition option named  " + option.getName());
                }
            }
            optionRest.setName(option.getName());
            model.getAccessConditionOptions().add(optionRest);
        }
        return model;
    }

    public Class<AccessConditionConfiguration> getModelClass() {
        return AccessConditionConfiguration.class;
    }
}

