/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.login.impl;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.login.PostLoggedInAction;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataFieldName;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.service.EPersonService;
import org.dspace.profile.service.ResearcherProfileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class ResearcherProfileAutomaticClaim
implements PostLoggedInAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResearcherProfileAutomaticClaim.class);
    @Autowired
    private ResearcherProfileService researcherProfileService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private EPersonService ePersonService;
    private final String ePersonField;
    private final String profileField;

    public ResearcherProfileAutomaticClaim(String ePersonField, String profileField) {
        Assert.notNull((Object)ePersonField, (String)"An eperson field is required to perform automatic claim");
        Assert.notNull((Object)profileField, (String)"An profile field is required to perform automatic claim");
        this.ePersonField = ePersonField;
        this.profileField = profileField;
    }

    public void loggedIn(Context context) {
        if (StringUtils.isBlank((CharSequence)this.researcherProfileService.getProfileType())) {
            return;
        }
        EPerson currentUser = context.getCurrentUser();
        if (currentUser == null) {
            return;
        }
        try {
            this.claimProfile(context, currentUser);
        }
        catch (SQLException | AuthorizeException e) {
            LOGGER.error("An error occurs during the profile claim by email", e);
        }
    }

    private void claimProfile(Context context, EPerson currentUser) throws SQLException, AuthorizeException {
        UUID id = currentUser.getID();
        String fullName = currentUser.getFullName();
        if (this.currentUserHasAlreadyResearcherProfile(context)) {
            return;
        }
        Item item = this.findClaimableProfile(context, currentUser);
        if (item != null) {
            this.itemService.addMetadata(context, (DSpaceObject)item, "dspace", "object", "owner", null, fullName, id.toString(), 600);
        }
    }

    private boolean currentUserHasAlreadyResearcherProfile(Context context) throws SQLException, AuthorizeException {
        return this.researcherProfileService.findById(context, context.getCurrentUser().getID()) != null;
    }

    private Item findClaimableProfile(Context context, EPerson currentUser) throws SQLException, AuthorizeException {
        String value = this.getValueToSearchFor(context, currentUser);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        List items = IteratorUtils.toList((Iterator)this.itemService.findArchivedByMetadataField(context, this.profileField, value)).stream().filter(arg_0 -> this.hasNotOwner(arg_0)).filter(arg_0 -> ((ResearcherProfileService)this.researcherProfileService).hasProfileType(arg_0)).collect(Collectors.toList());
        return items.size() == 1 ? (Item)items.get(0) : null;
    }

    private String getValueToSearchFor(Context context, EPerson currentUser) {
        if ("email".equals(this.ePersonField)) {
            return currentUser.getEmail();
        }
        return this.ePersonService.getMetadataFirstValue((DSpaceObject)currentUser, new MetadataFieldName(this.ePersonField), "*");
    }

    private boolean hasNotOwner(Item item) {
        return CollectionUtils.isEmpty((Collection)this.itemService.getMetadata((DSpaceObject)item, "dspace", "object", "owner", "*"));
    }
}

