/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.model.hateoas;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.model.hateoas.EmbeddedPageHeader;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;

public abstract class HALResource<T>
extends EntityModel<T> {
    protected final Map<String, Object> embedded = new HashMap();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonUnwrapped
    private EmbeddedPageHeader pageHeader;

    public HALResource(T content) {
        super(content);
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="_embedded")
    public Map<String, Object> getEmbeddedResources() {
        return this.embedded;
    }

    public void embedResource(String rel, Object object) {
        this.embedded.put(rel, object);
    }

    public void setPageHeader(EmbeddedPageHeader page) {
        this.pageHeader = page;
    }

    public EntityModel<T> add(Link link) {
        List list;
        if (!this.hasLink(link.getRel())) {
            return (EntityModel)super.add(link);
        }
        String name = link.getName();
        if (StringUtils.isNotBlank((CharSequence)name) && !(list = this.getLinks(link.getRel())).stream().anyMatch(l -> StringUtils.equalsIgnoreCase((CharSequence)l.getName(), (CharSequence)name))) {
            super.add(link);
        }
        return this;
    }
}

