/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.model.VersionRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.versioning.Version;
import org.dspace.versioning.service.VersioningService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.item.version")
public class ItemVersionLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    private VersioningService versioningService;
    @Autowired
    private ItemService itemService;

    @PreAuthorize(value="@versioningSecurity.isEnableVersioning() && (hasPermission(@extractorOf.getVersionIdByItemUUID(#request, #itemUuid), 'VERSION', 'READ') || (@extractorOf.getVersionIdByItemUUID(#request, #itemUuid) == null && hasPermission(#itemUuid,'ITEM','READ')))")
    public VersionRest getItemVersion(@Nullable HttpServletRequest request, UUID itemUuid, @Nullable Pageable optionalPageable, Projection projection) throws SQLException {
        Context context = this.obtainContext();
        Item item = (Item)this.itemService.find(context, itemUuid);
        if (item == null) {
            throw new ResourceNotFoundException("The Item for uuid: " + itemUuid + " couldn't be found");
        }
        Version version = this.versioningService.getVersion(context, item);
        if (version == null) {
            return null;
        }
        return (VersionRest)this.converter.toRest((Object)version, projection);
    }
}

