/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.model.OrcidHistoryRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.repository.handler.service.UriListHandlerService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.orcid.OrcidHistory;
import org.dspace.orcid.OrcidQueue;
import org.dspace.orcid.service.OrcidHistoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="eperson.orcidhistory")
@ConditionalOnProperty(value={"orcid.synchronization-enabled"})
public class OrcidHistoryRestRepository
extends DSpaceRestRepository<OrcidHistoryRest, Integer> {
    @Autowired
    private OrcidHistoryService orcidHistoryService;
    @Autowired
    private UriListHandlerService uriListHandlerService;

    public Page<OrcidHistoryRest> findAll(Context context, Pageable pageable) {
        throw new RepositoryMethodNotImplementedException("No implementation found; Method not allowed!", "");
    }

    @PreAuthorize(value="hasPermission(#id, 'ORCID_HISTORY', 'READ')")
    public OrcidHistoryRest findOne(Context context, Integer id) {
        OrcidHistory orcidHistory = null;
        try {
            orcidHistory = this.orcidHistoryService.find(context, id.intValue());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (orcidHistory == null) {
            return null;
        }
        return (OrcidHistoryRest)this.converter.toRest((Object)orcidHistory, this.utils.obtainProjection());
    }

    @PreAuthorize(value="hasPermission(#list, 'ORCID_HISTORY', 'ADD')")
    protected OrcidHistoryRest createAndReturn(Context context, List<String> list) throws AuthorizeException, SQLException, RepositoryMethodNotImplementedException {
        OrcidHistory orcidHistory = null;
        HttpServletRequest request = this.getRequestService().getCurrentRequest().getHttpServletRequest();
        OrcidQueue orcidQueue = (OrcidQueue)this.uriListHandlerService.handle(context, request, list, OrcidQueue.class);
        if (orcidQueue == null) {
            throw new IllegalArgumentException("No ORCID Queue record found, the uri-list does not contait a resource");
        }
        boolean forceAddition = Boolean.parseBoolean(request.getParameter("forceAddition"));
        orcidHistory = this.orcidHistoryService.synchronizeWithOrcid(context, orcidQueue, forceAddition);
        return orcidHistory != null ? (OrcidHistoryRest)this.converter.toRest((Object)orcidHistory, this.utils.obtainProjection()) : null;
    }

    public Class<OrcidHistoryRest> getDomainClass() {
        return OrcidHistoryRest.class;
    }
}

