/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.versioning.Version;
import org.dspace.versioning.service.VersioningService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.stereotype.Component;

@Component(value="versioning.version.item")
public class VersionItemLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    private VersioningService versioningService;

    public ItemRest getVersionItem(@Nullable HttpServletRequest request, Integer versionId, @Nullable Pageable optionalPageable, Projection projection) throws SQLException {
        Context context = this.obtainContext();
        Version version = this.versioningService.getVersion(context, versionId.intValue());
        if (version == null) {
            throw new ResourceNotFoundException("The version with ID: " + versionId + " couldn't be found");
        }
        Item item = version.getItem();
        if (item == null) {
            return null;
        }
        return (ItemRest)this.converter.toRest((Object)item, projection);
    }
}

