/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation;

import java.sql.SQLException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.core.Context;
import org.dspace.orcid.client.OrcidClient;
import org.dspace.orcid.exception.OrcidClientException;
import org.dspace.orcid.model.OrcidTokenResponseDTO;
import org.dspace.orcid.service.OrcidSynchronizationService;
import org.dspace.profile.ResearcherProfile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ResearcherProfileAddOrcidOperation
extends PatchOperation<ResearcherProfile> {
    private static final String OPERATION_ORCID = "/orcid";
    @Autowired
    private OrcidClient orcidClient;
    @Autowired
    private OrcidSynchronizationService orcidSynchronizationService;

    public ResearcherProfile perform(Context context, ResearcherProfile profile, Operation operation) throws SQLException {
        Object code = operation.getValue();
        if (code == null | !(code instanceof String)) {
            throw new UnprocessableEntityException("The /code value must be a string");
        }
        OrcidTokenResponseDTO accessToken = this.getAccessToken((String)code);
        this.orcidSynchronizationService.linkProfile(context, profile.getItem(), accessToken);
        return profile;
    }

    private OrcidTokenResponseDTO getAccessToken(String code) {
        try {
            return this.orcidClient.getAccessToken(code);
        }
        catch (OrcidClientException ex) {
            if (ex.isInvalidGrantException()) {
                throw new UnprocessableEntityException("The provided ORCID authorization code is not valid", (Throwable)ex);
            }
            throw ex;
        }
    }

    public boolean supports(Object objectToMatch, Operation operation) {
        return objectToMatch instanceof ResearcherProfile && operation.getOp().trim().equalsIgnoreCase("add") && operation.getPath().trim().toLowerCase().startsWith(OPERATION_ORCID);
    }

    public void setOrcidClient(OrcidClient orcidClient) {
        this.orcidClient = orcidClient;
    }
}

