/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.authenticate.service.AuthenticationService;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

public class AnonymousAdditionalAuthorizationFilter
extends BasicAuthenticationFilter {
    private static final Logger log = LogManager.getLogger();
    private final AuthenticationService authenticationService;

    public AnonymousAdditionalAuthorizationFilter(AuthenticationManager authenticationManager, AuthenticationService authenticationService) {
        super(authenticationManager);
        this.authenticationService = authenticationService;
    }

    protected void doFilterInternal(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        Context context = ContextUtil.obtainContext((HttpServletRequest)req);
        try {
            List groups = this.authenticationService.getSpecialGroups(context, req);
            for (Group group : groups) {
                context.setSpecialGroup(group.getID());
            }
        }
        catch (SQLException e) {
            log.error("Something went wrong trying to fetch groups in IPAuthenticationFilter", (Throwable)e);
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }
}

