/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.factory.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.AccessConditionDTO;
import org.dspace.app.rest.model.patch.JsonValueEvaluator;
import org.dspace.app.rest.model.patch.LateObjectEvaluator;
import org.dspace.app.rest.submit.factory.impl.ReplacePatchOperation;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.submit.model.AccessConditionConfiguration;
import org.dspace.submit.model.AccessConditionConfigurationService;
import org.dspace.submit.model.AccessConditionOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AccessConditionReplacePatchOperation
extends ReplacePatchOperation<AccessConditionDTO> {
    private static final Logger log = LoggerFactory.getLogger(AccessConditionReplacePatchOperation.class);
    @Autowired
    private ResourcePolicyService resourcePolicyService;
    @Autowired
    private AccessConditionConfigurationService accessConditionConfigurationService;

    void replace(Context context, HttpServletRequest currentRequest, InProgressSubmission source, String path, Object value) throws Exception {
        String stepId = (String)currentRequest.getAttribute("accessConditionSectionId");
        AccessConditionConfiguration configuration = this.accessConditionConfigurationService.getAccessConfigurationById(stepId);
        String[] absolutePath = this.getAbsolutePath(path).split("/");
        Item item = source.getItem();
        Integer idxToReplace = null;
        try {
            idxToReplace = Integer.parseInt(absolutePath[1]);
        }
        catch (NumberFormatException e) {
            throw new UnprocessableEntityException("The provided index format is not correct! Must be a number!");
        }
        List policies = this.resourcePolicyService.find(context, (DSpaceObject)item, ResourcePolicy.TYPE_CUSTOM);
        if (idxToReplace < 0 || idxToReplace >= policies.size()) {
            throw new UnprocessableEntityException("The provided index:" + idxToReplace + " is not supported, currently the are " + policies.size() + " access conditions");
        }
        if (absolutePath.length == 2) {
            AccessConditionDTO accessConditionDTO = (AccessConditionDTO)this.evaluateSingleObject((LateObjectEvaluator)value);
            if (Objects.nonNull(accessConditionDTO) && Objects.nonNull(this.getOption(configuration, accessConditionDTO))) {
                item.getResourcePolicies().remove(policies.get(idxToReplace));
                this.resourcePolicyService.delete(context, (Object)((ResourcePolicy)policies.get(idxToReplace)));
                AccessConditionOption option = this.getOption(configuration, accessConditionDTO);
                option.createResourcePolicy(context, (DSpaceObject)item, accessConditionDTO.getName(), null, accessConditionDTO.getStartDate(), accessConditionDTO.getEndDate());
            }
        } else if (absolutePath.length == 3) {
            String valueToReplace = this.getValue(value);
            String attributeReplace = absolutePath[2];
            ResourcePolicy rpToReplace = (ResourcePolicy)policies.get(idxToReplace);
            AccessConditionDTO accessConditionDTO = this.createDTO(rpToReplace, attributeReplace, valueToReplace);
            this.updatePolicy(context, valueToReplace, attributeReplace, rpToReplace);
            this.getOption(configuration, accessConditionDTO).updateResourcePolicy(context, rpToReplace);
        } else {
            throw new UnprocessableEntityException("The patch operation for path:" + path + " is not supported!");
        }
    }

    private AccessConditionOption getOption(AccessConditionConfiguration configuration, AccessConditionDTO accessConditionDTO) {
        for (AccessConditionOption option : configuration.getOptions()) {
            if (!option.getName().equals(accessConditionDTO.getName())) continue;
            return option;
        }
        return null;
    }

    private AccessConditionDTO createDTO(ResourcePolicy rpToReplace, String attributeReplace, String valueToReplare) throws ParseException {
        AccessConditionDTO accessCondition = new AccessConditionDTO();
        accessCondition.setName(rpToReplace.getRpName());
        accessCondition.setStartDate(rpToReplace.getStartDate());
        accessCondition.setEndDate(rpToReplace.getEndDate());
        switch (attributeReplace) {
            case "name": {
                accessCondition.setName(valueToReplare);
                return accessCondition;
            }
            case "startDate": {
                accessCondition.setStartDate(this.parseDate(valueToReplare));
                return accessCondition;
            }
            case "endDate": {
                accessCondition.setEndDate(this.parseDate(valueToReplare));
                return accessCondition;
            }
        }
        throw new UnprocessableEntityException("The provided attribute: " + attributeReplace + " is not supported");
    }

    private void updatePolicy(Context context, String valueToReplare, String attributeReplace, ResourcePolicy rpToReplace) throws SQLException, AuthorizeException {
        switch (attributeReplace) {
            case "name": {
                rpToReplace.setRpName(valueToReplare);
                break;
            }
            case "startDate": {
                rpToReplace.setStartDate(this.parseDate(valueToReplare));
                break;
            }
            case "endDate": {
                rpToReplace.setEndDate(this.parseDate(valueToReplare));
                break;
            }
            default: {
                throw new IllegalArgumentException("Attribute to replace is not valid:" + attributeReplace);
            }
        }
    }

    private Date parseDate(String date) {
        List<SimpleDateFormat> knownPatterns = Arrays.asList(new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("dd-MM-yyyy"), new SimpleDateFormat("yyyy/MM/dd"), new SimpleDateFormat("dd/MM/yyyy"));
        for (SimpleDateFormat pattern : knownPatterns) {
            try {
                return pattern.parse(date);
            }
            catch (ParseException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        throw new UnprocessableEntityException("Provided format of date:" + date + " is not supported!");
    }

    private String getValue(Object value) {
        JsonValueEvaluator jsonValue;
        if (value instanceof JsonValueEvaluator && (jsonValue = (JsonValueEvaluator)value).getValueNode().fields().hasNext()) {
            return ((JsonNode)((Map.Entry)jsonValue.getValueNode().fields().next()).getValue()).asText();
        }
        return "";
    }

    protected Class<AccessConditionDTO[]> getArrayClassForEvaluation() {
        return AccessConditionDTO[].class;
    }

    protected Class<AccessConditionDTO> getClassForEvaluation() {
        return AccessConditionDTO.class;
    }
}

