/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.utils;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.model.VocabularyEntryDetailsRest;
import org.dspace.app.rest.model.VocabularyEntryRest;
import org.dspace.app.rest.model.VocabularyRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.content.authority.Choice;
import org.dspace.content.authority.ChoiceAuthority;
import org.dspace.content.authority.service.ChoiceAuthorityService;
import org.dspace.core.Utils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class AuthorityUtils {
    public static final String PRESENTATION_TYPE_LOOKUP = "lookup";
    public static final String PRESENTATION_TYPE_AUTHORLOOKUP = "authorLookup";
    public static final String PRESENTATION_TYPE_SUGGEST = "suggest";
    public static final String RESERVED_KEYMAP_PARENT = "parent";
    @Autowired
    private ChoiceAuthorityService cas;
    @Lazy
    @Autowired
    private ConverterService converter;

    public boolean isChoice(String schema, String element, String qualifier) {
        return this.cas.isChoicesConfigured(Utils.standardize((String)schema, (String)element, (String)qualifier, (String)"_"), null);
    }

    public String getAuthorityName(String schema, String element, String qualifier) {
        return this.cas.getChoiceAuthorityName(schema, element, qualifier, null);
    }

    public boolean isClosed(String schema, String element, String qualifier) {
        return this.cas.isClosed(Utils.standardize((String)schema, (String)element, (String)qualifier, (String)"_"));
    }

    public String getPresentation(String schema, String element, String qualifier) {
        return this.cas.getPresentation(Utils.standardize((String)schema, (String)element, (String)qualifier, (String)"_"));
    }

    public VocabularyEntryDetailsRest convertEntryDetails(Choice choice, String authorityName, boolean isHierarchical, Projection projection) {
        if (choice == null) {
            return null;
        }
        VocabularyEntryDetailsRest entry = (VocabularyEntryDetailsRest)this.converter.toRest((Object)choice, projection);
        entry.setVocabularyName(authorityName);
        entry.setId((Serializable)((Object)(authorityName + ":" + (String)((Object)entry.getId()))));
        entry.setInHierarchicalVocabulary(isHierarchical);
        return entry;
    }

    public VocabularyEntryRest convertEntry(Choice choice, String authorityName, boolean storeAuthority, Projection projection) {
        if (choice == null) {
            return null;
        }
        VocabularyEntryRest entry = new VocabularyEntryRest();
        entry.setDisplay(choice.label);
        entry.setValue(choice.value);
        entry.setOtherInformation(choice.extras);
        if (storeAuthority) {
            entry.setAuthority(choice.authority);
        }
        if (StringUtils.isNotBlank((CharSequence)choice.authority)) {
            entry.setVocabularyEntryDetailsRest((VocabularyEntryDetailsRest)this.converter.toRest((Object)choice, projection));
        }
        return entry;
    }

    public VocabularyRest convertAuthority(ChoiceAuthority source, String authorityName, Projection projection) {
        VocabularyRest result = (VocabularyRest)this.converter.toRest((Object)source, projection);
        result.setName(authorityName);
        return result;
    }
}

