/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.utils;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.ThreadContext;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.filter.AbstractRequestLoggingFilter;

public class DSpaceAPIRequestLoggingFilter
extends AbstractRequestLoggingFilter {
    @Autowired
    private ConfigurationService configurationService;

    protected boolean shouldLog(HttpServletRequest request) {
        return true;
    }

    protected boolean isIncludePayload() {
        return this.configurationService.getBooleanProperty("logging.server.include-payload", false);
    }

    protected boolean isIncludeHeaders() {
        return this.configurationService.getBooleanProperty("logging.server.include-headers", false);
    }

    protected boolean isIncludeQueryString() {
        return this.configurationService.getBooleanProperty("logging.server.include-query-string", false);
    }

    protected boolean isIncludeClientInfo() {
        return this.configurationService.getBooleanProperty("logging.server.include-client-info", false);
    }

    protected int getMaxPayloadLength() {
        return this.configurationService.getIntProperty("logging.server.max-payload-length", 10000);
    }

    protected void beforeRequest(HttpServletRequest request, String message) {
        ThreadContext.put((String)"requestID", (String)UUID.randomUUID().toString());
        String clientID = request.getHeader("x-correlation-id");
        if (StringUtils.isBlank((CharSequence)clientID)) {
            clientID = "unknown";
        }
        ThreadContext.put((String)"correlationID", (String)clientID);
        String referrer = request.getHeader("x-referrer");
        if (StringUtils.isBlank((CharSequence)referrer) && StringUtils.isBlank((CharSequence)(referrer = request.getHeader("referer")))) {
            referrer = "unknown";
        }
        this.logger.info((Object)(message + " originated from " + referrer));
    }

    protected void afterRequest(HttpServletRequest request, String message) {
        if (this.isAfterRequestLoggingEnabled()) {
            this.logger.info((Object)message);
        }
        ThreadContext.clearAll();
    }

    private boolean isAfterRequestLoggingEnabled() {
        return this.configurationService.getBooleanProperty("logging.server.include-after-request");
    }
}

