/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.ScopeResolver;
import org.dspace.app.util.SyndicationFeed;
import org.dspace.app.util.factory.UtilServiceFactory;
import org.dspace.app.util.service.OpenSearchService;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.core.Utils;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoveryConfigurationService;
import org.dspace.discovery.configuration.DiscoverySearchFilter;
import org.dspace.discovery.configuration.DiscoverySortConfiguration;
import org.dspace.discovery.configuration.DiscoverySortFieldConfiguration;
import org.dspace.discovery.indexobject.IndexableItem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.w3c.dom.Document;

@Controller
@RequestMapping(value={"/opensearch"})
public class OpenSearchController {
    private static final Logger log = LogManager.getLogger();
    private static final String errorpath = "/error";
    private List<String> searchIndices = null;
    private CommunityService communityService;
    private CollectionService collectionService;
    private AuthorizeService authorizeService;
    private OpenSearchService openSearchService;
    @Autowired
    private SearchService searchService;
    @Autowired
    private DiscoveryConfigurationService searchConfigurationService;
    private Context context;
    @Autowired
    private ScopeResolver scopeResolver;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GetMapping(value={"/search"})
    public void search(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="query", required=false) String query, @RequestParam(name="start", required=false) Integer start, @RequestParam(name="rpp", required=false) Integer count, @RequestParam(name="format", required=false) String format, @RequestParam(name="sort", required=false) String sort, @RequestParam(name="sort_direction", required=false) String sortDirection, @RequestParam(name="scope", required=false) String dsoObject, Model model) throws IOException, ServletException {
        this.context = ContextUtil.obtainContext(request);
        if (start == null) {
            start = 0;
        }
        if (count == null) {
            count = -1;
        }
        if (this.openSearchService == null) {
            this.openSearchService = UtilServiceFactory.getInstance().getOpenSearchService();
        }
        if (this.openSearchService.isEnabled()) {
            DiscoveryConfiguration discoveryConfiguration;
            this.init();
            if (format == null || "".equals(format)) {
                format = "atom";
            }
            log.debug("Searching for " + query + " in format " + format);
            if (!this.openSearchService.getFormats().contains(format)) {
                String err = "Format " + Utils.addEntities((String)format) + " is not supported.";
                response.setContentType("text/html");
                response.setContentLength(err.length());
                response.getWriter().write(err);
            }
            IndexableObject container = null;
            DiscoverQuery queryArgs = new DiscoverQuery();
            if (query == null) {
                query = "";
            } else {
                queryArgs.setQuery(query);
            }
            queryArgs.setStart(start.intValue());
            queryArgs.setMaxResults(count.intValue());
            queryArgs.setDSpaceObjectFilter(IndexableItem.TYPE);
            if (sort != null) {
                DiscoverySortConfiguration searchSortConfiguration;
                discoveryConfiguration = this.searchConfigurationService.getDiscoveryConfiguration("");
                if (discoveryConfiguration != null && (searchSortConfiguration = discoveryConfiguration.getSearchSortConfiguration()) != null) {
                    DiscoverySortFieldConfiguration sortFieldConfiguration = searchSortConfiguration.getSortFieldConfiguration(sort);
                    if (sortFieldConfiguration == null) throw new IllegalArgumentException(sort + " is not a valid sort field");
                    String sortField = this.searchService.toSortFieldIndex(sortFieldConfiguration.getMetadataField(), sortFieldConfiguration.getType());
                    if (sortDirection != null && sortDirection.equals("DESC")) {
                        queryArgs.setSortField(sortField, DiscoverQuery.SORT_ORDER.desc);
                    } else {
                        queryArgs.setSortField(sortField, DiscoverQuery.SORT_ORDER.asc);
                    }
                }
            } else {
                queryArgs.setSortField("dc.date.accessioned_dt", DiscoverQuery.SORT_ORDER.desc);
            }
            if (dsoObject != null) {
                container = this.scopeResolver.resolveScope(this.context, dsoObject);
                discoveryConfiguration = this.searchConfigurationService.getDiscoveryConfiguration(this.context, container);
                queryArgs.setDiscoveryConfigurationName(discoveryConfiguration.getId());
                queryArgs.addFilterQueries(discoveryConfiguration.getDefaultFilterQueries().toArray(new String[discoveryConfiguration.getDefaultFilterQueries().size()]));
            }
            DiscoverResult qResults = null;
            try {
                qResults = SearchUtils.getSearchService().search(this.context, container, queryArgs);
            }
            catch (SearchServiceException e) {
                log.error(LogHelper.getHeader((Context)this.context, (String)"opensearch", (String)("query=" + queryArgs.getQuery() + ",error=" + e.getMessage())), (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
            }
            log.info("opensearch done, query=\"" + query + "\",results=" + qResults.getTotalSearchResults());
            Map<String, String> labelMap = this.getLabels(request);
            List dsoResults = qResults.getIndexableObjects();
            Document resultsDoc = this.openSearchService.getResultsDoc(this.context, format, query, (int)qResults.getTotalSearchResults(), qResults.getStart(), qResults.getMaxResults(), container, dsoResults, labelMap);
            try {
                Transformer xf = TransformerFactory.newInstance().newTransformer();
                response.setContentType(this.openSearchService.getContentType(format));
                xf.transform(new DOMSource(resultsDoc), new StreamResult(response.getWriter()));
                return;
            }
            catch (TransformerException e) {
                log.error((Object)e);
                throw new ServletException(e.toString());
            }
        }
        log.debug("OpenSearch Service is disabled");
        String err = "OpenSearch Service is disabled";
        response.setStatus(404);
        response.setContentType("text/html");
        response.setContentLength(err.length());
        response.getWriter().write(err);
    }

    @GetMapping(value={"/service"})
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.debug("Show OpenSearch Service document");
        if (this.openSearchService == null) {
            this.openSearchService = UtilServiceFactory.getInstance().getOpenSearchService();
        }
        if (this.openSearchService.isEnabled()) {
            String svcDescrip = this.openSearchService.getDescription(null);
            log.debug("opensearchdescription is " + svcDescrip);
            response.setContentType(this.openSearchService.getContentType("opensearchdescription"));
            response.setContentLength(svcDescrip.length());
            response.getWriter().write(svcDescrip);
        } else {
            log.debug("OpenSearch Service is disabled");
            String err = "OpenSearch Service is disabled";
            response.setStatus(404);
            response.setContentType("text/html");
            response.setContentLength(err.length());
            response.getWriter().write(err);
        }
    }

    private void init() {
        if (this.searchIndices == null) {
            this.searchIndices = new ArrayList<String>();
            DiscoveryConfiguration discoveryConfiguration = SearchUtils.getDiscoveryConfiguration();
            this.searchIndices.add("any");
            for (DiscoverySearchFilter sFilter : discoveryConfiguration.getSearchFilters()) {
                this.searchIndices.add(sFilter.getIndexFieldName());
            }
        }
        this.communityService = ContentServiceFactory.getInstance().getCommunityService();
        this.collectionService = ContentServiceFactory.getInstance().getCollectionService();
        this.authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    }

    public void setOpenSearchService(OpenSearchService oSS) {
        this.openSearchService = oSS;
    }

    private Map<String, String> getLabels(HttpServletRequest request) {
        HashMap<String, String> labelMap = new HashMap<String, String>();
        labelMap.put("notitle", "notitle");
        labelMap.put("logo.title", "logo.title");
        labelMap.put("general-feed.description", "general-feed.description");
        labelMap.put("ui.type", "jspui");
        for (String selector : SyndicationFeed.getDescriptionSelectors()) {
            labelMap.put("metadata." + selector, selector);
        }
        return labelMap;
    }
}

