/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.model.SubmissionDefinitionRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.util.SubmissionConfig;
import org.dspace.app.util.SubmissionConfigReaderException;
import org.dspace.content.Collection;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.dspace.submit.factory.SubmissionServiceFactory;
import org.dspace.submit.service.SubmissionConfigService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="config.submissiondefinition")
public class SubmissionDefinitionRestRepository
extends DSpaceRestRepository<SubmissionDefinitionRest, String> {
    private SubmissionConfigService submissionConfigService;
    private CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();

    public SubmissionDefinitionRestRepository() throws SubmissionConfigReaderException {
        this.submissionConfigService = SubmissionServiceFactory.getInstance().getSubmissionConfigService();
    }

    @Override
    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public SubmissionDefinitionRest findOne(Context context, String submitName) {
        SubmissionConfig subConfig = this.submissionConfigService.getSubmissionConfigByName(submitName);
        if (subConfig == null) {
            return null;
        }
        return (SubmissionDefinitionRest)this.converter.toRest(subConfig, this.utils.obtainProjection());
    }

    @Override
    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<SubmissionDefinitionRest> findAll(Context context, Pageable pageable) {
        int total = this.submissionConfigService.countSubmissionConfigs();
        List subConfs = this.submissionConfigService.getAllSubmissionConfigs(Integer.valueOf(pageable.getPageSize()), Integer.valueOf(Math.toIntExact(pageable.getOffset())));
        return this.converter.toRestPage(subConfs, pageable, total, this.utils.obtainProjection());
    }

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    @SearchRestMethod(name="findByCollection")
    public SubmissionDefinitionRest findByCollection(@Parameter(value="uuid", required=true) UUID collectionUuid) throws SQLException {
        Collection col = (Collection)this.collectionService.find(this.obtainContext(), collectionUuid);
        if (col == null) {
            return null;
        }
        SubmissionDefinitionRest def = (SubmissionDefinitionRest)this.converter.toRest(this.submissionConfigService.getSubmissionConfigByCollection(col.getHandle()), this.utils.obtainProjection());
        return def;
    }

    @Override
    public Class<SubmissionDefinitionRest> getDomainClass() {
        return SubmissionDefinitionRest.class;
    }
}

