/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.model.AccessConditionOptionRest;
import org.dspace.app.rest.model.SubmissionUploadRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.repository.SubmissionFormRestRepository;
import org.dspace.core.Context;
import org.dspace.submit.model.AccessConditionOption;
import org.dspace.submit.model.UploadConfiguration;
import org.dspace.submit.model.UploadConfigurationService;
import org.dspace.util.DateMathParser;
import org.dspace.util.TimeHelpers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="config.submissionupload")
public class SubmissionUploadRestRepository
extends DSpaceRestRepository<SubmissionUploadRest, String> {
    private static final Logger log = LogManager.getLogger(SubmissionUploadRestRepository.class);
    @Autowired
    private SubmissionFormRestRepository submissionFormRestRepository;
    @Autowired
    private UploadConfigurationService uploadConfigurationService;

    @Override
    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public SubmissionUploadRest findOne(Context context, String submitName) {
        UploadConfiguration config = (UploadConfiguration)this.uploadConfigurationService.getMap().get(submitName);
        try {
            return this.convert(context, config, this.utils.obtainProjection());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<SubmissionUploadRest> findAll(Context context, Pageable pageable) {
        Collection uploadConfigs = this.uploadConfigurationService.getMap().values();
        Projection projection = this.utils.obtainProjection();
        ArrayList<SubmissionUploadRest> results = new ArrayList<SubmissionUploadRest>();
        ArrayList<String> configNames = new ArrayList<String>();
        for (UploadConfiguration uploadConfig : uploadConfigs) {
            if (configNames.contains(uploadConfig.getName())) continue;
            configNames.add(uploadConfig.getName());
            try {
                results.add(this.convert(context, uploadConfig, projection));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.utils.getPage(results, pageable);
    }

    @Override
    public Class<SubmissionUploadRest> getDomainClass() {
        return SubmissionUploadRest.class;
    }

    private SubmissionUploadRest convert(Context context, UploadConfiguration config, Projection projection) {
        SubmissionUploadRest result = new SubmissionUploadRest();
        result.setProjection(projection);
        DateMathParser dateMathParser = new DateMathParser();
        for (AccessConditionOption option : config.getOptions()) {
            Date requested;
            AccessConditionOptionRest optionRest = new AccessConditionOptionRest();
            optionRest.setHasStartDate(option.getHasStartDate());
            optionRest.setHasEndDate(option.getHasEndDate());
            if (StringUtils.isNotBlank((CharSequence)option.getStartDateLimit())) {
                try {
                    requested = dateMathParser.parseMath(option.getStartDateLimit());
                    optionRest.setMaxStartDate(TimeHelpers.toMidnightUTC((Date)requested));
                }
                catch (ParseException e) {
                    throw new IllegalStateException("Wrong start date limit configuration for the access condition option named  " + option.getName());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)option.getEndDateLimit())) {
                try {
                    requested = dateMathParser.parseMath(option.getEndDateLimit());
                    optionRest.setMaxEndDate(TimeHelpers.toMidnightUTC((Date)requested));
                }
                catch (ParseException e) {
                    throw new IllegalStateException("Wrong end date limit configuration for the access condition option named  " + option.getName());
                }
            }
            optionRest.setName(option.getName());
            result.getAccessConditionOptions().add(optionRest);
        }
        result.setMetadata(this.submissionFormRestRepository.findOne(context, config.getMetadata()));
        result.setMaxSize(config.getMaxSize());
        result.setRequired(config.isRequired());
        result.setName(config.getName());
        return result;
    }
}

