/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.model.AInprogressSubmissionRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.service.VersionHistoryService;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.WorkflowItemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="versioning.versionhistory.draftVersion")
public class VersionHistoryDraftVersionLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    private VersionHistoryService versionHistoryService;
    @Autowired
    private WorkspaceItemService workspaceItemService;
    @Autowired(required=true)
    private WorkflowItemService workflowItemService;

    @PreAuthorize(value="@versioningSecurity.isEnableVersioning() && hasPermission(@extractorOf.getAInprogressSubmissionID(#request, #versionHistoryId), @extractorOf.getAInprogressSubmissionTarget(#request, #versionHistoryId), 'READ')")
    public AInprogressSubmissionRest getDraftVersion(@Nullable HttpServletRequest request, Integer versionHistoryId, @Nullable Pageable optionalPageable, Projection projection) throws SQLException {
        Context context = this.obtainContext();
        if (Objects.isNull(versionHistoryId) || versionHistoryId < 0) {
            throw new DSpaceBadRequestException("Provided id is not correct!");
        }
        VersionHistory versionHistory = (VersionHistory)this.versionHistoryService.find(context, versionHistoryId.intValue());
        if (Objects.isNull(versionHistory)) {
            throw new ResourceNotFoundException("No such version found");
        }
        Version oldestVersion = this.versionHistoryService.getLatestVersion(context, versionHistory);
        if (Objects.nonNull(oldestVersion) && Objects.nonNull(oldestVersion.getItem())) {
            WorkflowItem workflowItem = this.workflowItemService.findByItem(context, oldestVersion.getItem());
            WorkspaceItem workspaceItem = this.workspaceItemService.findByItem(context, oldestVersion.getItem());
            if (Objects.nonNull(workflowItem)) {
                return (AInprogressSubmissionRest)this.converter.toRest(workflowItem, projection);
            }
            if (Objects.nonNull(workspaceItem)) {
                return (AInprogressSubmissionRest)this.converter.toRest(workspaceItem, projection);
            }
        }
        return null;
    }
}

