/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.converter.WorkspaceItemConverter;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.ErrorRest;
import org.dspace.app.rest.model.WorkspaceItemRest;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.repository.ReloadableEntityObjectRepository;
import org.dspace.app.rest.repository.handler.service.UriListHandlerService;
import org.dspace.app.rest.submit.SubmissionService;
import org.dspace.app.rest.submit.UploadableStep;
import org.dspace.app.rest.utils.Utils;
import org.dspace.app.util.SubmissionConfig;
import org.dspace.app.util.SubmissionConfigReaderException;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.EPersonServiceImpl;
import org.dspace.event.Event;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.exception.FileMultipleOccurencesException;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.service.ImportService;
import org.dspace.services.ConfigurationService;
import org.dspace.submit.factory.SubmissionServiceFactory;
import org.dspace.submit.service.SubmissionConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component(value="submission.workspaceitem")
public class WorkspaceItemRestRepository
extends DSpaceRestRepository<WorkspaceItemRest, Integer>
implements ReloadableEntityObjectRepository<WorkspaceItem, Integer> {
    public static final String OPERATION_PATH_SECTIONS = "sections";
    private static final Logger log = LogManager.getLogger(WorkspaceItemRestRepository.class);
    @Autowired
    WorkspaceItemService wis;
    @Autowired
    ItemService itemService;
    @Autowired
    BitstreamService bitstreamService;
    @Autowired
    BitstreamFormatService bitstreamFormatService;
    @Autowired
    ConfigurationService configurationService;
    @Autowired
    WorkspaceItemConverter workspaceItemConverter;
    @Autowired
    SubmissionService submissionService;
    @Autowired
    EPersonServiceImpl epersonService;
    @Autowired
    CollectionService collectionService;
    @Autowired
    AuthorizeService authorizeService;
    @Autowired
    ImportService importService;
    @Autowired
    private UriListHandlerService uriListHandlerService;
    private SubmissionConfigService submissionConfigService = SubmissionServiceFactory.getInstance().getSubmissionConfigService();

    @Override
    @PreAuthorize(value="hasPermission(#id, 'WORKSPACEITEM', 'READ')")
    public WorkspaceItemRest findOne(Context context, Integer id) {
        WorkspaceItem witem = null;
        try {
            witem = this.wis.find(context, id.intValue());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (witem == null) {
            return null;
        }
        return (WorkspaceItemRest)this.converter.toRest(witem, this.utils.obtainProjection());
    }

    @Override
    @PreAuthorize(value="hasAuthority('ADMIN')")
    public Page<WorkspaceItemRest> findAll(Context context, Pageable pageable) {
        try {
            long total = this.wis.countTotal(context);
            List witems = this.wis.findAll(context, Integer.valueOf(pageable.getPageSize()), Integer.valueOf(Math.toIntExact(pageable.getOffset())));
            return this.converter.toRestPage(witems, pageable, total, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @PreAuthorize(value="hasPermission(#submitterID, 'EPERSON', 'READ')")
    @SearchRestMethod(name="findBySubmitter")
    public Page<WorkspaceItemRest> findBySubmitter(@Parameter(value="uuid", required=true) UUID submitterID, Pageable pageable) {
        try {
            Context context = this.obtainContext();
            EPerson ep = this.epersonService.find(context, submitterID);
            long total = this.wis.countByEPerson(context, ep);
            List witems = this.wis.findByEPerson(context, ep, Integer.valueOf(pageable.getPageSize()), Integer.valueOf(Math.toIntExact(pageable.getOffset())));
            return this.converter.toRestPage(witems, pageable, total, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    protected WorkspaceItemRest createAndReturn(Context context) throws SQLException, AuthorizeException {
        WorkspaceItem source = this.submissionService.createWorkspaceItem(context, this.getRequestService().getCurrentRequest());
        return (WorkspaceItemRest)this.converter.toRest(source, this.utils.obtainProjection());
    }

    @Override
    public Class<WorkspaceItemRest> getDomainClass() {
        return WorkspaceItemRest.class;
    }

    @Override
    @PreAuthorize(value="hasPermission(#id, 'WORKSPACEITEM', 'WRITE')")
    public WorkspaceItemRest upload(HttpServletRequest request, String apiCategory, String model, Integer id, MultipartFile file) throws SQLException {
        Context context = this.obtainContext();
        WorkspaceItemRest wsi = this.findOne(context, id);
        WorkspaceItem source = this.wis.find(context, id.intValue());
        List<ErrorRest> errors = this.submissionService.uploadFileToInprogressSubmission(context, request, wsi, (InProgressSubmission)source, file);
        wsi = (WorkspaceItemRest)this.converter.toRest(source, this.utils.obtainProjection());
        if (!errors.isEmpty()) {
            wsi.getErrors().addAll(errors);
        }
        context.commit();
        return wsi;
    }

    @Override
    @PreAuthorize(value="hasPermission(#id, 'WORKSPACEITEM', 'WRITE')")
    public void patch(Context context, HttpServletRequest request, String apiCategory, String model, Integer id, Patch patch) throws SQLException, AuthorizeException {
        List<Operation> operations = patch.getOperations();
        WorkspaceItemRest wsi = this.findOne(context, id);
        WorkspaceItem source = this.wis.find(context, id.intValue());
        for (Operation op : operations) {
            String[] path = op.getPath().substring(1).split("/", 3);
            if (OPERATION_PATH_SECTIONS.equals(path[0])) {
                String section = path[1];
                this.submissionService.evaluatePatchToInprogressSubmission(context, request, (InProgressSubmission)source, wsi, section, op);
                continue;
            }
            throw new DSpaceBadRequestException("Patch path operation need to starts with 'sections'");
        }
        this.wis.update(context, (InProgressSubmission)source);
    }

    @Override
    @PreAuthorize(value="hasPermission(#id, 'WORKSPACEITEM', 'DELETE')")
    protected void delete(Context context, Integer id) throws AuthorizeException {
        WorkspaceItem witem = null;
        try {
            witem = this.wis.find(context, id.intValue());
            this.wis.deleteAll(context, witem);
            context.addEvent(new Event(32, 2, witem.getItem().getID(), null, this.itemService.getIdentifiers(context, (DSpaceObject)witem.getItem())));
        }
        catch (IOException | SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Iterable<WorkspaceItemRest> upload(Context context, HttpServletRequest request, List<MultipartFile> uploadfiles) throws SQLException, FileNotFoundException, IOException, AuthorizeException {
        ArrayList<WorkspaceItemRest> results = new ArrayList<WorkspaceItemRest>();
        String uuid = request.getParameter("owningCollection");
        if (StringUtils.isBlank((CharSequence)uuid)) {
            uuid = this.configurationService.getProperty("submission.default.collection");
        }
        Collection collection = null;
        collection = StringUtils.isNotBlank((CharSequence)uuid) ? (Collection)this.collectionService.find(context, UUID.fromString(uuid)) : (Collection)this.collectionService.findAuthorizedOptimized(context, 3).get(0);
        SubmissionConfig submissionConfig = this.submissionConfigService.getSubmissionConfigByCollection(collection.getHandle());
        ArrayList<WorkspaceItem> result = null;
        ArrayList<ImportRecord> records = new ArrayList<ImportRecord>();
        try {
            for (MultipartFile mpFile : uploadfiles) {
                File file = Utils.getFile(mpFile, "upload-loader", "filedataloader");
                try {
                    ImportRecord record = this.importService.getRecord(file, mpFile.getOriginalFilename());
                    if (record == null) continue;
                    records.add(record);
                    break;
                }
                catch (Exception e) {
                    log.error("Error processing data", (Throwable)e);
                    throw e;
                }
                finally {
                    file.delete();
                }
            }
        }
        catch (FileMultipleOccurencesException e) {
            throw new UnprocessableEntityException("Too many entries in file");
        }
        catch (Exception e) {
            log.error("Error importing metadata", (Throwable)e);
        }
        WorkspaceItem source = this.submissionService.createWorkspaceItem(context, this.getRequestService().getCurrentRequest());
        this.merge(context, records, source);
        result = new ArrayList<WorkspaceItem>();
        result.add(source);
        if (!result.isEmpty()) {
            for (WorkspaceItem wi : result) {
                ArrayList<ErrorRest> errors = new ArrayList<ErrorRest>();
                wi.setMultipleFiles(uploadfiles.size() > 1);
                if (result.size() == 1) {
                    for (int i = 0; i < submissionConfig.getNumberOfSteps(); ++i) {
                        SubmissionStepConfig stepConfig = submissionConfig.getStep(i);
                        ClassLoader loader = this.getClass().getClassLoader();
                        try {
                            Class<?> stepClass = loader.loadClass(stepConfig.getProcessingClassName());
                            Object stepInstance = stepClass.newInstance();
                            if (!UploadableStep.class.isAssignableFrom(stepClass)) continue;
                            UploadableStep uploadableStep = (UploadableStep)stepInstance;
                            for (MultipartFile mpFile : uploadfiles) {
                                ErrorRest err = uploadableStep.upload(context, this.submissionService, stepConfig, (InProgressSubmission)wi, mpFile);
                                if (err == null) continue;
                                errors.add(err);
                            }
                            continue;
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
                WorkspaceItemRest wsi = (WorkspaceItemRest)this.converter.toRest(wi, this.utils.obtainProjection());
                if (result.size() == 1 && !errors.isEmpty()) {
                    wsi.getErrors().addAll(errors);
                }
                results.add(wsi);
            }
        }
        return results;
    }

    @Override
    protected WorkspaceItemRest createAndReturn(Context context, List<String> stringList) throws AuthorizeException, SQLException, RepositoryMethodNotImplementedException {
        HttpServletRequest req = this.getRequestService().getCurrentRequest().getHttpServletRequest();
        WorkspaceItem workspaceItem = this.uriListHandlerService.handle(context, req, stringList, WorkspaceItem.class);
        return (WorkspaceItemRest)this.converter.toRest(workspaceItem, this.utils.obtainProjection());
    }

    @SearchRestMethod(name="item")
    public WorkspaceItemRest findByItemUuid(@Parameter(value="uuid", required=true) UUID itemUuid, Pageable pageable) {
        try {
            Context context = this.obtainContext();
            Item item = (Item)this.itemService.find(context, itemUuid);
            WorkspaceItem workspaceItem = this.wis.findByItem(context, item);
            if (workspaceItem == null) {
                return null;
            }
            if (!this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)workspaceItem.getItem(), 0)) {
                throw new AccessDeniedException("The current user does not have rights to view the WorkflowItem");
            }
            return (WorkspaceItemRest)this.converter.toRest(workspaceItem, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public WorkspaceItem findDomainObjectByPk(Context context, Integer id) throws SQLException {
        return this.wis.find(context, id.intValue());
    }

    @Override
    public Class<Integer> getPKClass() {
        return Integer.class;
    }

    private void merge(Context context, List<ImportRecord> records, WorkspaceItem item) throws SQLException {
        for (MetadataValue metadataValue : this.itemService.getMetadata((DSpaceObject)item.getItem(), "*", "*", "*", "*")) {
            this.itemService.clearMetadata(context, (DSpaceObject)item.getItem(), metadataValue.getMetadataField().getMetadataSchema().getNamespace(), metadataValue.getMetadataField().getElement(), metadataValue.getMetadataField().getQualifier(), metadataValue.getLanguage());
        }
        for (ImportRecord record : records) {
            if (record == null || record.getValueList() == null) continue;
            for (MetadatumDTO metadataValue : record.getValueList()) {
                this.itemService.addMetadata(context, (DSpaceObject)item.getItem(), metadataValue.getSchema(), metadataValue.getElement(), metadataValue.getQualifier(), null, metadataValue.getValue());
            }
        }
    }
}

