/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.step;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.step.DataIdentifiers;
import org.dspace.app.rest.submit.AbstractProcessingStep;
import org.dspace.app.rest.submit.SubmissionService;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.Context;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.identifier.DOI;
import org.dspace.identifier.DOIIdentifierProvider;
import org.dspace.identifier.Handle;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.factory.IdentifierServiceFactory;
import org.dspace.identifier.service.IdentifierService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.services.model.Request;
import org.springframework.beans.factory.annotation.Autowired;

public class ShowIdentifiersStep
extends AbstractProcessingStep {
    private static final Logger log = LogManager.getLogger(ShowIdentifiersStep.class);
    @Autowired(required=true)
    protected HandleService handleService;
    @Autowired(required=true)
    protected ContentServiceFactory contentServiceFactory;

    public DataIdentifiers getData(SubmissionService submissionService, InProgressSubmission obj, SubmissionStepConfig config) throws Exception {
        return this.getIdentifierData(obj);
    }

    private DataIdentifiers getIdentifierData(InProgressSubmission obj) {
        Context context = this.getContext();
        DataIdentifiers result = new DataIdentifiers();
        IdentifierService identifierService = IdentifierServiceFactory.getInstance().getIdentifierService();
        String[] defaultTypes = new String[]{"handle", "doi"};
        List<String> displayTypes = Arrays.asList(this.configurationService.getArrayProperty("identifiers.submission.display", defaultTypes));
        result.setDisplayTypes(displayTypes);
        String handle = identifierService.lookup(context, (DSpaceObject)obj.getItem(), Handle.class);
        DOI doi = null;
        String doiString = null;
        try {
            doi = IdentifierServiceFactory.getInstance().getDOIService().findDOIByDSpaceObject(context, (DSpaceObject)obj.getItem());
            if (doi != null && !DOIIdentifierProvider.MINTED.equals(doi.getStatus()) && !DOIIdentifierProvider.DELETED.equals(doi.getStatus())) {
                doiString = doi.getDoi();
            }
        }
        catch (SQLException e) {
            log.error(e.getMessage());
        }
        if (StringUtils.isNotEmpty(doiString)) {
            try {
                doiString = IdentifierServiceFactory.getInstance().getDOIService().DOIToExternalForm(doiString);
            }
            catch (IdentifierException e) {
                log.error("Error formatting DOI: " + doi);
            }
        }
        if (StringUtils.isNotEmpty((String)handle)) {
            handle = HandleServiceFactory.getInstance().getHandleService().getCanonicalForm(handle);
        }
        result.addIdentifier("doi", doiString, doi != null ? DOIIdentifierProvider.statusText[doi.getStatus()] : null);
        result.addIdentifier("handle", handle, null);
        return result;
    }

    private Context getContext() {
        Context context;
        Request currentRequest = DSpaceServicesFactory.getInstance().getRequestService().getCurrentRequest();
        if (currentRequest != null) {
            HttpServletRequest request = currentRequest.getHttpServletRequest();
            context = ContextUtil.obtainContext(request);
        } else {
            context = new Context();
        }
        return context;
    }

    @Override
    public void doPatchProcessing(Context context, HttpServletRequest currentRequest, InProgressSubmission source, Operation op, SubmissionStepConfig stepConf) throws Exception {
        log.warn("Not implemented");
    }
}

